/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.coreontology.axiom;

import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI1Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomVisitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class GCI1AxiomImpl
implements GCI1Axiom {
    private final int leftSubClass;
    private final int rightSubClass;
    private final int superClass;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    GCI1AxiomImpl(int leftSubClassId, int rightSubClassId, int rightClassId, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(annotations);
        this.leftSubClass = leftSubClassId;
        this.rightSubClass = rightSubClassId;
        this.superClass = rightClassId;
        this.annotations = annotations;
        this.hashCode = this.leftSubClass + (31 * this.rightSubClass + (31 * this.superClass + 31 * this.annotations.hashCode()));
    }

    @Override
    public <T> T accept(NormalizedIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GCI1Axiom)) {
            return false;
        }
        GCI1Axiom other = (GCI1Axiom)obj;
        return this.getLeftSubClass() == other.getLeftSubClass() && this.getRightSubClass() == other.getRightSubClass() && this.getSuperClass() == other.getSuperClass() && this.getAnnotations().equals(other.getAnnotations());
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.add(this.leftSubClass);
        ret.add(this.rightSubClass);
        ret.add(this.superClass);
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public int getLeftSubClass() {
        return this.leftSubClass;
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public int getRightSubClass() {
        return this.rightSubClass;
    }

    @Override
    public int getSuperClass() {
        return this.superClass;
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("SubClassOf*");
        sbuf.append("(");
        sbuf.append("ObjectIntersectionOf");
        sbuf.append("(");
        sbuf.append(this.getLeftSubClass());
        sbuf.append(" ");
        sbuf.append(this.getRightSubClass());
        sbuf.append(")");
        sbuf.append(" ");
        sbuf.append(this.getSuperClass());
        sbuf.append(")");
        return sbuf.toString();
    }
}

