/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.coreontology.axiom;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NominalAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomVisitor;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class NominalAxiomImpl
implements NominalAxiom {
    private final int classExpression;
    private final int individual;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    NominalAxiomImpl(int classId, int individualId, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(annotations);
        this.classExpression = classId;
        this.individual = individualId;
        this.annotations = annotations;
        this.hashCode = this.classExpression + 31 * (this.individual + 31 * this.annotations.hashCode());
    }

    @Override
    public <T> T accept(NormalizedIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NominalAxiom)) {
            return false;
        }
        NominalAxiom other = (NominalAxiom)obj;
        return this.getClassExpression() == other.getClassExpression() && this.getIndividual() == other.getIndividual() && this.getAnnotations().equals(other.getAnnotations());
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        return Collections.singleton(this.getClassExpression());
    }

    @Override
    public int getClassExpression() {
        return this.classExpression;
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public int getIndividual() {
        return this.individual;
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.singleton(this.getIndividual());
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("NominalAxiom*");
        sbuf.append("(");
        sbuf.append(this.getClassExpression());
        sbuf.append(" ");
        sbuf.append(this.getIndividual());
        sbuf.append(")");
        return sbuf.toString();
    }
}

