/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.coreontology.datatype;

import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

public class IntegerEntityManagerImpl
implements IntegerEntityManager {
    public static final String anonymousEntity = "AnonymousEntity";
    public static final String auxiliaryEntity = "AuxiliaryEntity";
    private final Map<IntegerEntityType, Set<Integer>> auxEntityMap = new HashMap<IntegerEntityType, Set<Integer>>();
    private final Set<Integer> auxEntitySet = new HashSet<Integer>();
    private final Set<Integer> auxInverseObjectPropertySet = new HashSet<Integer>();
    private final Map<Integer, Integer> auxNominalInvMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> auxNominalMap = new HashMap<Integer, Integer>();
    private int entityCounter = firstUsableIdentifier;
    private final Map<Integer, IntegerEntityType> entityTypeMap = new HashMap<Integer, IntegerEntityType>();
    private final Map<Integer, Integer> inverseObjectPropertyMap = new HashMap<Integer, Integer>();
    private final Map<Integer, String> nameMap = new HashMap<Integer, String>();
    private final Map<IntegerEntityType, Set<Integer>> nonAuxEntityMap = new HashMap<IntegerEntityType, Set<Integer>>();

    public IntegerEntityManagerImpl() {
        this.registerProperty(bottomClassId, IntegerEntityType.CLASS, false);
        this.registerProperty(topClassId, IntegerEntityType.CLASS, false);
        this.registerProperty(bottomObjectPropertyId, IntegerEntityType.OBJECT_PROPERTY, false);
        this.registerProperty(topObjectPropertyId, IntegerEntityType.OBJECT_PROPERTY, false);
        this.registerProperty(bottomDataPropertyId, IntegerEntityType.DATA_PROPERTY, false);
        this.registerProperty(topDataPropertyId, IntegerEntityType.DATA_PROPERTY, false);
    }

    @Override
    public Integer createAnonymousEntity(IntegerEntityType type, boolean auxiliary) {
        Objects.requireNonNull(type);
        Integer ret = this.entityCounter;
        ++this.entityCounter;
        this.registerProperty(ret, type, auxiliary);
        this.entityTypeMap.put(ret, type);
        return ret;
    }

    @Override
    public Integer createNamedEntity(IntegerEntityType type, String name, boolean auxiliary) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(name);
        Integer ret = this.createAnonymousEntity(type, auxiliary);
        this.nameMap.put(ret, name);
        return ret;
    }

    @Override
    public Integer createOrGetClassIdForIndividual(Integer individual) {
        Objects.requireNonNull(individual);
        Integer ret = this.auxNominalMap.get(individual);
        if (Objects.isNull(ret)) {
            ret = this.createAnonymousEntity(IntegerEntityType.CLASS, true);
            this.auxNominalInvMap.put(ret, individual);
            this.auxNominalMap.put(individual, ret);
        }
        return ret;
    }

    @Override
    public Integer createOrGetInverseObjectPropertyOf(Integer propertyId) throws IndexOutOfBoundsException {
        Objects.requireNonNull(propertyId);
        Integer ret = this.inverseObjectPropertyMap.get(propertyId);
        if (Objects.isNull(ret)) {
            ret = this.createAnonymousEntity(IntegerEntityType.OBJECT_PROPERTY, true);
            this.auxInverseObjectPropertySet.add(ret);
            this.inverseObjectPropertyMap.put(propertyId, ret);
            this.inverseObjectPropertyMap.put(ret, propertyId);
        }
        return ret;
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = this == o;
        if (!ret && o instanceof IntegerEntityManagerImpl) {
            IntegerEntityManagerImpl other = (IntegerEntityManagerImpl)o;
            ret = this.entityCounter == other.entityCounter && this.auxEntityMap.equals(other.auxEntityMap) && this.nonAuxEntityMap.equals(other.nonAuxEntityMap) && this.auxNominalMap.equals(other.auxNominalMap) && this.auxNominalInvMap.equals(other.auxNominalInvMap) && this.auxInverseObjectPropertySet.equals(other.inverseObjectPropertyMap) && this.nameMap.equals(other.nameMap) && this.inverseObjectPropertyMap.equals(other.inverseObjectPropertyMap);
        }
        return ret;
    }

    @Override
    public Set<Integer> getAuxiliaryInverseObjectProperties() {
        return Collections.unmodifiableSet(this.auxInverseObjectPropertySet);
    }

    @Override
    public Optional<Integer> getAuxiliaryNominal(Integer individual) {
        Objects.requireNonNull(individual);
        return Optional.ofNullable(this.auxNominalMap.get(individual));
    }

    @Override
    public Set<Integer> getAuxiliaryNominals() {
        return Collections.unmodifiableSet(this.auxNominalInvMap.keySet());
    }

    @Override
    public Set<Integer> getEntities(IntegerEntityType type) {
        Objects.requireNonNull(type);
        TreeSet<Integer> ret = new TreeSet();
        if (Objects.nonNull(this.nonAuxEntityMap.get((Object)type))) {
            ret.addAll((Collection)this.nonAuxEntityMap.get((Object)type));
        }
        if (Objects.nonNull(this.auxEntityMap.get((Object)type))) {
            ret.addAll((Collection)this.auxEntityMap.get((Object)type));
        }
        ret = Collections.unmodifiableSet(ret);
        return ret;
    }

    @Override
    public Set<Integer> getEntities(IntegerEntityType type, boolean auxiliary) {
        Objects.requireNonNull(type);
        Set<Integer> ret = auxiliary ? this.auxEntityMap.get((Object)type) : this.nonAuxEntityMap.get((Object)type);
        ret = Objects.isNull(ret) ? Collections.emptySet() : Collections.unmodifiableSet(ret);
        return ret;
    }

    @Override
    public Optional<Integer> getIndividual(Integer auxNominal) {
        Objects.requireNonNull(auxNominal);
        return Optional.ofNullable(this.auxNominalInvMap.get(auxNominal));
    }

    @Override
    public Set<Integer> getIndividuals() {
        return Collections.unmodifiableSet(this.auxNominalMap.keySet());
    }

    @Override
    public String getName(Integer identifier) {
        Objects.requireNonNull(identifier);
        if (!this.entityTypeMap.containsKey(identifier)) {
            throw new IndexOutOfBoundsException("Invalid identifier : " + identifier);
        }
        String ret = this.nameMap.get(identifier);
        if (Objects.isNull(ret)) {
            ret = this.auxEntitySet.contains(identifier) ? auxiliaryEntity + identifier : anonymousEntity + identifier;
        }
        return ret;
    }

    @Override
    public IntegerEntityType getType(Integer identifier) {
        Objects.requireNonNull(identifier);
        IntegerEntityType ret = this.entityTypeMap.get(identifier);
        if (Objects.isNull((Object)ret)) {
            throw new IndexOutOfBoundsException("Invalid identifier : " + identifier);
        }
        return ret;
    }

    public int hashCode() {
        return this.entityCounter + 31 * this.nonAuxEntityMap.hashCode();
    }

    @Override
    public boolean isAuxiliary(Integer identifier) {
        Objects.requireNonNull(identifier);
        if (!this.entityTypeMap.containsKey(identifier)) {
            throw new IndexOutOfBoundsException("Invalid identifier : " + identifier);
        }
        return this.auxEntitySet.contains(identifier);
    }

    @Override
    public boolean isEntity(Integer identifier) {
        Objects.requireNonNull(identifier);
        return this.entityTypeMap.containsKey(identifier);
    }

    @Override
    public boolean proposeInverseObjectPropertyOf(Integer firstProperty, Integer secondProperty) {
        Objects.requireNonNull(firstProperty);
        Objects.requireNonNull(secondProperty);
        boolean ret = false;
        Integer invFirstProperty = this.inverseObjectPropertyMap.get(firstProperty);
        Integer invSecondProperty = this.inverseObjectPropertyMap.get(secondProperty);
        if (Objects.isNull(invFirstProperty) && Objects.isNull(invSecondProperty)) {
            this.inverseObjectPropertyMap.put(firstProperty, secondProperty);
            this.inverseObjectPropertyMap.put(secondProperty, firstProperty);
            ret = true;
        }
        return ret;
    }

    private void registerProperty(Integer identifier, IntegerEntityType type, boolean auxiliary) {
        if (auxiliary) {
            this.auxEntitySet.add(identifier);
            Set<Integer> set = this.auxEntityMap.get((Object)type);
            if (Objects.isNull(set)) {
                set = new HashSet<Integer>();
                this.auxEntityMap.put(type, set);
            }
            set.add(identifier);
        } else {
            Set<Integer> set = this.nonAuxEntityMap.get((Object)type);
            if (Objects.isNull(set)) {
                set = new HashSet<Integer>();
                this.nonAuxEntityMap.put(type, set);
            }
            set.add(identifier);
        }
        this.entityTypeMap.put(identifier, type);
    }

    @Override
    public int size() {
        return this.entityCounter;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("[\n  entities: ");
        sbuf.append(this.entityCounter);
        sbuf.append("\n  names: ");
        sbuf.append(this.nameMap);
        sbuf.append("\n  non-auxiliary entities: ");
        sbuf.append(this.nonAuxEntityMap);
        sbuf.append("\n  auxiliary entities: ");
        sbuf.append(this.auxEntityMap);
        sbuf.append("\n  auxiliary inverse object properties: ");
        sbuf.append(this.auxInverseObjectPropertySet);
        sbuf.append("\n]\n");
        return sbuf.toString();
    }
}

