/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.util;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public final class OntologyUtils {
    private OntologyUtils() {
    }

    public static boolean containsUnreferencedEntity(@Nonnull OWLOntology ontology, @Nonnull OWLClassExpression desc) {
        OWLAPIPreconditions.checkNotNull((Object)ontology, (String)"ontology cannot be null");
        for (OWLEntity entity : ((OWLClassExpression)OWLAPIPreconditions.checkNotNull((Object)desc, (String)"desc cannot be null")).getSignature()) {
            assert (entity != null);
            if (ontology.containsEntityInSignature(entity) || entity instanceof OWLClass && (((OWLClass)entity).isOWLThing() || ((OWLClass)entity).isOWLNothing())) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static Set<OWLOntology> removeAxiom(@Nonnull OWLAxiom axiom, @Nonnull Set<OWLOntology> ontologies, @Nonnull OWLOntologyManager manager) {
        HashSet<OWLOntology> modifiedOnts = new HashSet<OWLOntology>();
        OWLAPIPreconditions.checkNotNull((Object)axiom, (String)"axiom cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)manager, (String)"manager cannot be null");
        for (OWLOntology ont : (Set)OWLAPIPreconditions.checkNotNull(ontologies, (String)"ontologies cannot be null")) {
            if (!ont.getAxioms().contains(axiom)) continue;
            modifiedOnts.add(ont);
            manager.applyChange((OWLOntologyChange)new RemoveAxiom(ont, axiom));
        }
        return modifiedOnts;
    }

    public static void addAxiom(@Nonnull OWLAxiom axiom, @Nonnull Set<OWLOntology> ontologies, @Nonnull OWLOntologyManager manager) {
        for (OWLOntology ont : (Set)OWLAPIPreconditions.checkNotNull(ontologies, (String)"ontologies cannot be null")) {
            assert (ont != null);
            ((OWLOntologyManager)OWLAPIPreconditions.checkNotNull((Object)manager, (String)"manager cannot be null")).applyChange((OWLOntologyChange)new AddAxiom(ont, (OWLAxiom)OWLAPIPreconditions.checkNotNull((Object)axiom, (String)"axiom cannot be null")));
        }
    }
}

