/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.heaps;

import com.carrotsearch.hppcrt.AbstractIntCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.IntContainer;
import com.carrotsearch.hppcrt.IntIntAssociativeContainer;
import com.carrotsearch.hppcrt.IntIntMap;
import com.carrotsearch.hppcrt.IntLookupContainer;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.IntCursor;
import com.carrotsearch.hppcrt.cursors.IntIntCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.IntIntPredicate;
import com.carrotsearch.hppcrt.predicates.IntPredicate;
import com.carrotsearch.hppcrt.procedures.IntIntProcedure;
import com.carrotsearch.hppcrt.procedures.IntProcedure;
import com.carrotsearch.hppcrt.strategies.IntComparator;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntIndexedHeapPriorityQueue
implements IntIntMap,
Cloneable {
    public int[] buffer;
    public int[] pq;
    protected int[] qp;
    protected int elementsCount;
    protected IntComparator comparator;
    protected int defaultValue = 0;
    protected final IteratorPool<IntIntCursor, EntryIterator> entryIteratorPool;

    public IntIndexedHeapPriorityQueue(IntComparator comp, int initialCapacity) {
        this.comparator = comp;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

            @Override
            public EntryIterator create() {
                return new EntryIterator();
            }

            @Override
            public void initialize(EntryIterator obj) {
                obj.cursor.index = 0;
                EntryIterator.access$002(obj, IntIndexedHeapPriorityQueue.this.buffer);
                obj.size = IntIndexedHeapPriorityQueue.this.elementsCount;
                EntryIterator.access$202(obj, IntIndexedHeapPriorityQueue.this.qp);
            }

            @Override
            public void reset(EntryIterator obj) {
                EntryIterator.access$202(obj, null);
                EntryIterator.access$002(obj, null);
            }
        });
    }

    public IntIndexedHeapPriorityQueue(IntComparator comp) {
        this(comp, 8);
    }

    public IntIndexedHeapPriorityQueue() {
        this(null, 8);
    }

    public IntIndexedHeapPriorityQueue(int initialCapacity) {
        this(null, initialCapacity);
    }

    public IntIndexedHeapPriorityQueue(IntIntAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    public static IntIndexedHeapPriorityQueue from(IntIntAssociativeContainer container) {
        return new IntIndexedHeapPriorityQueue(container);
    }

    public static IntIndexedHeapPriorityQueue from(int[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntIndexedHeapPriorityQueue heap = new IntIndexedHeapPriorityQueue(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            heap.put(keys[i], values[i]);
        }
        return heap;
    }

    @Override
    public void clear() {
        Arrays.fill(this.pq, 0);
        this.elementsCount = 0;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public int capacity() {
        return this.buffer.length - 1;
    }

    @Override
    public <T extends IntIntProcedure> T forEach(T procedure) {
        int[] buffer = this.buffer;
        int[] qp = this.qp;
        int size = this.elementsCount;
        for (int pos = 1; pos <= size; ++pos) {
            procedure.apply(qp[pos], buffer[pos]);
        }
        return procedure;
    }

    @Override
    public <T extends IntIntPredicate> T forEach(T predicate) {
        int[] buffer = this.buffer;
        int[] qp = this.qp;
        int size = this.elementsCount;
        for (int pos = 1; pos <= size && predicate.apply(qp[pos], buffer[pos]); ++pos) {
        }
        return predicate;
    }

    @Override
    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    @Override
    public int removeAll(IntContainer container) {
        int before = this.elementsCount;
        for (IntCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.elementsCount;
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        int[] pq = this.pq;
        int size = this.pq.length;
        int initialSize = this.elementsCount;
        for (int key = 0; key < size; ++key) {
            if (pq[key] <= 0 || !predicate.apply(key)) continue;
            this.remove(key);
        }
        return initialSize - this.elementsCount;
    }

    @Override
    public int removeAll(IntIntPredicate predicate) {
        int[] buffer = this.buffer;
        int[] pq = this.pq;
        int size = this.elementsCount;
        int initialSize = this.elementsCount;
        for (int key = 0; key < size; ++key) {
            int pos = pq[key];
            if (pos <= 0 || !predicate.apply(key, buffer[pos])) continue;
            this.remove(key);
        }
        return initialSize - this.elementsCount;
    }

    @Override
    public boolean putIfAbsent(int key, int value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public int putAll(IntIntAssociativeContainer container) {
        return this.putAll((Iterable<? extends IntIntCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends IntIntCursor> iterable) {
        int count = this.elementsCount;
        for (IntIntCursor intIntCursor : iterable) {
            this.put(intIntCursor.key, intIntCursor.value);
        }
        return this.elementsCount - count;
    }

    @Override
    public int put(int key, int element) {
        assert (key >= 0) : "Keys must be >= 0, but is " + key;
        if (key < this.pq.length && this.pq[key] > 0) {
            int previousValue = this.buffer[this.pq[key]];
            this.buffer[this.pq[key]] = element;
            this.sink(this.pq[key]);
            this.swim(this.pq[key]);
            return previousValue;
        }
        this.ensureBufferSpace(key);
        ++this.elementsCount;
        int count = this.elementsCount;
        this.buffer[count] = element;
        this.pq[key] = count;
        this.qp[count] = key;
        this.swim(count);
        return this.defaultValue;
    }

    @Override
    public int putOrAdd(int key, int putValue, int incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public int addTo(int key, int incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    public int top() {
        int elem = this.defaultValue;
        if (this.elementsCount > 0) {
            elem = this.buffer[1];
        }
        return elem;
    }

    public int topKey() {
        int key = -1;
        if (this.elementsCount > 0) {
            key = this.qp[1];
        }
        return key;
    }

    public int popTop() {
        int elem = this.defaultValue;
        if (this.elementsCount > 0) {
            elem = this.buffer[1];
            this.remove(this.qp[1]);
        }
        return elem;
    }

    @Override
    public int get(int key) {
        int elem = this.defaultValue;
        if (key < this.pq.length && this.pq[key] > 0) {
            elem = this.buffer[this.pq[key]];
        }
        return elem;
    }

    @Override
    public int remove(int key) {
        int deletedElement = this.defaultValue;
        int[] qp = this.qp;
        int[] pq = this.pq;
        int[] buffer = this.buffer;
        if (key < pq.length && pq[key] > 0) {
            int deletedPos = pq[key];
            deletedElement = buffer[deletedPos];
            if (deletedPos == this.elementsCount) {
                pq[key] = 0;
                --this.elementsCount;
            } else {
                int lastElementIndex = qp[this.elementsCount];
                buffer[deletedPos] = buffer[this.elementsCount];
                pq[lastElementIndex] = deletedPos;
                qp[deletedPos] = lastElementIndex;
                pq[key] = 0;
                --this.elementsCount;
                if (this.elementsCount > 1) {
                    this.sink(pq[lastElementIndex]);
                    this.swim(pq[lastElementIndex]);
                }
            }
        }
        return deletedElement;
    }

    public void updatePriority(int key) {
        if (key < this.pq.length && this.pq[key] > 0) {
            this.swim(this.pq[key]);
            this.sink(this.pq[key]);
        }
    }

    public void updateTopPriority() {
        if (this.elementsCount > 1) {
            this.sink(1);
        }
    }

    @Override
    public boolean containsKey(int key) {
        return key < this.pq.length && this.pq[key] > 0;
    }

    public int hashCode() {
        int h = 1;
        int size = this.pq.length;
        int[] buffer = this.buffer;
        int[] pq = this.pq;
        for (int index = 0; index < size; ++index) {
            if (pq[index] <= 0) continue;
            h = 31 * h + BitMixer.mix(index);
            h = 31 * h + BitMixer.mix(buffer[pq[index]]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            IntIndexedHeapPriorityQueue other = (IntIndexedHeapPriorityQueue)obj;
            if (other.size() != this.size()) {
                return false;
            }
            if (!(this.comparator == null && other.comparator == null || this.comparator != null && this.comparator.equals(other.comparator))) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                IntIntCursor c = (IntIntCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                int mineValue = c.value;
                int otherValue = other.get(c.key);
                if (mineValue == otherValue) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public IntIndexedHeapPriorityQueue clone() {
        IntIndexedHeapPriorityQueue cloned = new IntIndexedHeapPriorityQueue(this.comparator, 8);
        cloned.buffer = (int[])this.buffer.clone();
        cloned.pq = (int[])this.pq.clone();
        cloned.qp = (int[])this.qp.clone();
        cloned.defaultValue = this.defaultValue;
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public void updatePriorities() {
        if (this.comparator == null) {
            for (int k = this.elementsCount >> 1; k >= 1; --k) {
                this.sinkComparable(k);
            }
        } else {
            for (int k = this.elementsCount >> 1; k >= 1; --k) {
                this.sinkComparator(k);
            }
        }
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public String toString() {
        int[] buffer = this.buffer;
        int[] pq = this.pq;
        StringBuilder buff = new StringBuilder();
        buff.append("[");
        boolean first = true;
        for (int i = 0; i < pq.length; ++i) {
            if (pq[i] <= 0) continue;
            if (!first) {
                buff.append(", ");
            }
            buff.append(i);
            buff.append("=>");
            buff.append(buffer[pq[i]]);
            first = false;
        }
        buff.append("]");
        return buff.toString();
    }

    @Override
    public int getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(int defaultValue) {
        this.defaultValue = defaultValue;
    }

    public IntComparator comparator() {
        return this.comparator;
    }

    protected void ensureBufferSpace(int index) {
        int pqLen;
        int n = pqLen = this.pq == null ? 0 : this.pq.length;
        if (index > pqLen - 1) {
            int newPQSize = Math.max(index + 8, (int)((double)index * 1.5));
            try {
                int[] newPQIndex = new int[newPQSize];
                int[] newBuffer = new int[newPQSize + 1];
                int[] newQPIndex = new int[newPQSize + 1];
                if (pqLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                    System.arraycopy(this.pq, 0, newPQIndex, 0, this.pq.length);
                    System.arraycopy(this.qp, 0, newQPIndex, 0, this.qp.length);
                }
                this.buffer = newBuffer;
                this.pq = newPQIndex;
                this.qp = newQPIndex;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, pqLen, newPQSize);
            }
        }
    }

    private void sinkComparable(int k) {
        int N = this.elementsCount;
        int[] buffer = this.buffer;
        int[] pq = this.pq;
        int[] qp = this.qp;
        while (k << 1 <= N) {
            int child = k << 1;
            if (child < N && buffer[child] > buffer[child + 1]) {
                ++child;
            }
            if (buffer[k] <= buffer[child]) break;
            int tmp = buffer[k];
            buffer[k] = buffer[child];
            buffer[child] = tmp;
            int indexK = qp[k];
            int indexChild = qp[child];
            pq[indexK] = child;
            pq[indexChild] = k;
            qp[k] = indexChild;
            qp[child] = indexK;
            k = child;
        }
    }

    private void sinkComparator(int k) {
        int N = this.elementsCount;
        int[] buffer = this.buffer;
        int[] pq = this.pq;
        int[] qp = this.qp;
        IntComparator comp = this.comparator;
        while (k << 1 <= N) {
            int child = k << 1;
            if (child < N && comp.compare(buffer[child], buffer[child + 1]) > 0) {
                ++child;
            }
            if (comp.compare(buffer[k], buffer[child]) <= 0) break;
            int tmp = buffer[k];
            buffer[k] = buffer[child];
            buffer[child] = tmp;
            int indexK = qp[k];
            int indexChild = qp[child];
            pq[indexK] = child;
            pq[indexChild] = k;
            qp[k] = indexChild;
            qp[child] = indexK;
            k = child;
        }
    }

    private void swimComparable(int k) {
        int[] buffer = this.buffer;
        int[] pq = this.pq;
        int[] qp = this.qp;
        while (k > 1 && buffer[k >> 1] > buffer[k]) {
            int parent = k >> 1;
            int tmp = buffer[k];
            buffer[k] = buffer[parent];
            buffer[parent] = tmp;
            int indexK = qp[k];
            int indexParent = qp[parent];
            pq[indexK] = parent;
            pq[indexParent] = k;
            qp[k] = indexParent;
            qp[parent] = indexK;
            k = parent;
        }
    }

    private void swimComparator(int k) {
        int[] buffer = this.buffer;
        int[] pq = this.pq;
        int[] qp = this.qp;
        IntComparator comp = this.comparator;
        while (k > 1 && comp.compare(buffer[k >> 1], buffer[k]) > 0) {
            int parent = k >> 1;
            int tmp = buffer[k];
            buffer[k] = buffer[parent];
            buffer[parent] = tmp;
            int indexK = qp[k];
            int indexParent = qp[parent];
            pq[indexK] = parent;
            pq[indexParent] = k;
            qp[k] = indexParent;
            qp[parent] = indexK;
            k = parent;
        }
    }

    private void swim(int k) {
        if (this.comparator == null) {
            this.swimComparable(k);
        } else {
            this.swimComparator(k);
        }
    }

    private void sink(int k) {
        if (this.comparator == null) {
            this.sinkComparable(k);
        } else {
            this.sinkComparator(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeAllInternal(IntPredicate predicate) {
        int deleted = 0;
        int[] buffer = this.buffer;
        int[] qp = this.qp;
        int[] pq = this.pq;
        int lastElementIndex = -1;
        int elementsCount = this.elementsCount;
        int pos = 1;
        try {
            while (pos <= elementsCount) {
                if (predicate.apply(buffer[pos])) {
                    lastElementIndex = qp[elementsCount];
                    buffer[pos] = buffer[elementsCount];
                    pq[lastElementIndex] = pos;
                    pq[qp[pos]] = 0;
                    qp[pos] = lastElementIndex;
                    --elementsCount;
                    ++deleted;
                    continue;
                }
                ++pos;
            }
        }
        finally {
            this.elementsCount = elementsCount;
            this.updatePriorities();
        }
        return deleted;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        public final IntCursor cursor = new IntCursor();
        private int[] buffer;
        private int size;

        public ValuesIterator() {
            this.cursor.index = 0;
            this.buffer = IntIndexedHeapPriorityQueue.this.buffer;
            this.size = IntIndexedHeapPriorityQueue.this.size();
        }

        @Override
        protected IntCursor fetch() {
            if (this.cursor.index == this.size) {
                return (IntCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ int[] access$602(ValuesIterator x0, int[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractIntCollection {
        private final IntIndexedHeapPriorityQueue owner;
        private int currentOccurenceToBeRemoved;
        private final IntPredicate removeAllOccurencesPredicate;
        protected final IteratorPool<IntCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = IntIndexedHeapPriorityQueue.this;
            this.removeAllOccurencesPredicate = new IntPredicate(){

                public final boolean apply(int value) {
                    return value == ValuesCollection.this.currentOccurenceToBeRemoved;
                }
            };
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = 0;
                    ValuesIterator.access$602(obj, IntIndexedHeapPriorityQueue.this.buffer);
                    obj.size = IntIndexedHeapPriorityQueue.this.size();
                }

                @Override
                public void reset(ValuesIterator obj) {
                    ValuesIterator.access$602(obj, null);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(int value) {
            int[] buffer = this.owner.buffer;
            int size = this.owner.elementsCount;
            for (int pos = 1; pos <= size; ++pos) {
                if (buffer[pos] != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            int[] buffer = this.owner.buffer;
            int size = this.owner.elementsCount;
            for (int pos = 1; pos <= size; ++pos) {
                procedure.apply(buffer[pos]);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            int[] buffer = this.owner.buffer;
            int size = this.owner.elementsCount;
            for (int pos = 1; pos <= size && predicate.apply(buffer[pos]); ++pos) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(int e) {
            this.currentOccurenceToBeRemoved = e;
            return this.owner.removeAllInternal(this.removeAllOccurencesPredicate);
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            return this.owner.removeAllInternal(predicate);
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int[] toArray(int[] target) {
            System.arraycopy(this.owner.buffer, 1, target, 0, this.owner.elementsCount);
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<IntCursor> {
        public final IntCursor cursor = new IntCursor();
        private int[] pq;

        public KeysIterator() {
            this.cursor.value = -1;
            this.pq = IntIndexedHeapPriorityQueue.this.pq;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            for (i = this.cursor.value + 1; i < this.pq.length && this.pq[i] <= 0; ++i) {
            }
            if (i == this.pq.length) {
                return (IntCursor)this.done();
            }
            this.cursor.value = i;
            this.cursor.index = this.pq[i];
            return this.cursor;
        }

        static /* synthetic */ int[] access$302(KeysIterator x0, int[] x1) {
            x0.pq = x1;
            return x1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final IntIndexedHeapPriorityQueue owner;
        protected final IteratorPool<IntCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = IntIndexedHeapPriorityQueue.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.value = -1;
                    KeysIterator.access$302(obj, IntIndexedHeapPriorityQueue.this.pq);
                }

                @Override
                public void reset(KeysIterator obj) {
                    KeysIterator.access$302(obj, null);
                }
            });
        }

        @Override
        public boolean contains(int e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            int[] qp = this.owner.qp;
            int size = this.owner.elementsCount;
            for (int pos = 1; pos <= size; ++pos) {
                procedure.apply(qp[pos]);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            int[] qp = this.owner.qp;
            int size = this.owner.elementsCount;
            for (int pos = 1; pos <= size && predicate.apply(qp[pos]); ++pos) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(int e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public int[] toArray(int[] target) {
            int count = 0;
            int[] pq = this.owner.pq;
            int size = this.owner.pq.length;
            for (int key = 0; key < size; ++key) {
                if (pq[key] <= 0) continue;
                target[count] = key;
                ++count;
            }
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<IntIntCursor> {
        public final IntIntCursor cursor = new IntIntCursor();
        private int[] buffer;
        private int size;
        private int[] qp;

        public EntryIterator() {
            this.cursor.index = 0;
            this.buffer = IntIndexedHeapPriorityQueue.this.buffer;
            this.size = IntIndexedHeapPriorityQueue.this.size();
            this.qp = IntIndexedHeapPriorityQueue.this.qp;
        }

        @Override
        protected IntIntCursor fetch() {
            if (this.cursor.index == this.size) {
                return (IntIntCursor)this.done();
            }
            this.cursor.key = this.qp[++this.cursor.index];
            this.cursor.value = this.buffer[this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ int[] access$002(EntryIterator x0, int[] x1) {
            x0.buffer = x1;
            return x1;
        }

        static /* synthetic */ int[] access$202(EntryIterator x0, int[] x1) {
            x0.qp = x1;
            return x1;
        }
    }
}

