/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractIntCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractShortCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.ShortArrays;
import com.carrotsearch.hppcrt.ShortContainer;
import com.carrotsearch.hppcrt.ShortIntAssociativeContainer;
import com.carrotsearch.hppcrt.ShortIntMap;
import com.carrotsearch.hppcrt.ShortLookupContainer;
import com.carrotsearch.hppcrt.cursors.IntCursor;
import com.carrotsearch.hppcrt.cursors.ShortCursor;
import com.carrotsearch.hppcrt.cursors.ShortIntCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.IntPredicate;
import com.carrotsearch.hppcrt.predicates.ShortIntPredicate;
import com.carrotsearch.hppcrt.predicates.ShortPredicate;
import com.carrotsearch.hppcrt.procedures.IntProcedure;
import com.carrotsearch.hppcrt.procedures.ShortIntProcedure;
import com.carrotsearch.hppcrt.procedures.ShortProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortIntHashMap
implements ShortIntMap,
Cloneable {
    protected int defaultValue = 0;
    public short[] keys;
    public int[] values;
    public boolean allocatedDefaultKey = false;
    public int allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<ShortIntCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = ShortIntHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public ShortIntHashMap() {
        this(8);
    }

    public ShortIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public ShortIntHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public ShortIntHashMap(ShortIntAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public int put(short key, int value) {
        short existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                int previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        short[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                int oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(ShortIntAssociativeContainer container) {
        return this.putAll((Iterable<? extends ShortIntCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends ShortIntCursor> iterable) {
        int count = this.size();
        for (ShortIntCursor shortIntCursor : iterable) {
            this.put(shortIntCursor.key, shortIntCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(short key, int value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public int putOrAdd(short key, int putValue, int incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public int addTo(short key, int incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(short pendingKey, int pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != 0);
        short[] oldKeys = this.keys;
        int[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        short key = 0;
        int value = 0;
        int slot = -1;
        short[] keys = this.keys;
        int[] values = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == 0) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            short[] keys = new short[capacity];
            int[] values = new int[capacity];
            this.keys = keys;
            this.values = values;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public int remove(short key) {
        short existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                int previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        short[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                int value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        short[] keys = this.keys;
        int[] values = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            short existing = keys[slot];
            int existingValue = values[slot];
            if (existing == 0) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        --this.assigned;
    }

    @Override
    public int removeAll(ShortContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof ShortLookupContainer) {
            if (this.allocatedDefaultKey && other.contains((short)0)) {
                this.allocatedDefaultKey = false;
            }
            short[] keys = this.keys;
            int i = 0;
            while (i < keys.length) {
                short existing = keys[i];
                if (existing != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (ShortCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply((short)0)) {
            this.allocatedDefaultKey = false;
        }
        short[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            short existing = keys[i];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ShortIntPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply((short)0, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        short[] keys = this.keys;
        int[] values = this.values;
        int i = 0;
        while (i < keys.length) {
            short existing = keys[i];
            if (existing != 0 && predicate.apply(existing, values[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int get(short key) {
        short existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        short[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(short key) {
        short existing;
        if (key == 0) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        short[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        ShortArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = 0;
        if (this.allocatedDefaultKey) {
            h += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        short[] keys = this.keys;
        int[] values = this.values;
        int i = keys.length;
        while (--i >= 0) {
            short existing = keys[i];
            if (existing == 0) continue;
            h += BitMixer.mix(existing) ^ BitMixer.mix(values[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ShortIntHashMap other = (ShortIntHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                ShortIntCursor c = (ShortIntCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                int otherValue = other.get(c.key);
                if (c.value == otherValue) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends ShortIntProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply((short)0, this.allocatedDefaultKeyValue);
        }
        short[] keys = this.keys;
        int[] values = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short existing = keys[i];
            if (existing == 0) continue;
            procedure.apply(existing, values[i]);
        }
        return procedure;
    }

    @Override
    public <T extends ShortIntPredicate> T forEach(T predicate) {
        short existing;
        if (this.allocatedDefaultKey && !predicate.apply((short)0, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        short[] keys = this.keys;
        int[] values = this.values;
        for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == 0 || predicate.apply(existing, values[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public ShortIntHashMap clone() {
        ShortIntHashMap cloned = new ShortIntHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ShortIntCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static ShortIntHashMap from(short[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortIntHashMap map = new ShortIntHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static ShortIntHashMap from(ShortIntAssociativeContainer container) {
        return new ShortIntHashMap(container);
    }

    public static ShortIntHashMap newInstance() {
        return new ShortIntHashMap();
    }

    public static ShortIntHashMap newInstance(int initialCapacity, double loadFactor) {
        return new ShortIntHashMap(initialCapacity, loadFactor);
    }

    @Override
    public int getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(int defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        public final IntCursor cursor = new IntCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            if (this.cursor.index == ShortIntHashMap.this.values.length + 1) {
                if (ShortIntHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ShortIntHashMap.this.values.length;
                    this.cursor.value = ShortIntHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ShortIntHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ShortIntHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (IntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ShortIntHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractIntCollection {
        private final ShortIntHashMap owner;
        protected final IteratorPool<IntCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = ShortIntHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = ShortIntHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(int value) {
            if (this.owner.allocatedDefaultKey && value == this.owner.allocatedDefaultKeyValue) {
                return true;
            }
            short[] keys = this.owner.keys;
            int[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == 0 || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            short[] keys = this.owner.keys;
            int[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == 0) continue;
                procedure.apply(values[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            short[] keys = this.owner.keys;
            int[] values = this.owner.values;
            for (int slot = 0; slot < keys.length && (keys[slot] == 0 || predicate.apply(values[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(int e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && e == this.owner.allocatedDefaultKeyValue) {
                this.owner.allocatedDefaultKey = false;
            }
            short[] keys = this.owner.keys;
            int[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != 0 && e == values[slot]) {
                    ShortIntHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            short[] keys = this.owner.keys;
            int[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != 0 && predicate.apply(values[slot])) {
                    ShortIntHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int[] toArray(int[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            short[] keys = this.owner.keys;
            int[] values = this.owner.values;
            for (int i = 0; i < values.length; ++i) {
                if (keys[i] == 0) continue;
                target[count++] = values[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        public final ShortCursor cursor = new ShortCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ShortCursor fetch() {
            int i;
            if (this.cursor.index == ShortIntHashMap.this.keys.length + 1) {
                if (ShortIntHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ShortIntHashMap.this.keys.length;
                    this.cursor.value = 0;
                    return this.cursor;
                }
                this.cursor.index = ShortIntHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ShortIntHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ShortCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ShortIntHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortIntHashMap owner;
        protected final IteratorPool<ShortCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = ShortIntHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = ShortIntHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(short e) {
            return ShortIntHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply((short)0);
            }
            short[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0; --i) {
                short existing = keys[i];
                if (existing == 0) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            short existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply((short)0)) {
                return predicate;
            }
            short[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == 0 || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(short e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public short[] toArray(short[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0;
            }
            short[] keys = this.owner.keys;
            for (int i = 0; i < keys.length; ++i) {
                short existing = keys[i];
                if (existing == 0) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<ShortIntCursor> {
        public final ShortIntCursor cursor = new ShortIntCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ShortIntCursor fetch() {
            int i;
            if (this.cursor.index == ShortIntHashMap.this.keys.length + 1) {
                if (ShortIntHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ShortIntHashMap.this.keys.length;
                    this.cursor.key = 0;
                    this.cursor.value = ShortIntHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ShortIntHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ShortIntHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ShortIntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = ShortIntHashMap.this.keys[i];
            this.cursor.value = ShortIntHashMap.this.values[i];
            return this.cursor;
        }
    }
}

