/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.loading;

import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.util.concurrent.computation.SimpleInterrupter;

public class ComposedAxiomLoader
extends SimpleInterrupter
implements AxiomLoader {
    private final AxiomLoader firstLoader_;
    private final AxiomLoader secondLoader_;

    public ComposedAxiomLoader(AxiomLoader firstLoader, AxiomLoader secondLoader) {
        this.firstLoader_ = firstLoader;
        this.secondLoader_ = secondLoader;
    }

    @Override
    public void load(ElkAxiomProcessor axiomInserter, ElkAxiomProcessor axiomDeleter) throws ElkLoadingException {
        if (!this.firstLoader_.isLoadingFinished()) {
            this.firstLoader_.load(axiomInserter, axiomDeleter);
        }
        if (!this.secondLoader_.isLoadingFinished()) {
            this.secondLoader_.load(axiomInserter, axiomDeleter);
        }
    }

    @Override
    public void dispose() {
        this.firstLoader_.dispose();
        this.secondLoader_.dispose();
    }

    @Override
    public boolean isLoadingFinished() {
        return this.firstLoader_.isLoadingFinished() && this.secondLoader_.isLoadingFinished();
    }

    @Override
    public void setInterrupt(boolean flag) {
        super.setInterrupt(flag);
        this.firstLoader_.setInterrupt(flag);
        this.secondLoader_.setInterrupt(flag);
    }
}

