/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.properties;

import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainVisitor;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;
import org.semanticweb.elk.util.collections.ArrayHashSet;

class SuperPropertyExplorer
implements IndexedPropertyChainVisitor<Void> {
    private static final Logger LOGGER_ = Logger.getLogger(SuperPropertyExplorer.class);
    private final Set<IndexedPropertyChain> allSuperProperties_ = new ArrayHashSet<IndexedPropertyChain>();
    private final Queue<IndexedPropertyChain> toDoSuperProperties_ = new LinkedList<IndexedPropertyChain>();
    private final Set<IndexedPropertyChain> relevantSuperProperties_ = new ArrayHashSet<IndexedPropertyChain>();

    SuperPropertyExplorer(IndexedPropertyChain element) {
        this.toDo(element);
    }

    @Override
    public Void visit(IndexedObjectProperty element) {
        this.doCommon(element);
        for (IndexedBinaryPropertyChain chain : element.getLeftChains()) {
            SaturatedPropertyChain rightSaturation = chain.getRightProperty().getSaturated();
            if (rightSaturation == null || !rightSaturation.isDerivedReflexive()) continue;
            this.toDo(chain);
        }
        return null;
    }

    @Override
    public Void visit(IndexedBinaryPropertyChain element) {
        this.doCommon(element);
        return null;
    }

    public void doCommon(IndexedPropertyChain element) {
        for (IndexedPropertyChain indexedPropertyChain : element.getToldSuperProperties()) {
            this.toDo(indexedPropertyChain);
        }
        for (IndexedBinaryPropertyChain indexedBinaryPropertyChain : element.getRightChains()) {
            SaturatedPropertyChain leftSaturation = indexedBinaryPropertyChain.getLeftProperty().getSaturated();
            if (leftSaturation == null || !leftSaturation.isDerivedReflexive()) continue;
            this.toDo(indexedBinaryPropertyChain);
        }
    }

    private void toDo(IndexedPropertyChain element) {
        if (this.allSuperProperties_.add(element)) {
            this.toDoSuperProperties_.add(element);
            if (SaturatedPropertyChain.isRelevant(element)) {
                this.relevantSuperProperties_.add(element);
            }
        }
    }

    private void doAll() {
        IndexedPropertyChain next;
        while ((next = this.toDoSuperProperties_.poll()) != null) {
            next.accept(this);
        }
    }

    private Set<IndexedPropertyChain> getRelevantSuperProperties() {
        this.doAll();
        return this.relevantSuperProperties_;
    }

    static Set<IndexedPropertyChain> getRelevantSuperProperties(IndexedPropertyChain property) {
        Set<IndexedPropertyChain> result = new SuperPropertyExplorer(property).getRelevantSuperProperties();
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace(property + " relevant superproperties: " + result);
        }
        return result;
    }
}

