/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.semanticweb.elk.reasoner.incremental.IncrementalChangesInitialization;
import org.semanticweb.elk.reasoner.incremental.IncrementalStages;
import org.semanticweb.elk.reasoner.indexing.hierarchy.DifferentialIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.visitors.AbstractIndexedClassEntityVisitor;
import org.semanticweb.elk.reasoner.saturation.ExtendedSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.SaturationUtils;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.ChainableRule;
import org.semanticweb.elk.reasoner.stages.AbstractIncrementalChangesInitializationStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ClassTaxonomyState;
import org.semanticweb.elk.reasoner.stages.InstanceTaxonomyState;
import org.semanticweb.elk.util.collections.Operations;

public class IncrementalDeletionInitializationStage
extends AbstractIncrementalChangesInitializationStage {
    public IncrementalDeletionInitializationStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    protected IncrementalStages stage() {
        return IncrementalStages.DELETIONS_INIT;
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        DifferentialIndex diffIndex = this.reasoner.ontologyIndex;
        ChainableRule<Context> changedInitRules = null;
        Map<IndexedClassExpression, ChainableRule<Context>> changedRulesByCE = null;
        Collection<ArrayList<Context>> inputs = Collections.emptyList();
        changedInitRules = diffIndex.getRemovedContextInitRules();
        changedRulesByCE = diffIndex.getRemovedContextRulesByClassExpressions();
        if (changedInitRules != null || !changedRulesByCE.isEmpty()) {
            inputs = Operations.split(this.reasoner.saturationState.getContexts(), 8 * this.workerNo);
        }
        this.initialization = new IncrementalChangesInitialization(inputs, changedInitRules, changedRulesByCE, this.reasoner.saturationState, this.reasoner.getProcessExecutor(), this.stageStatistics_, this.workerNo, this.reasoner.getProgressMonitor());
        return true;
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        ConclusionVisitor<?> conclusionVisitor = SaturationUtils.addStatsToConclusionVisitor(this.stageStatistics_.getConclusionStatistics());
        ExtendedSaturationStateWriter satStateWriter = this.reasoner.saturationState.getExtendedWriter(conclusionVisitor);
        final ClassTaxonomyState.Writer taxStateWriter = this.reasoner.classTaxonomyState.getWriter();
        final InstanceTaxonomyState.Writer instanceTaxStateWriter = this.reasoner.instanceTaxonomyState.getWriter();
        AbstractIndexedClassEntityVisitor<Object> rootVisitor = new AbstractIndexedClassEntityVisitor<Object>(){

            @Override
            public Object visit(IndexedClass element) {
                taxStateWriter.markRemovedClass(element);
                return null;
            }

            @Override
            public Object visit(IndexedIndividual element) {
                instanceTaxStateWriter.markRemovedIndividual(element);
                return null;
            }
        };
        for (IndexedClassExpression ice : this.reasoner.ontologyIndex.getRemovedClassExpressions()) {
            if (ice.getContext() == null) continue;
            satStateWriter.initContext(ice.getContext());
            ice.getContext().setSaturated(false);
            ice.getContext().getRoot().accept(rootVisitor);
        }
        this.reasoner.ontologyIndex.clearDeletedRules();
        return true;
    }
}

