/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.semanticweb.elk.util.collections.DirectAccess;

public class ArrayHashSet<E>
extends AbstractSet<E>
implements Set<E>,
DirectAccess<E> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    transient E[] data;
    transient int size;
    int upperSize;
    int lowerSize;

    public ArrayHashSet(int initialCapacity) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.data = new Object[capacity];
        this.size = 0;
        this.upperSize = ArrayHashSet.computeUpperSize(capacity);
        this.lowerSize = ArrayHashSet.computeLowerSize(capacity);
    }

    public ArrayHashSet() {
        int capacity = 16;
        this.data = new Object[capacity];
        this.size = 0;
        this.upperSize = ArrayHashSet.computeUpperSize(capacity);
        this.lowerSize = ArrayHashSet.computeLowerSize(capacity);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private static int computeUpperSize(int capacity) {
        if (capacity > 64) {
            return 3 * capacity / 4;
        }
        return capacity;
    }

    private static int computeLowerSize(int capacity) {
        return capacity / 4;
    }

    private static int getIndex(Object o, int length) {
        return o.hashCode() & length - 1;
    }

    @Override
    public boolean contains(Object o) {
        int i;
        if (o == null) {
            throw new NullPointerException();
        }
        E[] data = this.data;
        int j = i = ArrayHashSet.getIndex(o, data.length);
        do {
            E probe;
            if ((probe = data[i]) == null) {
                return false;
            }
            if (o.equals(probe)) {
                return true;
            }
            if (i == 0) {
                i = data.length - 1;
                continue;
            }
            --i;
        } while (i != j);
        return false;
    }

    private boolean addElement(E[] data, E e) {
        int i = ArrayHashSet.getIndex(e, data.length);
        while (true) {
            E probe;
            if ((probe = data[i]) == null) {
                data[i] = e;
                return true;
            }
            if (e.equals(probe)) {
                return false;
            }
            if (i == 0) {
                i = data.length - 1;
                continue;
            }
            --i;
        }
    }

    private void shift(E[] data, int i) {
        int del = i;
        int j = i;
        while (true) {
            j = j == 0 ? data.length - 1 : --j;
            if (j == del) {
                data[del] = null;
                return;
            }
            E test = data[j];
            if (test == null) {
                data[del] = null;
                return;
            }
            int k = ArrayHashSet.getIndex(test, data.length);
            if (j < del ? j <= k && k < del : j <= k || k < del) continue;
            data[del] = test;
            del = j;
        }
    }

    private boolean removeElement(E[] data, Object o) {
        int i;
        int j = i = ArrayHashSet.getIndex(o, data.length);
        do {
            E probe;
            if ((probe = data[i]) == null) {
                return false;
            }
            if (o.equals(probe)) {
                this.shift(data, i);
                return true;
            }
            if (i == 0) {
                i = data.length - 1;
                continue;
            }
            --i;
        } while (i != j);
        return false;
    }

    private void stretch() {
        int oldCapacity = this.data.length;
        if (oldCapacity == 0x40000000) {
            throw new IllegalArgumentException("The set cannot grow beyond the capacity: 1073741824");
        }
        E[] oldData = this.data;
        int newCapacity = oldCapacity << 1;
        Object[] newData = new Object[newCapacity];
        for (int i = 0; i < oldCapacity; ++i) {
            E e = oldData[i];
            if (e == null) continue;
            this.addElement(newData, e);
        }
        this.data = newData;
        this.upperSize = ArrayHashSet.computeUpperSize(newCapacity);
        this.lowerSize = ArrayHashSet.computeLowerSize(newCapacity);
    }

    private void shrink() {
        int oldCapacity = this.data.length;
        if (oldCapacity == 1) {
            return;
        }
        E[] oldData = this.data;
        int newCapacity = oldCapacity >> 1;
        Object[] newData = new Object[newCapacity];
        for (int i = 0; i < oldCapacity; ++i) {
            E e = oldData[i];
            if (e == null) continue;
            this.addElement(newData, e);
        }
        this.data = newData;
        this.upperSize = ArrayHashSet.computeUpperSize(newCapacity);
        this.lowerSize = ArrayHashSet.computeLowerSize(newCapacity);
    }

    @Override
    public boolean add(E e) {
        boolean result;
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.size == this.upperSize) {
            this.stretch();
        }
        if (result = this.addElement(this.data, e)) {
            ++this.size;
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        boolean result = this.removeElement(this.data, o);
        if (result) {
            --this.size;
        }
        if (this.size == this.lowerSize) {
            this.shrink();
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove(o);
        }
        return modified;
    }

    @Override
    public Iterator<E> iterator() {
        return new ElementIterator();
    }

    @Override
    public void clear() {
        int capacity = this.data.length >> 2;
        if (capacity == 0) {
            capacity = 1;
        }
        this.size = 0;
        this.upperSize = ArrayHashSet.computeUpperSize(capacity);
        this.lowerSize = ArrayHashSet.computeLowerSize(capacity);
        this.data = new Object[capacity];
    }

    @Override
    public String toString() {
        return Arrays.toString(this.toArray());
    }

    @Override
    public E[] getRawData() {
        return this.data;
    }

    private class ElementIterator
    implements Iterator<E> {
        final E[] dataSnapshot;
        final int expectedSize;
        int cursor;
        E nextElement;

        ElementIterator() {
            this.expectedSize = ArrayHashSet.this.size;
            this.dataSnapshot = ArrayHashSet.this.data;
            this.cursor = 0;
            this.seekNext();
        }

        void seekNext() {
            while (this.cursor < this.dataSnapshot.length) {
                if ((this.nextElement = this.dataSnapshot[this.cursor++]) == null) continue;
                return;
            }
            this.nextElement = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public E next() {
            if (this.expectedSize != ArrayHashSet.this.size) {
                throw new ConcurrentModificationException();
            }
            if (this.nextElement == null) {
                throw new NoSuchElementException();
            }
            Object result = this.nextElement;
            this.seekNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

