/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.semanticweb.elk.util.collections.DirectAccess;

public class LazySetIntersection<E>
extends AbstractSet<E> {
    final Set<E> smallSet;
    final Set<E> largeSet;

    public LazySetIntersection(Set<E> firstSet, Set<E> secondSet) {
        if (firstSet.size() < secondSet.size()) {
            this.smallSet = firstSet;
            this.largeSet = secondSet;
        } else {
            this.smallSet = secondSet;
            this.largeSet = firstSet;
        }
    }

    @Override
    public Iterator<E> iterator() {
        try {
            return new RawSetIntersectionIterator(((DirectAccess)((Object)this.smallSet)).getRawData(), this.largeSet);
        }
        catch (ClassCastException e) {
            return new SetIntersectionIterator<E>(this.smallSet, this.largeSet);
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.smallSet.contains(o) && this.largeSet.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.smallSet.size();
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    static class RawSetIntersectionIterator<E>
    implements Iterator<E> {
        final E[] rawElements;
        final Set<E> elementChecker;
        int pos = 0;
        E next;

        RawSetIntersectionIterator(E[] rawElements, Set<E> checkingSet) {
            this.rawElements = rawElements;
            this.elementChecker = checkingSet;
            this.seekNext();
        }

        void seekNext() {
            while (this.pos < this.rawElements.length) {
                this.next = this.rawElements[this.pos++];
                if (this.next == null || !this.elementChecker.contains(this.next)) continue;
                return;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            E result = this.next;
            this.seekNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class SetIntersectionIterator<E>
    implements Iterator<E> {
        final Iterator<E> elementIterator;
        final Set<E> elementChecker;
        E next;

        SetIntersectionIterator(Set<E> iteratingSet, Set<E> checkingSet) {
            this.elementIterator = iteratingSet.iterator();
            this.elementChecker = checkingSet;
            this.seekNext();
        }

        void seekNext() {
            while (this.elementIterator.hasNext()) {
                this.next = this.elementIterator.next();
                if (!this.elementChecker.contains(this.next)) continue;
                return;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            E result = this.next;
            this.seekNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

