package org.semanticweb.elk.reasoner.taxonomy;
/*
 * #%L
 * ELK Reasoner
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2011 - 2013 Department of Computer Science, University of Oxford
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.util.Collections;
import java.util.Set;

import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;

/**
 * An {@link OrphanNode} with one member type node
 * 
 * @author "Yevgeny Kazakov"
 * 
 * @param <T>
 *            the type of objects in this node
 * @param <I>
 *            the type of instances of this node
 */
public class OrphanInstanceNode<T extends ElkObject, I extends ElkObject>
		extends OrphanNode<I> implements InstanceNode<T, I> {

	final OrphanTypeNode<T, I> typeNode;

	public OrphanInstanceNode(Set<I> instances, I canonicalInstance,
			OrphanTypeNode<T, I> typeNode) {
		super(instances, canonicalInstance);
		this.typeNode = typeNode;
	}

	@Override
	public Set<? extends OrphanTypeNode<T, I>> getDirectTypeNodes() {
		return Collections.singleton(typeNode);
	}

	@Override
	public Set<? extends OrphanTypeNode<T, I>> getAllTypeNodes() {
		return Collections.singleton(typeNode);
	}

}
