from office365.entity import Entity


class ThreatIntelligence(Entity):
    """
    Provides APIs to retrieve threat intelligence information, such as about a host or an article on a threat.

    The Microsoft Graph threat intelligence API delivers world-class threat intelligence to help protect your
    organization from modern cyber threats. Using threat intelligence APIs, you can identify adversaries and their
    operations, accelerate detection and remediation, and enhance your security investments and workflows.

    The threat intelligence API allows you to operationalize intelligence found within the user interface.
    This includes finished intelligence in the forms of articles and intel profiles, machine intelligence including
    indicators of compromise (IoCs) and reputation verdicts, and finally, enrichment data including passive DNS,
    cookies, components, and trackers.
    """
