# Generated by Django 5.0.9 on 2024-12-05 09:15

import django.db.models.deletion
from django.db import migrations, models
from tqdm import tqdm
from wbcore.contrib.directory.preferences import get_main_company


def clean_main_company(apps, schema_editor):
    Activity = apps.get_model("wbcrm", "Activity")
    main_company = get_main_company()
    Activity.companies.through.objects.filter(company_id=main_company.id).delete()


def compute_str(company):
    rep = company.computed_str
    if company.customer_status:
        rep += f" ({company.customer_status.title})"
    return rep


def create_through_relations(apps, schema_editor):
    Activity = apps.get_model("wbcrm", "Activity")
    ActivityCompanyThroughModel = apps.get_model("wbcrm", "ActivityCompanyThroughModel")
    qs = Activity.objects.all()
    for a in tqdm(qs, total=qs.count()):
        for c in a.companies.all():
            ActivityCompanyThroughModel.objects.create(
                activity=a, company=c, customer_status=c.customer_status, computed_str=compute_str(c)
            )


class Migration(migrations.Migration):
    dependencies = [
        ("directory", "0009_remove_entry_external_identfier_and_more"),
        ("wbcrm", "0015_alter_activity_type"),
    ]

    operations = [
        migrations.AlterField(
            model_name="activity",
            name="companies",
            field=models.ManyToManyField(
                blank=True,
                help_text="The list of companies other than the main company that participate in this activity",
                related_name="company_participates",
                to="directory.company",
                verbose_name="Participating Companies",
            ),
        ),
        migrations.RunPython(clean_main_company),
        migrations.CreateModel(
            name="ActivityCompanyThroughModel",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "activity",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="activity_companies",
                        to="wbcrm.activity",
                        verbose_name="Activity",
                    ),
                ),
                (
                    "company",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="activity_companies",
                        to="directory.company",
                        verbose_name="Company",
                    ),
                ),
                (
                    "customer_status",
                    models.ForeignKey(
                        blank=True,
                        help_text="The Customer Status at activity creation time",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="activity_companies",
                        to="directory.customerstatus",
                        verbose_name="Initial Customer Status",
                    ),
                ),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True, verbose_name="Name")),
            ],
        ),
        migrations.RunPython(create_through_relations),
        migrations.RemoveField(
            model_name="activity",
            name="companies",
        ),
        migrations.AddField(
            model_name="activity",
            name="companies",
            field=models.ManyToManyField(
                blank=True,
                help_text="The list of companies other than the main company that participate in this activity",
                related_name="company_participates",
                through="wbcrm.ActivityCompanyThroughModel",
                to="directory.company",
                verbose_name="Participating Companies",
            ),
        ),
    ]
