/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2jwt;

import com.teradata.tdgss.asn1.der.DER;
import com.teradata.tdgss.asn1.der.ListArray;
import com.teradata.tdgss.jgssp2jwt.JwtKeyExchange;
import com.teradata.tdgss.jgssp2jwt.JwtTokenHdr;

public class JwtEncryptedToken {
    private JwtTokenHdr tokenHeader = null;
    private JwtKeyExchange keyexchgParams = null;
    private byte[] encryptedPayLoad = null;

    public JwtTokenHdr getTokenHeader() {
        return this.tokenHeader;
    }

    public void setTokenHeader(JwtTokenHdr jwtTokenHdr) {
        this.tokenHeader = jwtTokenHdr;
    }

    public void setKeyexchgParams(JwtKeyExchange jwtKeyExchange) {
        this.keyexchgParams = jwtKeyExchange;
    }

    public void setEncryptedPayLoad(byte[] byArray) {
        this.encryptedPayLoad = byArray;
    }

    public JwtKeyExchange getKeyexchgParams() {
        return this.keyexchgParams;
    }

    public byte[] getEncryptedPayLoad() {
        return this.encryptedPayLoad;
    }

    public DER getDERObject() {
        ListArray listArray = new ListArray(DER.class);
        DER dER = new DER(2, listArray);
        if (null == this.tokenHeader) {
            throw new IllegalArgumentException("Argument TokenHeader is null");
        }
        DER dER2 = this.tokenHeader.getDERObject();
        dER.add(dER2);
        if (null == this.keyexchgParams) {
            throw new IllegalArgumentException("ArgumentKeyexchgParams is null");
        }
        dER2 = this.keyexchgParams.getDERObject();
        dER.add(dER2);
        if (null == this.encryptedPayLoad) {
            throw new IllegalArgumentException("Argument encrpayLoad is null");
        }
        dER2 = new DER(2, this.encryptedPayLoad);
        dER.add(dER2);
        return dER;
    }

    public void parseDERObject(DER dER) {
        if (2 != dER.getTagNumber()) {
            throw new IllegalArgumentException("Encrypted JWT not found");
        }
        DER dER2 = dER.getChildrenWithTag(0);
        if (dER2 == null) {
            throw new IllegalArgumentException("Token header not found");
        }
        this.tokenHeader = new JwtTokenHdr();
        this.tokenHeader.parseDERObject(dER2);
        DER dER3 = dER.getChildrenWithTag(1);
        if (dER3 == null) {
            throw new IllegalArgumentException("key exchange DH parameters not found");
        }
        this.keyexchgParams = new JwtKeyExchange();
        this.keyexchgParams.parseDERObject(dER3);
        DER dER4 = dER.getChildrenWithTag(2);
        if (dER4 == null) {
            throw new IllegalArgumentException("Encrypted Pay load not found");
        }
        this.encryptedPayLoad = dER4.getValueAsOctetString();
    }
}

