from xmpy_ctastrategy import (
    类_CTA策略模板,
    类_停止单,
    类_行情数据,
    类_K线数据,
    类_成交数据,
    类_委托数据,
    类_K线生成器,
    类_数组管理器
)

class 示例策略_技术指标合成教程(类_CTA策略模板):
    作者 = "bhzyxyqy"

    # 策略参数
    初始手数 = 0

    # 策略变量
    计数 = 0

    # 写入参数和变量列表的会分别写入到文件 cta_参数设置.json，cta_变量数据.json，没有写入列表的则不会
    参数列表 = ["初始手数"]
    变量列表 = ["计数"]

    def __init__(self, 类_CTA引擎, 策略名称, 合约标识, setting):
        """"""
        super().__init__(类_CTA引擎, 策略名称, 合约标识, setting)
        self.K线生成器 = 类_K线生成器(self.K线回调)
        # 重要提示：个人精力有限，技术指标没有全部进行测试验证计算准确度，要使用相应技术指标最好选取一些数据进行指标计算，经测试后再投入使用，以免计算有误影响盈利
        self.指标生成器 = 类_数组管理器()    # 为避免指标计算数字不够，默认传入100条K线，可自行选择合适数字填入

    def 初始化回调(self):
        self.记录日志("策略初始化回调")

    def 启动回调(self):
        self.记录日志("策略启动")

    def 停止回调(self):
        self.记录日志("策略停止")

    def 行情回调(self, tick: 类_行情数据):
        self.K线生成器.更新Tick(tick)

    def K线回调(self, K线: 类_K线数据):
        self.计数 += 1
        self.记录日志(f'K线当前计数：{self.计数}')

        指标生成器 = self.指标生成器
        指标生成器.更新K线(K线)
        if not 指标生成器.就绪标志:
            return

        简单移动平均_结果 = 指标生成器.简单移动平均(self.周期, 数组模式=True)
        指数移动平均_结果 = 指标生成器.指数移动平均(self.周期, 数组模式=True)
        自适应均线_结果 = 指标生成器.自适应均线(self.周期, 数组模式=True)
        加权移动平均_结果 = 指标生成器.加权移动平均(self.周期, 数组模式=True)

        绝对价格振荡_结果 = 指标生成器.绝对价格振荡(self.快周期, self.慢周期, self.移动平均类型, 数组模式=True)

        钱德动量摆动_结果 = 指标生成器.钱德动量摆动(self.周期, 数组模式=True)
        动量指标_结果 = 指标生成器.动量指标(self.周期, 数组模式=True)

        价格振荡百分比_结果 = 指标生成器.价格振荡百分比(self.快周期, self.慢周期, self.移动平均类型, 数组模式=True)

        变动率_结果 = 指标生成器.变动率(self.周期, 数组模式=True)
        变动率比_结果 = 指标生成器.变动率比(self.周期, 数组模式=True)
        变动率百分比_结果 = 指标生成器.变动率百分比(self.周期, 数组模式=True)
        变动率比100_结果 = 指标生成器.变动率比100(self.周期, 数组模式=True)
        三重指数均线_结果 = 指标生成器.三重指数均线(self.周期, 数组模式=True)

        标准差_结果 = 指标生成器.标准差(self.周期, 数组模式=True)  # 有个偏差有默认值

        能量潮指标_结果 = 指标生成器.能量潮指标(数组模式=True)

        商品通道指数_结果 = 指标生成器.商品通道指数(self.周期, 数组模式=True)
        平均真实波幅_结果 = 指标生成器.平均真实波幅(self.周期, 数组模式=True)
        归一化波幅_结果 = 指标生成器.归一化波幅(self.周期, 数组模式=True)
        相对强弱指数_结果 = 指标生成器.相对强弱指数(self.周期, 数组模式=True)

        MACD指标_结果 = 指标生成器.MACD指标(self.快周期, self.慢周期, self.信号周期, 数组模式=True)

        平均趋向指数_结果 = 指标生成器.平均趋向指数(self.周期, 数组模式=True)
        趋向指数_结果 = 指标生成器.趋向指数(self.周期, 数组模式=True)
        负向指标_结果 = 指标生成器.负向指标(self.周期, 数组模式=True)
        正向指标_结果 = 指标生成器.正向指标(self.周期, 数组模式=True)
        威廉指标_结果 = 指标生成器.威廉指标(self.周期, 数组模式=True)

        终极振荡器_结果 = 指标生成器.终极振荡器(数组模式=True)  # 有有默认值

        真实波动幅度_结果 = 指标生成器.真实波动幅度(数组模式=True)  # 有有默认值

        布林通道_结果 = 指标生成器.布林通道(self.周期, self.标准差倍数, 数组模式=True)

        肯特纳通道_结果 = 指标生成器.肯特纳通道(self.周期, self.波幅倍数, 数组模式=True)

        唐奇安通道_结果 = 指标生成器.唐奇安通道(self.周期, 数组模式=True)
        阿隆指标_结果 = 指标生成器.阿隆指标(self.周期, 数组模式=True)
        阿隆振荡器_结果 = 指标生成器.阿隆振荡器(self.周期, 数组模式=True)
        负向动向指标_结果 = 指标生成器.负向动向指标(self.周期, 数组模式=True)
        正向动向指标_结果 = 指标生成器.正向动向指标(self.周期, 数组模式=True)
        资金流量指数_结果 = 指标生成器.资金流量指数(self.周期, 数组模式=True)

        累积分布指标_结果 = 指标生成器.累积分布指标(数组模式=True)

        累积振荡指标_结果 = 指标生成器.累积振荡指标(self.快周期, self.慢周期, 数组模式=True)

        均势指标_结果 = 指标生成器.均势指标(数组模式=True)

        随机指标_结果 = 指标生成器.随机指标(10, 5, 1, 3, 1, 数组模式=True)
        抛物线指标_结果 = 指标生成器.抛物线指标(self.加速因子, self.极限值, 数组模式=True)

        self.记录日志(f'----------------------------------------------------------------------------')
        self.记录日志(f'简单移动平均_结果，：{简单移动平均_结果}')
        self.记录日志(f'指数移动平均_结果，：{指数移动平均_结果}')
        self.记录日志(f'自适应均线_结果，：{自适应均线_结果}')
        self.记录日志(f'加权移动平均_结果，：{加权移动平均_结果}')
        self.记录日志(f'绝对价格振荡_结果，：{绝对价格振荡_结果}')
        self.记录日志(f'钱德动量摆动_结果，：{钱德动量摆动_结果}')
        self.记录日志(f'动量指标_结果，：{动量指标_结果}')
        self.记录日志(f'价格振荡百分比_结果，：{价格振荡百分比_结果}')
        self.记录日志(f'变动率_结果，：{变动率_结果}')
        self.记录日志(f'变动率比_结果，：{变动率比_结果}')

        self.记录日志(f'变动率百分比_结果，：{变动率百分比_结果}')
        self.记录日志(f'变动率比100_结果，：{变动率比100_结果}')
        self.记录日志(f'三重指数均线_结果，：{三重指数均线_结果}')
        self.记录日志(f'标准差_结果，：{标准差_结果}')
        self.记录日志(f'商品通道指数_结果，：{商品通道指数_结果}')
        self.记录日志(f'平均真实波幅_结果，：{平均真实波幅_结果}')
        self.记录日志(f'归一化波幅_结果，：{归一化波幅_结果}')
        self.记录日志(f'相对强弱指数_结果，：{相对强弱指数_结果}')
        self.记录日志(f'MACD指标_结果，：{MACD指标_结果}')
        self.记录日志(f'平均趋向指数_结果，：{平均趋向指数_结果}')

        self.记录日志(f'趋向指数_结果，：{趋向指数_结果}')
        self.记录日志(f'负向指标_结果，：{负向指标_结果}')
        self.记录日志(f'正向指标_结果，：{正向指标_结果}')
        self.记录日志(f'威廉指标_结果，：{威廉指标_结果}')
        self.记录日志(f'终极振荡器_结果，：{终极振荡器_结果}')
        self.记录日志(f'真实波动幅度_结果，：{真实波动幅度_结果}')
        self.记录日志(f'布林通道_结果，：{布林通道_结果}')
        self.记录日志(f'肯特纳通道_结果，：{肯特纳通道_结果}')
        self.记录日志(f'唐奇安通道_结果，：{唐奇安通道_结果}')
        self.记录日志(f'阿隆指标_结果，：{阿隆指标_结果}')

        self.记录日志(f'阿隆振荡器_结果，：{阿隆振荡器_结果}')
        self.记录日志(f'负向动向指标_结果，：{负向动向指标_结果}')
        self.记录日志(f'正向动向指标_结果，：{正向动向指标_结果}')
        self.记录日志(f'资金流量指数_结果，：{资金流量指数_结果}')
        self.记录日志(f'累积分布指标_结果，：{累积分布指标_结果}')
        self.记录日志(f'累积振荡指标_结果，：{累积振荡指标_结果}')
        self.记录日志(f'均势指标_结果，：{均势指标_结果}')
        self.记录日志(f'随机指标_结果，：{随机指标_结果}')
        self.记录日志(f'抛物线指标_结果，：{抛物线指标_结果}')

    def 委托回调(self, 委托: 类_委托数据):
        self.记录日志(f'委托回报：{委托}')

    def 成交回调(self, 成交: 类_成交数据):
        self.记录日志(f'成交回报：{成交}')

    def 停止单回调(self, 停止单: 类_停止单):
        self.记录日志(f'停止单回调：{停止单}')
