import pytest
import doubledate as dtwo


@pytest.fixture
def calendar():
    dates = [
        "2014-11-27",
        "2014-12-25",
        "2015-01-01",
        "2015-01-19",
        "2015-02-16",
        "2015-04-03",
        "2015-05-25",
        "2015-07-03",
        "2015-09-07",
        "2015-11-26",
        "2015-12-25",
        "2016-01-01",
        "2016-01-18",
        "2016-02-15",
        "2016-03-25",
        "2016-05-30",
        "2016-07-04",
        "2016-09-05",
        "2016-11-24",
        "2016-12-26",
        "2017-01-02",
        "2017-01-16",
        "2017-02-20",
        "2017-04-14",
        "2017-05-29",
        "2017-07-04",
        "2017-09-04",
        "2017-11-23",
        "2017-12-25",
        "2018-01-01",
        "2018-01-15",
        "2018-02-19",
        "2018-03-30",
        "2018-05-28",
        "2018-07-04",
        "2018-09-03",
        "2018-11-22",
        "2018-12-05",
        "2018-12-25",
        "2019-01-01",
        "2019-01-21",
        "2019-02-18",
        "2019-04-19",
        "2019-05-27",
        "2019-07-04",
        "2019-09-02",
    ]

    return (
        dtwo.Calendar([dtwo.utils.parse(d, dayfirst=False) for d in dates])
        .inverse(starting=dtwo.date(2014, 11, 17), ending=dtwo.date(2019, 11, 15))
        .weekdays()
    )
