# -*- coding: utf-8 -*-
import re
from threading import Thread
import time
import datetime

__author__ = 'mbbn'

import pkg_resources

from BaseHTTPServer import HTTPServer
from SimpleHTTPServer import SimpleHTTPRequestHandler
from SocketServer import ThreadingMixIn
from robot.api import logger


class HTTPDLibrary(object):
    """

    """
    ROBOT_LIBRARY_SCOPE = 'TEST CASE'
    __version__ = pkg_resources.get_distribution("robotframework-httpd").version

    def __init__(self, port, hostname='0.0.0.0'):
        self.port = port
        self.hostname = hostname
        logger.info("init httpd\n",also_console=True)


    def run_server(self, httpd_server, port):
        try:
            logger.info("Start Http Server with port {}.".format(port), also_console=True)
            httpd_server.serve_forever()
        except KeyboardInterrupt:
            pass

        logger.info("Http Server with port {} is stop.".format(port), also_console=True)
        httpd_server.shutdown()

    def create_httpd(self):
        self.httpd = ThreadedHTTPD((self.hostname, int(self.port)), RequestHandler)
        self.httpd.wished_request = self.wished_request
        self.httpd.request_count = 0
        self.httpd.fails = []
        self.httpd.fails = []

    def start_httpd(self):
        try:
            getattr(self , httpd)
        except  NameError:
            self.create_httpd()

        t = Thread(name=self.port, target=self.run_server, args=(self.httpd, self.port))
        t.daemon = True
        t.start()
        time.sleep(1)

    def stop_httpd(self):
        self.httpd.shutdown()

    def set_wished_request(self, wished_request):
        self.wished_request = wished_request

    def wait_to_receive_request(self, timeout=10):
        start = datetime.datetime.now()
        while datetime.datetime.now() < start + datetime.timedelta(seconds=int(timeout)):
            if len(self.httpd.fails) > 0:
                raise Exception(str(self.httpd.fails))
            # true_all = True
            # for key, value in self.httpd.wished_request.items():
            #     if value != True:
            #         true_all = False
            # if true_all:
            #     break
            if self.httpd.request_count > 0:
                return

        # if datetime.datetime.now() > start + datetime.timedelta(seconds=int(timeout)):
        self.stop_httpd()
        raise Exception("Not Received Request after {} sec.".format(timeout))

    def wait_to_not_receive_request(self, timeout=10):
        start = datetime.datetime.now()
        while datetime.datetime.now() < start + datetime.timedelta(seconds=int(timeout)):
            if self.httpd.request_count > 0 or len(self.httpd.fails) > 0:
                t = datetime.datetime.now() - start
                exceptionError = "Server with port {} received {} request after {}" \
                                 "".format(self.port, self.httpd.request_count, t)
                self.stop_httpd()
                raise Exception(exceptionError)

    def delay_run_httpd(self, delay_time):
        time.sleep(float(delay_time))
        try:
            getattr(self , httpd)
        except  NameError:
            self.create_httpd()
        self.run_server(self.httpd, self.port)

    def delay_to_start_httpd(self, delay_time):
        t = Thread(name=self.port, target=self.delay_run_httpd, args=(delay_time,))
        t.daemon = True
        t.start()

    def delay_stop_httpd(self, delay_time):
        time.sleep(float(delay_time))
        self.httpd.shutdown()
        del self.httpd

    def delay_to_stop_httpd(self, delay_time):
        t = Thread(name=self.port, target=self.delay_stop_httpd, args=(delay_time,))
        t.daemon = True
        t.start()


class ThreadedHTTPD(ThreadingMixIn, HTTPServer):

    wished_request = None
    fails = None
    request_count = 0

    def verify_request(self, request, client_address):
        self.request_count += 1
        return HTTPServer.verify_request(self, request, client_address)


    def shutdown(self):
        HTTPServer.shutdown(self)

    def server_close(self):
        HTTPServer.server_close(self)

    def validate_request(self, method, path=None, body=None):
        wished_request = self.wished_request
        response_code = 200

        # check request method
        if wished_request["method"] != method:
            self.fails += ["Received method Not Equal Wished method.\n{} != {}"
                           "".format(method, wished_request["method"])]
            # wished_request["method"] = False
            response_code = 400
        else:
            pass
            # wished_request["method"] = True

        # check request path
        if "path" in wished_request:
            if wished_request["path"] != path:
                self.fails += ["Received Path Not Equal Wished path.    "
                               "\"{}\" != \"{}\""
                               "".format(path, wished_request["path"])]
                # wished_request["path"] = False
                response_code = 400
            else:
                pass
                # wished_request["path"] = True

        # check request post_body
        if "body" in wished_request:
            if not re.match(wished_request["body"], body):
                self.fails += ["Received body Not Equal Wished body.    "
                               "\"{}\" != \"{}\""
                               "".format(body, wished_request["body"])]
                # wished_request["body"] = False
                response_code = 400
            else:
                pass
                # wished_request["body"] = True
        if response_code==200:
            self.request_count +=1

        return response_code

    def shutdown_request(self, request):
        HTTPServer.shutdown_request(self, request)

    def close_request(self, request):
        HTTPServer.close_request(self, request)


class RequestHandler(SimpleHTTPRequestHandler):
    def __init__(self, request, client_address, server):
        SimpleHTTPRequestHandler.__init__(self, request, client_address, server)

    def do_GET(self):
        """Respond to a GET request."""
        content_len = int(self.headers.getheader('content-length', 0))
        body = self.rfile.read(content_len)
        response_code = self.server.validate_request("GET", self.path, body)
        self.send_response(response_code)

    def do_POST(self):
        """Respond to a POST request."""
        content_len = int(self.headers.getheader('content-length', 0))
        body = self.rfile.read(content_len)
        response = self.server.validate_request("POST", self.path, body)
        self.send_response(response)

    def log_message(self, format, *args):
        pass

if __name__ == "__main__":
    http = HTTPDLibrary(5060)
    wished_request = {
        "method": "POST",
        "path": "/test",
        "body": "aadsa?d",

    }
    http.set_wished_request(wished_request)
