# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOsnResult',
    'AwaitableGetOsnResult',
    'get_osn',
    'get_osn_output',
]

@pulumi.output_type
class GetOsnResult:
    """
    A collection of values returned by getOsn.
    """
    def __init__(__self__, ad=None, blockchain_platform_id=None, id=None, ocpu_allocation_params=None, osn_id=None, osn_key=None, state=None):
        if ad and not isinstance(ad, str):
            raise TypeError("Expected argument 'ad' to be a str")
        pulumi.set(__self__, "ad", ad)
        if blockchain_platform_id and not isinstance(blockchain_platform_id, str):
            raise TypeError("Expected argument 'blockchain_platform_id' to be a str")
        pulumi.set(__self__, "blockchain_platform_id", blockchain_platform_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ocpu_allocation_params and not isinstance(ocpu_allocation_params, list):
            raise TypeError("Expected argument 'ocpu_allocation_params' to be a list")
        pulumi.set(__self__, "ocpu_allocation_params", ocpu_allocation_params)
        if osn_id and not isinstance(osn_id, str):
            raise TypeError("Expected argument 'osn_id' to be a str")
        pulumi.set(__self__, "osn_id", osn_id)
        if osn_key and not isinstance(osn_key, str):
            raise TypeError("Expected argument 'osn_key' to be a str")
        pulumi.set(__self__, "osn_key", osn_key)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def ad(self) -> str:
        """
        Availability Domain of OSN
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter(name="blockchainPlatformId")
    def blockchain_platform_id(self) -> str:
        return pulumi.get(self, "blockchain_platform_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ocpuAllocationParams")
    def ocpu_allocation_params(self) -> Sequence['outputs.GetOsnOcpuAllocationParamResult']:
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_params")

    @property
    @pulumi.getter(name="osnId")
    def osn_id(self) -> str:
        return pulumi.get(self, "osn_id")

    @property
    @pulumi.getter(name="osnKey")
    def osn_key(self) -> str:
        """
        OSN identifier
        """
        return pulumi.get(self, "osn_key")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the OSN.
        """
        return pulumi.get(self, "state")


class AwaitableGetOsnResult(GetOsnResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOsnResult(
            ad=self.ad,
            blockchain_platform_id=self.blockchain_platform_id,
            id=self.id,
            ocpu_allocation_params=self.ocpu_allocation_params,
            osn_id=self.osn_id,
            osn_key=self.osn_key,
            state=self.state)


def get_osn(blockchain_platform_id: Optional[str] = None,
            osn_id: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOsnResult:
    """
    This data source provides details about a specific Osn resource in Oracle Cloud Infrastructure Blockchain service.

    Gets information about an OSN identified by the specific id

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_osn = oci.Blockchain.get_osn(blockchain_platform_id=test_blockchain_platform["id"],
        osn_id=test_osn_oci_blockchain_osn["id"])
    ```


    :param str blockchain_platform_id: Unique service identifier.
    :param str osn_id: OSN identifier.
    """
    __args__ = dict()
    __args__['blockchainPlatformId'] = blockchain_platform_id
    __args__['osnId'] = osn_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Blockchain/getOsn:getOsn', __args__, opts=opts, typ=GetOsnResult).value

    return AwaitableGetOsnResult(
        ad=pulumi.get(__ret__, 'ad'),
        blockchain_platform_id=pulumi.get(__ret__, 'blockchain_platform_id'),
        id=pulumi.get(__ret__, 'id'),
        ocpu_allocation_params=pulumi.get(__ret__, 'ocpu_allocation_params'),
        osn_id=pulumi.get(__ret__, 'osn_id'),
        osn_key=pulumi.get(__ret__, 'osn_key'),
        state=pulumi.get(__ret__, 'state'))
def get_osn_output(blockchain_platform_id: Optional[pulumi.Input[str]] = None,
                   osn_id: Optional[pulumi.Input[str]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOsnResult]:
    """
    This data source provides details about a specific Osn resource in Oracle Cloud Infrastructure Blockchain service.

    Gets information about an OSN identified by the specific id

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_osn = oci.Blockchain.get_osn(blockchain_platform_id=test_blockchain_platform["id"],
        osn_id=test_osn_oci_blockchain_osn["id"])
    ```


    :param str blockchain_platform_id: Unique service identifier.
    :param str osn_id: OSN identifier.
    """
    __args__ = dict()
    __args__['blockchainPlatformId'] = blockchain_platform_id
    __args__['osnId'] = osn_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Blockchain/getOsn:getOsn', __args__, opts=opts, typ=GetOsnResult)
    return __ret__.apply(lambda __response__: GetOsnResult(
        ad=pulumi.get(__response__, 'ad'),
        blockchain_platform_id=pulumi.get(__response__, 'blockchain_platform_id'),
        id=pulumi.get(__response__, 'id'),
        ocpu_allocation_params=pulumi.get(__response__, 'ocpu_allocation_params'),
        osn_id=pulumi.get(__response__, 'osn_id'),
        osn_key=pulumi.get(__response__, 'osn_key'),
        state=pulumi.get(__response__, 'state')))
