# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetIpsecConnectionTunnelResult',
    'AwaitableGetIpsecConnectionTunnelResult',
    'get_ipsec_connection_tunnel',
    'get_ipsec_connection_tunnel_output',
]

@pulumi.output_type
class GetIpsecConnectionTunnelResult:
    """
    A collection of values returned by getIpsecConnectionTunnel.
    """
    def __init__(__self__, associated_virtual_circuits=None, bgp_session_infos=None, compartment_id=None, cpe_ip=None, display_name=None, dpd_configs=None, dpd_mode=None, dpd_timeout_in_sec=None, encryption_domain_configs=None, id=None, ike_version=None, ipsec_id=None, nat_translation_enabled=None, oracle_can_initiate=None, phase_one_details=None, phase_two_details=None, routing=None, shared_secret=None, state=None, status=None, time_created=None, time_status_updated=None, tunnel_id=None, vpn_ip=None):
        if associated_virtual_circuits and not isinstance(associated_virtual_circuits, list):
            raise TypeError("Expected argument 'associated_virtual_circuits' to be a list")
        pulumi.set(__self__, "associated_virtual_circuits", associated_virtual_circuits)
        if bgp_session_infos and not isinstance(bgp_session_infos, list):
            raise TypeError("Expected argument 'bgp_session_infos' to be a list")
        pulumi.set(__self__, "bgp_session_infos", bgp_session_infos)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if cpe_ip and not isinstance(cpe_ip, str):
            raise TypeError("Expected argument 'cpe_ip' to be a str")
        pulumi.set(__self__, "cpe_ip", cpe_ip)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dpd_configs and not isinstance(dpd_configs, list):
            raise TypeError("Expected argument 'dpd_configs' to be a list")
        pulumi.set(__self__, "dpd_configs", dpd_configs)
        if dpd_mode and not isinstance(dpd_mode, str):
            raise TypeError("Expected argument 'dpd_mode' to be a str")
        pulumi.set(__self__, "dpd_mode", dpd_mode)
        if dpd_timeout_in_sec and not isinstance(dpd_timeout_in_sec, int):
            raise TypeError("Expected argument 'dpd_timeout_in_sec' to be a int")
        pulumi.set(__self__, "dpd_timeout_in_sec", dpd_timeout_in_sec)
        if encryption_domain_configs and not isinstance(encryption_domain_configs, list):
            raise TypeError("Expected argument 'encryption_domain_configs' to be a list")
        pulumi.set(__self__, "encryption_domain_configs", encryption_domain_configs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ike_version and not isinstance(ike_version, str):
            raise TypeError("Expected argument 'ike_version' to be a str")
        pulumi.set(__self__, "ike_version", ike_version)
        if ipsec_id and not isinstance(ipsec_id, str):
            raise TypeError("Expected argument 'ipsec_id' to be a str")
        pulumi.set(__self__, "ipsec_id", ipsec_id)
        if nat_translation_enabled and not isinstance(nat_translation_enabled, str):
            raise TypeError("Expected argument 'nat_translation_enabled' to be a str")
        pulumi.set(__self__, "nat_translation_enabled", nat_translation_enabled)
        if oracle_can_initiate and not isinstance(oracle_can_initiate, str):
            raise TypeError("Expected argument 'oracle_can_initiate' to be a str")
        pulumi.set(__self__, "oracle_can_initiate", oracle_can_initiate)
        if phase_one_details and not isinstance(phase_one_details, list):
            raise TypeError("Expected argument 'phase_one_details' to be a list")
        pulumi.set(__self__, "phase_one_details", phase_one_details)
        if phase_two_details and not isinstance(phase_two_details, list):
            raise TypeError("Expected argument 'phase_two_details' to be a list")
        pulumi.set(__self__, "phase_two_details", phase_two_details)
        if routing and not isinstance(routing, str):
            raise TypeError("Expected argument 'routing' to be a str")
        pulumi.set(__self__, "routing", routing)
        if shared_secret and not isinstance(shared_secret, str):
            raise TypeError("Expected argument 'shared_secret' to be a str")
        pulumi.set(__self__, "shared_secret", shared_secret)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_status_updated and not isinstance(time_status_updated, str):
            raise TypeError("Expected argument 'time_status_updated' to be a str")
        pulumi.set(__self__, "time_status_updated", time_status_updated)
        if tunnel_id and not isinstance(tunnel_id, str):
            raise TypeError("Expected argument 'tunnel_id' to be a str")
        pulumi.set(__self__, "tunnel_id", tunnel_id)
        if vpn_ip and not isinstance(vpn_ip, str):
            raise TypeError("Expected argument 'vpn_ip' to be a str")
        pulumi.set(__self__, "vpn_ip", vpn_ip)

    @property
    @pulumi.getter(name="associatedVirtualCircuits")
    def associated_virtual_circuits(self) -> Sequence[str]:
        return pulumi.get(self, "associated_virtual_circuits")

    @property
    @pulumi.getter(name="bgpSessionInfos")
    def bgp_session_infos(self) -> Sequence['outputs.GetIpsecConnectionTunnelBgpSessionInfoResult']:
        """
        Information needed to establish a BGP Session on an interface.
        """
        return pulumi.get(self, "bgp_session_infos")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the tunnel.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpeIp")
    def cpe_ip(self) -> str:
        """
        The IP address of Cpe headend.  Example: `129.146.17.50`
        """
        return pulumi.get(self, "cpe_ip")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dpdConfigs")
    def dpd_configs(self) -> Sequence['outputs.GetIpsecConnectionTunnelDpdConfigResult']:
        return pulumi.get(self, "dpd_configs")

    @property
    @pulumi.getter(name="dpdMode")
    def dpd_mode(self) -> str:
        """
        Dead peer detection (DPD) mode set on the Oracle side of the connection.
        """
        return pulumi.get(self, "dpd_mode")

    @property
    @pulumi.getter(name="dpdTimeoutInSec")
    def dpd_timeout_in_sec(self) -> int:
        """
        DPD timeout in seconds.
        """
        return pulumi.get(self, "dpd_timeout_in_sec")

    @property
    @pulumi.getter(name="encryptionDomainConfigs")
    def encryption_domain_configs(self) -> Sequence['outputs.GetIpsecConnectionTunnelEncryptionDomainConfigResult']:
        """
        Configuration information used by the encryption domain policy.
        """
        return pulumi.get(self, "encryption_domain_configs")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The tunnel's Oracle ID (OCID).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> str:
        """
        Internet Key Exchange protocol version.
        """
        return pulumi.get(self, "ike_version")

    @property
    @pulumi.getter(name="ipsecId")
    def ipsec_id(self) -> str:
        return pulumi.get(self, "ipsec_id")

    @property
    @pulumi.getter(name="natTranslationEnabled")
    def nat_translation_enabled(self) -> str:
        """
        By default (the `AUTO` setting), IKE sends packets with a source and destination port set to 500, and when it detects that the port used to forward packets has changed (most likely because a NAT device is between the CPE device and the Oracle VPN headend) it will try to negotiate the use of NAT-T.
        """
        return pulumi.get(self, "nat_translation_enabled")

    @property
    @pulumi.getter(name="oracleCanInitiate")
    def oracle_can_initiate(self) -> str:
        """
        Indicates whether Oracle can only respond to a request to start an IPSec tunnel from the CPE device, or both respond to and initiate requests.
        """
        return pulumi.get(self, "oracle_can_initiate")

    @property
    @pulumi.getter(name="phaseOneDetails")
    def phase_one_details(self) -> Sequence['outputs.GetIpsecConnectionTunnelPhaseOneDetailResult']:
        """
        IPSec tunnel details specific to ISAKMP phase one.
        """
        return pulumi.get(self, "phase_one_details")

    @property
    @pulumi.getter(name="phaseTwoDetails")
    def phase_two_details(self) -> Sequence['outputs.GetIpsecConnectionTunnelPhaseTwoDetailResult']:
        """
        IPsec tunnel detail information specific to phase two.
        """
        return pulumi.get(self, "phase_two_details")

    @property
    @pulumi.getter
    def routing(self) -> str:
        """
        the routing strategy used for this tunnel, either static route or BGP dynamic routing
        """
        return pulumi.get(self, "routing")

    @property
    @pulumi.getter(name="sharedSecret")
    def shared_secret(self) -> str:
        return pulumi.get(self, "shared_secret")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The IPSec connection's tunnel's lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The tunnel's current state.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the IPSec connection tunnel was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeStatusUpdated")
    def time_status_updated(self) -> str:
        """
        When the status of the tunnel last changed, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_status_updated")

    @property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> str:
        return pulumi.get(self, "tunnel_id")

    @property
    @pulumi.getter(name="vpnIp")
    def vpn_ip(self) -> str:
        """
        The IP address of Oracle's VPN headend.  Example: `129.146.17.50`
        """
        return pulumi.get(self, "vpn_ip")


class AwaitableGetIpsecConnectionTunnelResult(GetIpsecConnectionTunnelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpsecConnectionTunnelResult(
            associated_virtual_circuits=self.associated_virtual_circuits,
            bgp_session_infos=self.bgp_session_infos,
            compartment_id=self.compartment_id,
            cpe_ip=self.cpe_ip,
            display_name=self.display_name,
            dpd_configs=self.dpd_configs,
            dpd_mode=self.dpd_mode,
            dpd_timeout_in_sec=self.dpd_timeout_in_sec,
            encryption_domain_configs=self.encryption_domain_configs,
            id=self.id,
            ike_version=self.ike_version,
            ipsec_id=self.ipsec_id,
            nat_translation_enabled=self.nat_translation_enabled,
            oracle_can_initiate=self.oracle_can_initiate,
            phase_one_details=self.phase_one_details,
            phase_two_details=self.phase_two_details,
            routing=self.routing,
            shared_secret=self.shared_secret,
            state=self.state,
            status=self.status,
            time_created=self.time_created,
            time_status_updated=self.time_status_updated,
            tunnel_id=self.tunnel_id,
            vpn_ip=self.vpn_ip)


def get_ipsec_connection_tunnel(ipsec_id: Optional[str] = None,
                                tunnel_id: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpsecConnectionTunnelResult:
    """
    This data source provides details about a specific Ip Sec Connection Tunnel resource in Oracle Cloud Infrastructure Core service.

    Gets the specified IPSec connection's specified tunnel basic information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ip_sec_connection_tunnel = oci.Core.get_ipsec_connection_tunnel(ipsec_id=test_ipsec["id"],
        tunnel_id=test_ip_sec_connection_tunnels["ipSecConnectionTunnels"][0]["id"])
    ```


    :param str ipsec_id: The OCID of the IPSec connection.
    :param str tunnel_id: The OCID of the IPSec connection's tunnel.
    """
    __args__ = dict()
    __args__['ipsecId'] = ipsec_id
    __args__['tunnelId'] = tunnel_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getIpsecConnectionTunnel:getIpsecConnectionTunnel', __args__, opts=opts, typ=GetIpsecConnectionTunnelResult).value

    return AwaitableGetIpsecConnectionTunnelResult(
        associated_virtual_circuits=pulumi.get(__ret__, 'associated_virtual_circuits'),
        bgp_session_infos=pulumi.get(__ret__, 'bgp_session_infos'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        cpe_ip=pulumi.get(__ret__, 'cpe_ip'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dpd_configs=pulumi.get(__ret__, 'dpd_configs'),
        dpd_mode=pulumi.get(__ret__, 'dpd_mode'),
        dpd_timeout_in_sec=pulumi.get(__ret__, 'dpd_timeout_in_sec'),
        encryption_domain_configs=pulumi.get(__ret__, 'encryption_domain_configs'),
        id=pulumi.get(__ret__, 'id'),
        ike_version=pulumi.get(__ret__, 'ike_version'),
        ipsec_id=pulumi.get(__ret__, 'ipsec_id'),
        nat_translation_enabled=pulumi.get(__ret__, 'nat_translation_enabled'),
        oracle_can_initiate=pulumi.get(__ret__, 'oracle_can_initiate'),
        phase_one_details=pulumi.get(__ret__, 'phase_one_details'),
        phase_two_details=pulumi.get(__ret__, 'phase_two_details'),
        routing=pulumi.get(__ret__, 'routing'),
        shared_secret=pulumi.get(__ret__, 'shared_secret'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_status_updated=pulumi.get(__ret__, 'time_status_updated'),
        tunnel_id=pulumi.get(__ret__, 'tunnel_id'),
        vpn_ip=pulumi.get(__ret__, 'vpn_ip'))
def get_ipsec_connection_tunnel_output(ipsec_id: Optional[pulumi.Input[str]] = None,
                                       tunnel_id: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpsecConnectionTunnelResult]:
    """
    This data source provides details about a specific Ip Sec Connection Tunnel resource in Oracle Cloud Infrastructure Core service.

    Gets the specified IPSec connection's specified tunnel basic information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ip_sec_connection_tunnel = oci.Core.get_ipsec_connection_tunnel(ipsec_id=test_ipsec["id"],
        tunnel_id=test_ip_sec_connection_tunnels["ipSecConnectionTunnels"][0]["id"])
    ```


    :param str ipsec_id: The OCID of the IPSec connection.
    :param str tunnel_id: The OCID of the IPSec connection's tunnel.
    """
    __args__ = dict()
    __args__['ipsecId'] = ipsec_id
    __args__['tunnelId'] = tunnel_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getIpsecConnectionTunnel:getIpsecConnectionTunnel', __args__, opts=opts, typ=GetIpsecConnectionTunnelResult)
    return __ret__.apply(lambda __response__: GetIpsecConnectionTunnelResult(
        associated_virtual_circuits=pulumi.get(__response__, 'associated_virtual_circuits'),
        bgp_session_infos=pulumi.get(__response__, 'bgp_session_infos'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        cpe_ip=pulumi.get(__response__, 'cpe_ip'),
        display_name=pulumi.get(__response__, 'display_name'),
        dpd_configs=pulumi.get(__response__, 'dpd_configs'),
        dpd_mode=pulumi.get(__response__, 'dpd_mode'),
        dpd_timeout_in_sec=pulumi.get(__response__, 'dpd_timeout_in_sec'),
        encryption_domain_configs=pulumi.get(__response__, 'encryption_domain_configs'),
        id=pulumi.get(__response__, 'id'),
        ike_version=pulumi.get(__response__, 'ike_version'),
        ipsec_id=pulumi.get(__response__, 'ipsec_id'),
        nat_translation_enabled=pulumi.get(__response__, 'nat_translation_enabled'),
        oracle_can_initiate=pulumi.get(__response__, 'oracle_can_initiate'),
        phase_one_details=pulumi.get(__response__, 'phase_one_details'),
        phase_two_details=pulumi.get(__response__, 'phase_two_details'),
        routing=pulumi.get(__response__, 'routing'),
        shared_secret=pulumi.get(__response__, 'shared_secret'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_status_updated=pulumi.get(__response__, 'time_status_updated'),
        tunnel_id=pulumi.get(__response__, 'tunnel_id'),
        vpn_ip=pulumi.get(__response__, 'vpn_ip')))
