from __future__ import annotations

from wetterdienst.core.timeseries.metadata import build_metadata_model

DwdDmoMetadata = {
    "resolutions": [
        {
            "name": "hourly",
            "name_original": "hourly",
            "periods": ["future"],
            "date_required": False,
            "datasets": [
                {
                    "name": "icon_eu",
                    "name_original": "icon_eu",
                    "grouped": True,
                    "parameters": [
                        {
                            "name": "cloud_cover_above_7km",
                            "name_original": "nh",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "cloud_cover_below_500ft",
                            "name_original": "n05",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "cloud_cover_below_1000ft",
                            "name_original": "nl",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "cloud_cover_between_2km_to_7km",
                            "name_original": "nm",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "cloud_cover_effective",
                            "name_original": "neff",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "cloud_cover_total",
                            "name_original": "n",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "precipitation_height_significant_weather_last_1h",
                            "name_original": "rr1c",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "precipitation_height_significant_weather_last_3h",
                            "name_original": "rr3c",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "pressure_air_site_reduced",
                            "name_original": "pppp",
                            "unit": "pascal",
                            "unit_original": "pascal",
                        },
                        {
                            "name": "probability_fog_last_1h",
                            "name_original": "wwm",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_fog_last_6h",
                            "name_original": "wwm6",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_fog_last_12h",
                            "name_original": "wwmh",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_0_0mm_last_12h",
                            "name_original": "rh00",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_0_2mm_last_6h",
                            "name_original": "r602",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_0_2mm_last_12h",
                            "name_original": "rh02",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_0_2mm_last_24h",
                            "name_original": "rd02",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_1mm_last_12h",
                            "name_original": "rh10",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_5mm_last_6h",
                            "name_original": "r650",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_5mm_last_12h",
                            "name_original": "rh50",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_5mm_last_24h",
                            "name_original": "rd50",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_wind_gust_ge_25kn_last_12h",
                            "name_original": "fxh25",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_wind_gust_ge_40kn_last_12h",
                            "name_original": "fxh40",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_wind_gust_ge_55kn_last_12h",
                            "name_original": "fxh55",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "radiation_global",
                            "name_original": "rad1h",
                            "unit": "joule_per_square_meter",
                            "unit_original": "kilojoule_per_square_meter",
                        },
                        {
                            "name": "sunshine_duration",
                            "name_original": "sund1",
                            "unit": "second",
                            "unit_original": "second",
                        },
                        {
                            "name": "temperature_air_max_2m",
                            "name_original": "tx",
                            "unit": "degree_kelvin",
                            "unit_original": "degree_kelvin",
                        },
                        {
                            "name": "temperature_air_mean_0_05m",
                            "name_original": "t5cm",
                            "unit": "degree_kelvin",
                            "unit_original": "degree_kelvin",
                        },
                        {
                            "name": "temperature_air_mean_2m",
                            "name_original": "ttt",
                            "unit": "degree_kelvin",
                            "unit_original": "degree_kelvin",
                        },
                        {
                            "name": "temperature_air_min_2m",
                            "name_original": "tn",
                            "unit": "degree_kelvin",
                            "unit_original": "degree_kelvin",
                        },
                        {
                            "name": "temperature_dew_point_mean_2m",
                            "name_original": "td",
                            "unit": "degree_kelvin",
                            "unit_original": "degree_kelvin",
                        },
                        {
                            "name": "visibility_range",
                            "name_original": "vv",
                            "unit": "meter",
                            "unit_original": "meter",
                        },
                        {
                            "name": "water_equivalent_snow_depth_new_last_1h",
                            "name_original": "rrs1c",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "water_equivalent_snow_depth_new_last_3h",
                            "name_original": "rrs3c",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "weather_last_6h",
                            "name_original": "w1w2",
                            "unit": "dimensionless",
                            "unit_original": "dimensionless",
                        },
                        {
                            "name": "weather_significant",
                            "name_original": "ww",
                            "unit": "significant_weather",
                            "unit_original": "significant_weather",
                        },
                        {
                            "name": "wind_direction",
                            "name_original": "dd",
                            "unit": "degree",
                            "unit_original": "degree",
                        },
                        {
                            "name": "wind_gust_max_last_1h",
                            "name_original": "fx1",
                            "unit": "meter_per_second",
                            "unit_original": "meter_per_second",
                        },
                        {
                            "name": "wind_gust_max_last_3h",
                            "name_original": "fx3",
                            "unit": "meter_per_second",
                            "unit_original": "meter_per_second",
                        },
                        {
                            "name": "wind_gust_max_last_12h",
                            "name_original": "fxh",
                            "unit": "meter_per_second",
                            "unit_original": "meter_per_second",
                        },
                        {
                            "name": "wind_speed",
                            "name_original": "ff",
                            "unit": "meter_per_second",
                            "unit_original": "meter_per_second",
                        },
                    ],
                },
                {
                    "name": "icon",
                    "name_original": "icon",
                    "grouped": True,
                    "parameters": [
                        {
                            "name": "cloud_base_convective",
                            "name_original": "h_bsc",
                            "unit": "meter",
                            "unit_original": "meter",
                        },
                        {
                            "name": "cloud_cover_above_7km",
                            "name_original": "nh",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "cloud_cover_below_500ft",
                            "name_original": "n05",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "cloud_cover_below_1000ft",
                            "name_original": "nl",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "cloud_cover_between_2km_to_7km",
                            "name_original": "nm",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "cloud_cover_below_7km",
                            "name_original": "nlm",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "cloud_cover_effective",
                            "name_original": "neff",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "cloud_cover_total",
                            "name_original": "n",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "error_absolute_pressure_air_site",
                            "name_original": "e_ppp",
                            "unit": "pascal",
                            "unit_original": "pascal",
                        },
                        {
                            "name": "error_absolute_temperature_air_mean_2m",
                            "name_original": "e_ttt",
                            "unit": "degree_kelvin",
                            "unit_original": "degree_kelvin",
                        },
                        {
                            "name": "error_absolute_temperature_dew_point_mean_2m",
                            "name_original": "e_td",
                            "unit": "degree_kelvin",
                            "unit_original": "degree_kelvin",
                        },
                        {
                            "name": "error_absolute_wind_direction",
                            "name_original": "e_dd",
                            "unit": "degree",
                            "unit_original": "degree",
                        },
                        {
                            "name": "error_absolute_wind_speed",
                            "name_original": "e_ff",
                            "unit": "meter_per_second",
                            "unit_original": "meter_per_second",
                        },
                        {
                            "name": "evapotranspiration_potential_last_24h",
                            "name_original": "pevap",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "precipitation_duration",
                            "name_original": "drr1",
                            "unit": "second",
                            "unit_original": "second",
                        },
                        {
                            "name": "precipitation_height_last_1h",
                            "name_original": "rr1",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "precipitation_height_last_3h",
                            "name_original": "rr3",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "precipitation_height_last_6h",
                            "name_original": "rr6",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "precipitation_height_last_12h",
                            "name_original": "rrh",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "precipitation_height_last_24h",
                            "name_original": "rrd",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "precipitation_height_liquid_significant_weather_last_1h",
                            "name_original": "rrl1c",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "precipitation_height_significant_weather_last_1h",
                            "name_original": "rr1c",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "precipitation_height_significant_weather_last_3h",
                            "name_original": "rr3c",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "precipitation_height_significant_weather_last_6h",
                            "name_original": "rr6c",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "precipitation_height_significant_weather_last_12h",
                            "name_original": "rrhc",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "precipitation_height_significant_weather_last_24h",
                            "name_original": "rrdc",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "pressure_air_site_reduced",
                            "name_original": "pppp",
                            "unit": "pascal",
                            "unit_original": "pascal",
                        },
                        {
                            "name": "probability_drizzle_last_1h",
                            "name_original": "wwz",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_drizzle_last_6h",
                            "name_original": "wwz6",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_drizzle_last_12h",
                            "name_original": "wwzh",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_fog_last_1h",
                            "name_original": "wwm",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_fog_last_6h",
                            "name_original": "wwm6",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_fog_last_12h",
                            "name_original": "wwmh",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_fog_last_24h",
                            "name_original": "wwmd",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_convective_last_1h",
                            "name_original": "wwc",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_convective_last_6h",
                            "name_original": "wwc6",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_convective_last_12h",
                            "name_original": "wwch",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_freezing_last_1h",
                            "name_original": "wwf",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_freezing_last_6h",
                            "name_original": "wwf6",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_freezing_last_12h",
                            "name_original": "wwfh",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_0_0mm_last_6h",
                            "name_original": "r600",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_0_0mm_last_12h",
                            "name_original": "rh00",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_0_0mm_last_24h",
                            "name_original": "rd00",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_0_1mm_last_1h",
                            "name_original": "r101",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_0_2mm_last_1h",
                            "name_original": "r102",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_0_2mm_last_6h",
                            "name_original": "r602",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_0_2mm_last_12h",
                            "name_original": "rh02",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_0_2mm_last_24h",
                            "name_original": "rd02",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_0_3mm_last_1h",
                            "name_original": "r103",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_0_5mm_last_1h",
                            "name_original": "r105",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_0_7mm_last_1h",
                            "name_original": "r107",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_1mm_last_1h",
                            "name_original": "r110",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_1mm_last_6h",
                            "name_original": "r610",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_1mm_last_12h",
                            "name_original": "rh10",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_1mm_last_24h",
                            "name_original": "rd10",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_2mm_last_1h",
                            "name_original": "r120",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_3mm_last_1h",
                            "name_original": "r130",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_5mm_last_1h",
                            "name_original": "r150",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_5mm_last_6h",
                            "name_original": "r650",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_5mm_last_12h",
                            "name_original": "rh50",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_5mm_last_24h",
                            "name_original": "rd50",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_10mm_last_1h",
                            "name_original": "rr1o1",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_15mm_last_1h",
                            "name_original": "rr1w1",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_height_gt_25mm_last_1h",
                            "name_original": "rr1u1",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_last_1h",
                            "name_original": "wwp",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_last_6h",
                            "name_original": "wwp6",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_last_12h",
                            "name_original": "wwph",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_last_24h",
                            "name_original": "wwpd",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_liquid_last_1h",
                            "name_original": "wwl",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_liquid_last_6h",
                            "name_original": "wwl6",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_liquid_last_12h",
                            "name_original": "wwlh",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_solid_last_1h",
                            "name_original": "wws",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_solid_last_6h",
                            "name_original": "wws6",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_solid_last_12h",
                            "name_original": "wwsh",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_stratiform_last_1h",
                            "name_original": "wwd",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_stratiform_last_6h",
                            "name_original": "wwd6",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_precipitation_stratiform_last_12h",
                            "name_original": "wwdh",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_radiation_global_last_1h",
                            "name_original": "rrad1",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_sunshine_duration_relative_gt_0pct_last_24h",
                            "name_original": "psd00",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_sunshine_duration_relative_gt_30pct_last_24h",
                            "name_original": "psd30",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_sunshine_duration_relative_gt_60pct_last_24h",
                            "name_original": "psd60",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_thunder_last_1h",
                            "name_original": "wwt",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_thunder_last_6h",
                            "name_original": "wwt6",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_thunder_last_12h",
                            "name_original": "wwth",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_thunder_last_24h",
                            "name_original": "wwtd",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_visibility_below_1000m",
                            "name_original": "vv10",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_wind_gust_ge_25kn_last_6h",
                            "name_original": "fx625",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_wind_gust_ge_25kn_last_12h",
                            "name_original": "fxh25",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_wind_gust_ge_40kn_last_6h",
                            "name_original": "fx640",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_wind_gust_ge_40kn_last_12h",
                            "name_original": "fxh40",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_wind_gust_ge_55kn_last_6h",
                            "name_original": "fx655",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "probability_wind_gust_ge_55kn_last_12h",
                            "name_original": "fxh55",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "radiation_global",
                            "name_original": "rad1h",
                            "unit": "joule_per_square_meter",
                            "unit_original": "kilojoule_per_square_meter",
                        },
                        {
                            "name": "radiation_global_last_3h",
                            "name_original": "rads3",
                            "unit": "joule_per_square_meter",
                            "unit_original": "kilojoule_per_square_meter",
                        },
                        {
                            "name": "radiation_sky_long_wave_last_3h",
                            "name_original": "radl3",
                            "unit": "joule_per_square_meter",
                            "unit_original": "kilojoule_per_square_meter",
                        },
                        {
                            "name": "sunshine_duration",
                            "name_original": "sund1",
                            "unit": "second",
                            "unit_original": "second",
                        },
                        {
                            "name": "sunshine_duration_last_3h",
                            "name_original": "sund3",
                            "unit": "second",
                            "unit_original": "second",
                        },
                        {
                            "name": "sunshine_duration_relative_last_24h",
                            "name_original": "rsund",
                            "unit": "percent",
                            "unit_original": "percent",
                        },
                        {
                            "name": "sunshine_duration_yesterday",
                            "name_original": "sund",
                            "unit": "second",
                            "unit_original": "second",
                        },
                        {
                            "name": "temperature_air_max_2m",
                            "name_original": "tx",
                            "unit": "degree_kelvin",
                            "unit_original": "degree_kelvin",
                        },
                        {
                            "name": "temperature_air_mean_0_05m",
                            "name_original": "t5cm",
                            "unit": "degree_kelvin",
                            "unit_original": "degree_kelvin",
                        },
                        {
                            "name": "temperature_air_mean_2m",
                            "name_original": "ttt",
                            "unit": "degree_kelvin",
                            "unit_original": "degree_kelvin",
                        },
                        {
                            "name": "temperature_air_mean_2m_last_24h",
                            "name_original": "tm",
                            "unit": "degree_kelvin",
                            "unit_original": "degree_kelvin",
                        },
                        {
                            "name": "temperature_air_min_0_05m_last_12h",
                            "name_original": "tg",
                            "unit": "degree_kelvin",
                            "unit_original": "degree_kelvin",
                        },
                        {
                            "name": "temperature_air_min_2m",
                            "name_original": "tn",
                            "unit": "degree_kelvin",
                            "unit_original": "degree_kelvin",
                        },
                        {
                            "name": "temperature_dew_point_mean_2m",
                            "name_original": "td",
                            "unit": "degree_kelvin",
                            "unit_original": "degree_kelvin",
                        },
                        {
                            "name": "visibility_range",
                            "name_original": "vv",
                            "unit": "meter",
                            "unit_original": "meter",
                        },
                        {
                            "name": "water_equivalent_snow_depth_new_last_1h",
                            "name_original": "rrs1c",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "water_equivalent_snow_depth_new_last_3h",
                            "name_original": "rrs3c",
                            "unit": "kilogram_per_square_meter",
                            "unit_original": "kilogram_per_square_meter",
                        },
                        {
                            "name": "weather_last_6h",
                            "name_original": "w1w2",
                            "unit": "dimensionless",
                            "unit_original": "dimensionless",
                        },
                        {
                            "name": "weather_significant",
                            "name_original": "ww",
                            "unit": "significant_weather",
                            "unit_original": "significant_weather",
                        },
                        {
                            "name": "weather_significant_last_3h",
                            "name_original": "ww3",
                            "unit": "significant_weather",
                            "unit_original": "significant_weather",
                        },
                        {
                            "name": "weather_significant_optional_last_1h",
                            "name_original": "wpc11",
                            "unit": "significant_weather",
                            "unit_original": "significant_weather",
                        },
                        {
                            "name": "weather_significant_optional_last_3h",
                            "name_original": "wpc31",
                            "unit": "significant_weather",
                            "unit_original": "significant_weather",
                        },
                        {
                            "name": "weather_significant_optional_last_6h",
                            "name_original": "wpc61",
                            "unit": "significant_weather",
                            "unit_original": "significant_weather",
                        },
                        {
                            "name": "weather_significant_optional_last_12h",
                            "name_original": "wpch1",
                            "unit": "significant_weather",
                            "unit_original": "significant_weather",
                        },
                        {
                            "name": "weather_significant_optional_last_24h",
                            "name_original": "wpcd1",
                            "unit": "significant_weather",
                            "unit_original": "significant_weather",
                        },
                        {
                            "name": "wind_direction",
                            "name_original": "dd",
                            "unit": "degree",
                            "unit_original": "degree",
                        },
                        {
                            "name": "wind_gust_max_last_1h",
                            "name_original": "fx1",
                            "unit": "meter_per_second",
                            "unit_original": "meter_per_second",
                        },
                        {
                            "name": "wind_gust_max_last_3h",
                            "name_original": "fx3",
                            "unit": "meter_per_second",
                            "unit_original": "meter_per_second",
                        },
                        {
                            "name": "wind_gust_max_last_12h",
                            "name_original": "fxh",
                            "unit": "meter_per_second",
                            "unit_original": "meter_per_second",
                        },
                        {
                            "name": "wind_speed",
                            "name_original": "ff",
                            "unit": "meter_per_second",
                            "unit_original": "meter_per_second",
                        },
                    ],
                },
            ],
        }
    ]
}
DwdDmoMetadata = build_metadata_model(DwdDmoMetadata, "DwdDmoMetadata")
