/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.util.RegexECMA262Helper;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import io.ray.shaded.com.fasterxml.jackson.databind.JsonNode;

public final class PatternValidator
extends AbstractKeywordValidator {
    public PatternValidator(JsonNode digest) {
        super("pattern");
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String value;
        String regex = data.getSchema().getNode().get(this.keyword).textValue();
        if (!RegexECMA262Helper.regMatch(regex, value = data.getInstance().getNode().textValue())) {
            report.error(this.newMsg(data, bundle, "err.common.pattern.noMatch").putArgument("regex", regex).putArgument("string", value));
        }
    }

    @Override
    public String toString() {
        return this.keyword;
    }
}

