"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _FunctionCodeUpdater_bucket, _FunctionCodeUpdater_objectKey, _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionCodeUpdater = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("node:path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_lambda_event_sources_1 = require("aws-cdk-lib/aws-lambda-event-sources");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
const HANDLER_PATH = path.join(__dirname, "../../assets/automation/function-code-updater");
/**
 * Automates deployments of Lambda function code.
 *
 * In order to guarantee the least amount of privilege to the principal sending
 * new code revisions to S3 (e.g. a GitHub Action, a CodeBuild project), you can
 * use this construct to call the `UpdateFunctionCode` action of the Lambda API
 * any time a new revision is added to a bucket (which must support versioning).
 */
class FunctionCodeUpdater extends constructs_1.Construct {
    /**
     * Creates a new FunctionCodeUpdater.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param props - Initialization properties for this construct.
     */
    constructor(scope, id, props) {
        super(scope, id);
        _FunctionCodeUpdater_bucket.set(this, void 0);
        _FunctionCodeUpdater_objectKey.set(this, void 0);
        const { bucket, objectKey, target } = props;
        __classPrivateFieldSet(this, _FunctionCodeUpdater_bucket, bucket, "f");
        __classPrivateFieldSet(this, _FunctionCodeUpdater_objectKey, objectKey, "f");
        const updater = new aws_lambda_1.Function(this, "Default", {
            description: "Calls lambda:UpdateFunctionCode when new versions appear in S3",
            runtime: aws_lambda_1.Runtime.NODEJS_22_X,
            code: aws_lambda_1.Code.fromAsset(HANDLER_PATH),
            handler: "index.handler",
            environment: {
                FUNCTION_NAME: target.functionName,
                BUCKET_NAME: bucket.bucketName,
                OBJECT_KEY: objectKey,
            },
            timeout: aws_cdk_lib_1.Duration.seconds(30),
        });
        bucket.grantRead(updater, objectKey);
        updater.grantPrincipal.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: ["lambda:UpdateFunctionCode"],
            resources: [target.functionArn],
        }));
        updater.addEventSource(new aws_lambda_event_sources_1.S3EventSourceV2(bucket, {
            events: [aws_s3_1.EventType.OBJECT_CREATED],
            filters: [{ prefix: objectKey }],
        }));
    }
    /**
     * Grants `s3:PutObject*` and `s3:AbortObject*` permissions for the S3 object
     * key of the Lambda function code.
     *
     * If encryption is used, permission to use the key to encrypt uploaded files
     * will also be granted to the same principal.
     *
     * @param identity - The principal
     */
    grantPutCode(identity) {
        return __classPrivateFieldGet(this, _FunctionCodeUpdater_bucket, "f").grantPut(identity, __classPrivateFieldGet(this, _FunctionCodeUpdater_objectKey, "f"));
    }
}
exports.FunctionCodeUpdater = FunctionCodeUpdater;
_FunctionCodeUpdater_bucket = new WeakMap(), _FunctionCodeUpdater_objectKey = new WeakMap(), _a = JSII_RTTI_SYMBOL_1;
FunctionCodeUpdater[_a] = { fqn: "shady-island.automation.FunctionCodeUpdater", version: "0.1.66" };
//# sourceMappingURL=data:application/json;base64,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