/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.task;

import io.ray.api.ObjectRef;
import io.ray.api.Ray;
import io.ray.api.id.ObjectId;
import io.ray.runtime.AbstractRayRuntime;
import io.ray.runtime.generated.Common;
import io.ray.runtime.object.NativeRayObject;
import io.ray.runtime.object.ObjectRefImpl;
import io.ray.runtime.object.ObjectSerializer;
import io.ray.runtime.task.FunctionArg;
import io.ray.runtime.util.SystemConfig;
import io.ray.shaded.com.google.common.base.Preconditions;
import io.ray.shaded.com.google.common.primitives.Bytes;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArgumentsBuilder {
    private static final NativeRayObject PYTHON_DUMMY_TYPE = ObjectSerializer.serialize("__RAY_DUMMY__".getBytes());

    public static List<FunctionArg> wrap(Object[] args, Common.Language language) {
        ArrayList<FunctionArg> ret = new ArrayList<FunctionArg>();
        for (Object arg : args) {
            ObjectId id = null;
            Common.Address address = null;
            NativeRayObject value = null;
            if (arg instanceof ObjectRef) {
                Preconditions.checkState(arg instanceof ObjectRefImpl);
                id = ((ObjectRefImpl)arg).getId();
                address = ((AbstractRayRuntime)Ray.internal()).getObjectStore().getOwnerAddress(id);
            } else {
                value = ObjectSerializer.serialize(arg);
                if (language != Common.Language.JAVA) {
                    boolean isCrossData;
                    boolean bl = isCrossData = Bytes.indexOf(value.metadata, ObjectSerializer.OBJECT_METADATA_TYPE_CROSS_LANGUAGE) == 0 || Bytes.indexOf(value.metadata, ObjectSerializer.OBJECT_METADATA_TYPE_RAW) == 0 || Bytes.indexOf(value.metadata, ObjectSerializer.OBJECT_METADATA_TYPE_ACTOR_HANDLE) == 0;
                    if (!isCrossData) {
                        throw new IllegalArgumentException(String.format("Can't transfer %s data to %s", Arrays.toString(value.metadata), language.getValueDescriptor().getName()));
                    }
                }
                if ((long)value.data.length > SystemConfig.getLargestSizePassedByValue()) {
                    id = ((AbstractRayRuntime)Ray.internal()).getObjectStore().putRaw(value);
                    address = ((AbstractRayRuntime)Ray.internal()).getWorkerContext().getRpcAddress();
                    value = null;
                }
            }
            if (language == Common.Language.PYTHON) {
                ret.add(FunctionArg.passByValue(PYTHON_DUMMY_TYPE));
            }
            if (id != null) {
                ret.add(FunctionArg.passByReference(id, address));
                continue;
            }
            ret.add(FunctionArg.passByValue(value));
        }
        return ret;
    }

    public static Object[] unwrap(List<Object> args, Class<?>[] types) {
        Object[] realArgs = new Object[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            Object arg = args.get(i);
            Preconditions.checkState(arg instanceof ByteBuffer || arg instanceof NativeRayObject);
            if (arg instanceof ByteBuffer) {
                Preconditions.checkState(types[i] == ByteBuffer.class);
                realArgs[i] = arg;
                continue;
            }
            realArgs[i] = ObjectSerializer.deserialize((NativeRayObject)arg, null, types[i]);
        }
        return realArgs;
    }
}

