/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#allowed_user_ip_cidrs AppServiceEnvironment#allowed_user_ip_cidrs}
    */
    readonly allowedUserIpCidrs?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#front_end_scale_factor AppServiceEnvironment#front_end_scale_factor}
    */
    readonly frontEndScaleFactor?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#id AppServiceEnvironment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#internal_load_balancing_mode AppServiceEnvironment#internal_load_balancing_mode}
    */
    readonly internalLoadBalancingMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#name AppServiceEnvironment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#pricing_tier AppServiceEnvironment#pricing_tier}
    */
    readonly pricingTier?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#resource_group_name AppServiceEnvironment#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#subnet_id AppServiceEnvironment#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#tags AppServiceEnvironment#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * cluster_setting block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#cluster_setting AppServiceEnvironment#cluster_setting}
    */
    readonly clusterSetting?: AppServiceEnvironmentClusterSetting[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#timeouts AppServiceEnvironment#timeouts}
    */
    readonly timeouts?: AppServiceEnvironmentTimeouts;
}
export interface AppServiceEnvironmentClusterSetting {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#name AppServiceEnvironment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#value AppServiceEnvironment#value}
    */
    readonly value: string;
}
export declare function appServiceEnvironmentClusterSettingToTerraform(struct?: AppServiceEnvironmentClusterSetting | cdktf.IResolvable): any;
export declare function appServiceEnvironmentClusterSettingToHclTerraform(struct?: AppServiceEnvironmentClusterSetting | cdktf.IResolvable): any;
export declare class AppServiceEnvironmentClusterSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppServiceEnvironmentClusterSetting | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceEnvironmentClusterSetting | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class AppServiceEnvironmentClusterSettingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppServiceEnvironmentClusterSetting[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppServiceEnvironmentClusterSettingOutputReference;
}
export interface AppServiceEnvironmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#create AppServiceEnvironment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#delete AppServiceEnvironment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#read AppServiceEnvironment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#update AppServiceEnvironment#update}
    */
    readonly update?: string;
}
export declare function appServiceEnvironmentTimeoutsToTerraform(struct?: AppServiceEnvironmentTimeouts | cdktf.IResolvable): any;
export declare function appServiceEnvironmentTimeoutsToHclTerraform(struct?: AppServiceEnvironmentTimeouts | cdktf.IResolvable): any;
export declare class AppServiceEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceEnvironmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceEnvironmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment azurerm_app_service_environment}
*/
export declare class AppServiceEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_service_environment";
    /**
    * Generates CDKTF code for importing a AppServiceEnvironment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AppServiceEnvironment to import
    * @param importFromId The id of the existing AppServiceEnvironment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AppServiceEnvironment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/app_service_environment azurerm_app_service_environment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: AppServiceEnvironmentConfig);
    private _allowedUserIpCidrs?;
    get allowedUserIpCidrs(): string[];
    set allowedUserIpCidrs(value: string[]);
    resetAllowedUserIpCidrs(): void;
    get allowedUserIpCidrsInput(): string[] | undefined;
    private _frontEndScaleFactor?;
    get frontEndScaleFactor(): number;
    set frontEndScaleFactor(value: number);
    resetFrontEndScaleFactor(): void;
    get frontEndScaleFactorInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get internalIpAddress(): string;
    private _internalLoadBalancingMode?;
    get internalLoadBalancingMode(): string;
    set internalLoadBalancingMode(value: string);
    resetInternalLoadBalancingMode(): void;
    get internalLoadBalancingModeInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddresses(): string[];
    private _pricingTier?;
    get pricingTier(): string;
    set pricingTier(value: string);
    resetPricingTier(): void;
    get pricingTierInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get serviceIpAddress(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _clusterSetting;
    get clusterSetting(): AppServiceEnvironmentClusterSettingList;
    putClusterSetting(value: AppServiceEnvironmentClusterSetting[] | cdktf.IResolvable): void;
    resetClusterSetting(): void;
    get clusterSettingInput(): cdktf.IResolvable | AppServiceEnvironmentClusterSetting[] | undefined;
    private _timeouts;
    get timeouts(): AppServiceEnvironmentTimeoutsOutputReference;
    putTimeouts(value: AppServiceEnvironmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppServiceEnvironmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
