/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AttestationProviderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#id AttestationProvider#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#location AttestationProvider#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#name AttestationProvider#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#open_enclave_policy_base64 AttestationProvider#open_enclave_policy_base64}
    */
    readonly openEnclavePolicyBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#policy_signing_certificate_data AttestationProvider#policy_signing_certificate_data}
    */
    readonly policySigningCertificateData?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#resource_group_name AttestationProvider#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#sev_snp_policy_base64 AttestationProvider#sev_snp_policy_base64}
    */
    readonly sevSnpPolicyBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#sgx_enclave_policy_base64 AttestationProvider#sgx_enclave_policy_base64}
    */
    readonly sgxEnclavePolicyBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#tags AttestationProvider#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#tpm_policy_base64 AttestationProvider#tpm_policy_base64}
    */
    readonly tpmPolicyBase64?: string;
    /**
    * policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#policy AttestationProvider#policy}
    */
    readonly policy?: AttestationProviderPolicy[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#timeouts AttestationProvider#timeouts}
    */
    readonly timeouts?: AttestationProviderTimeouts;
}
export interface AttestationProviderPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#data AttestationProvider#data}
    */
    readonly data?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#environment_type AttestationProvider#environment_type}
    */
    readonly environmentType?: string;
}
export declare function attestationProviderPolicyToTerraform(struct?: AttestationProviderPolicy | cdktf.IResolvable): any;
export declare function attestationProviderPolicyToHclTerraform(struct?: AttestationProviderPolicy | cdktf.IResolvable): any;
export declare class AttestationProviderPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AttestationProviderPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: AttestationProviderPolicy | cdktf.IResolvable | undefined);
    private _data?;
    get data(): string;
    set data(value: string);
    resetData(): void;
    get dataInput(): string | undefined;
    private _environmentType?;
    get environmentType(): string;
    set environmentType(value: string);
    resetEnvironmentType(): void;
    get environmentTypeInput(): string | undefined;
}
export declare class AttestationProviderPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AttestationProviderPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AttestationProviderPolicyOutputReference;
}
export interface AttestationProviderTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#create AttestationProvider#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#delete AttestationProvider#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#read AttestationProvider#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#update AttestationProvider#update}
    */
    readonly update?: string;
}
export declare function attestationProviderTimeoutsToTerraform(struct?: AttestationProviderTimeouts | cdktf.IResolvable): any;
export declare function attestationProviderTimeoutsToHclTerraform(struct?: AttestationProviderTimeouts | cdktf.IResolvable): any;
export declare class AttestationProviderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AttestationProviderTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AttestationProviderTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider azurerm_attestation_provider}
*/
export declare class AttestationProvider extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_attestation_provider";
    /**
    * Generates CDKTF code for importing a AttestationProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AttestationProvider to import
    * @param importFromId The id of the existing AttestationProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AttestationProvider to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/attestation_provider azurerm_attestation_provider} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AttestationProviderConfig
    */
    constructor(scope: Construct, id: string, config: AttestationProviderConfig);
    get attestationUri(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _openEnclavePolicyBase64?;
    get openEnclavePolicyBase64(): string;
    set openEnclavePolicyBase64(value: string);
    resetOpenEnclavePolicyBase64(): void;
    get openEnclavePolicyBase64Input(): string | undefined;
    private _policySigningCertificateData?;
    get policySigningCertificateData(): string;
    set policySigningCertificateData(value: string);
    resetPolicySigningCertificateData(): void;
    get policySigningCertificateDataInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sevSnpPolicyBase64?;
    get sevSnpPolicyBase64(): string;
    set sevSnpPolicyBase64(value: string);
    resetSevSnpPolicyBase64(): void;
    get sevSnpPolicyBase64Input(): string | undefined;
    private _sgxEnclavePolicyBase64?;
    get sgxEnclavePolicyBase64(): string;
    set sgxEnclavePolicyBase64(value: string);
    resetSgxEnclavePolicyBase64(): void;
    get sgxEnclavePolicyBase64Input(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tpmPolicyBase64?;
    get tpmPolicyBase64(): string;
    set tpmPolicyBase64(value: string);
    resetTpmPolicyBase64(): void;
    get tpmPolicyBase64Input(): string | undefined;
    get trustModel(): string;
    private _policy;
    get policy(): AttestationProviderPolicyList;
    putPolicy(value: AttestationProviderPolicy[] | cdktf.IResolvable): void;
    resetPolicy(): void;
    get policyInput(): cdktf.IResolvable | AttestationProviderPolicy[] | undefined;
    private _timeouts;
    get timeouts(): AttestationProviderTimeoutsOutputReference;
    putTimeouts(value: AttestationProviderTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AttestationProviderTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
