/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BackupPolicyVmConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#id BackupPolicyVm#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#instant_restore_retention_days BackupPolicyVm#instant_restore_retention_days}
    */
    readonly instantRestoreRetentionDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#name BackupPolicyVm#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#policy_type BackupPolicyVm#policy_type}
    */
    readonly policyType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#recovery_vault_name BackupPolicyVm#recovery_vault_name}
    */
    readonly recoveryVaultName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#resource_group_name BackupPolicyVm#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#timezone BackupPolicyVm#timezone}
    */
    readonly timezone?: string;
    /**
    * backup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#backup BackupPolicyVm#backup}
    */
    readonly backup: BackupPolicyVmBackup;
    /**
    * instant_restore_resource_group block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#instant_restore_resource_group BackupPolicyVm#instant_restore_resource_group}
    */
    readonly instantRestoreResourceGroup?: BackupPolicyVmInstantRestoreResourceGroup;
    /**
    * retention_daily block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#retention_daily BackupPolicyVm#retention_daily}
    */
    readonly retentionDaily?: BackupPolicyVmRetentionDaily;
    /**
    * retention_monthly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#retention_monthly BackupPolicyVm#retention_monthly}
    */
    readonly retentionMonthly?: BackupPolicyVmRetentionMonthly;
    /**
    * retention_weekly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#retention_weekly BackupPolicyVm#retention_weekly}
    */
    readonly retentionWeekly?: BackupPolicyVmRetentionWeekly;
    /**
    * retention_yearly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#retention_yearly BackupPolicyVm#retention_yearly}
    */
    readonly retentionYearly?: BackupPolicyVmRetentionYearly;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#timeouts BackupPolicyVm#timeouts}
    */
    readonly timeouts?: BackupPolicyVmTimeouts;
}
export interface BackupPolicyVmBackup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#frequency BackupPolicyVm#frequency}
    */
    readonly frequency: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#hour_duration BackupPolicyVm#hour_duration}
    */
    readonly hourDuration?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#hour_interval BackupPolicyVm#hour_interval}
    */
    readonly hourInterval?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#time BackupPolicyVm#time}
    */
    readonly time: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#weekdays BackupPolicyVm#weekdays}
    */
    readonly weekdays?: string[];
}
export declare function backupPolicyVmBackupToTerraform(struct?: BackupPolicyVmBackupOutputReference | BackupPolicyVmBackup): any;
export declare function backupPolicyVmBackupToHclTerraform(struct?: BackupPolicyVmBackupOutputReference | BackupPolicyVmBackup): any;
export declare class BackupPolicyVmBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyVmBackup | undefined;
    set internalValue(value: BackupPolicyVmBackup | undefined);
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    get frequencyInput(): string | undefined;
    private _hourDuration?;
    get hourDuration(): number;
    set hourDuration(value: number);
    resetHourDuration(): void;
    get hourDurationInput(): number | undefined;
    private _hourInterval?;
    get hourInterval(): number;
    set hourInterval(value: number);
    resetHourInterval(): void;
    get hourIntervalInput(): number | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
    private _weekdays?;
    get weekdays(): string[];
    set weekdays(value: string[]);
    resetWeekdays(): void;
    get weekdaysInput(): string[] | undefined;
}
export interface BackupPolicyVmInstantRestoreResourceGroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#prefix BackupPolicyVm#prefix}
    */
    readonly prefix: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#suffix BackupPolicyVm#suffix}
    */
    readonly suffix?: string;
}
export declare function backupPolicyVmInstantRestoreResourceGroupToTerraform(struct?: BackupPolicyVmInstantRestoreResourceGroupOutputReference | BackupPolicyVmInstantRestoreResourceGroup): any;
export declare function backupPolicyVmInstantRestoreResourceGroupToHclTerraform(struct?: BackupPolicyVmInstantRestoreResourceGroupOutputReference | BackupPolicyVmInstantRestoreResourceGroup): any;
export declare class BackupPolicyVmInstantRestoreResourceGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyVmInstantRestoreResourceGroup | undefined;
    set internalValue(value: BackupPolicyVmInstantRestoreResourceGroup | undefined);
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    get prefixInput(): string | undefined;
    private _suffix?;
    get suffix(): string;
    set suffix(value: string);
    resetSuffix(): void;
    get suffixInput(): string | undefined;
}
export interface BackupPolicyVmRetentionDaily {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#count BackupPolicyVm#count}
    */
    readonly count: number;
}
export declare function backupPolicyVmRetentionDailyToTerraform(struct?: BackupPolicyVmRetentionDailyOutputReference | BackupPolicyVmRetentionDaily): any;
export declare function backupPolicyVmRetentionDailyToHclTerraform(struct?: BackupPolicyVmRetentionDailyOutputReference | BackupPolicyVmRetentionDaily): any;
export declare class BackupPolicyVmRetentionDailyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyVmRetentionDaily | undefined;
    set internalValue(value: BackupPolicyVmRetentionDaily | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
}
export interface BackupPolicyVmRetentionMonthly {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#count BackupPolicyVm#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#days BackupPolicyVm#days}
    */
    readonly days?: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#include_last_days BackupPolicyVm#include_last_days}
    */
    readonly includeLastDays?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#weekdays BackupPolicyVm#weekdays}
    */
    readonly weekdays?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#weeks BackupPolicyVm#weeks}
    */
    readonly weeks?: string[];
}
export declare function backupPolicyVmRetentionMonthlyToTerraform(struct?: BackupPolicyVmRetentionMonthlyOutputReference | BackupPolicyVmRetentionMonthly): any;
export declare function backupPolicyVmRetentionMonthlyToHclTerraform(struct?: BackupPolicyVmRetentionMonthlyOutputReference | BackupPolicyVmRetentionMonthly): any;
export declare class BackupPolicyVmRetentionMonthlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyVmRetentionMonthly | undefined;
    set internalValue(value: BackupPolicyVmRetentionMonthly | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _days?;
    get days(): number[];
    set days(value: number[]);
    resetDays(): void;
    get daysInput(): number[] | undefined;
    private _includeLastDays?;
    get includeLastDays(): boolean | cdktf.IResolvable;
    set includeLastDays(value: boolean | cdktf.IResolvable);
    resetIncludeLastDays(): void;
    get includeLastDaysInput(): boolean | cdktf.IResolvable | undefined;
    private _weekdays?;
    get weekdays(): string[];
    set weekdays(value: string[]);
    resetWeekdays(): void;
    get weekdaysInput(): string[] | undefined;
    private _weeks?;
    get weeks(): string[];
    set weeks(value: string[]);
    resetWeeks(): void;
    get weeksInput(): string[] | undefined;
}
export interface BackupPolicyVmRetentionWeekly {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#count BackupPolicyVm#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#weekdays BackupPolicyVm#weekdays}
    */
    readonly weekdays: string[];
}
export declare function backupPolicyVmRetentionWeeklyToTerraform(struct?: BackupPolicyVmRetentionWeeklyOutputReference | BackupPolicyVmRetentionWeekly): any;
export declare function backupPolicyVmRetentionWeeklyToHclTerraform(struct?: BackupPolicyVmRetentionWeeklyOutputReference | BackupPolicyVmRetentionWeekly): any;
export declare class BackupPolicyVmRetentionWeeklyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyVmRetentionWeekly | undefined;
    set internalValue(value: BackupPolicyVmRetentionWeekly | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _weekdays?;
    get weekdays(): string[];
    set weekdays(value: string[]);
    get weekdaysInput(): string[] | undefined;
}
export interface BackupPolicyVmRetentionYearly {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#count BackupPolicyVm#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#days BackupPolicyVm#days}
    */
    readonly days?: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#include_last_days BackupPolicyVm#include_last_days}
    */
    readonly includeLastDays?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#months BackupPolicyVm#months}
    */
    readonly months: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#weekdays BackupPolicyVm#weekdays}
    */
    readonly weekdays?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#weeks BackupPolicyVm#weeks}
    */
    readonly weeks?: string[];
}
export declare function backupPolicyVmRetentionYearlyToTerraform(struct?: BackupPolicyVmRetentionYearlyOutputReference | BackupPolicyVmRetentionYearly): any;
export declare function backupPolicyVmRetentionYearlyToHclTerraform(struct?: BackupPolicyVmRetentionYearlyOutputReference | BackupPolicyVmRetentionYearly): any;
export declare class BackupPolicyVmRetentionYearlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyVmRetentionYearly | undefined;
    set internalValue(value: BackupPolicyVmRetentionYearly | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _days?;
    get days(): number[];
    set days(value: number[]);
    resetDays(): void;
    get daysInput(): number[] | undefined;
    private _includeLastDays?;
    get includeLastDays(): boolean | cdktf.IResolvable;
    set includeLastDays(value: boolean | cdktf.IResolvable);
    resetIncludeLastDays(): void;
    get includeLastDaysInput(): boolean | cdktf.IResolvable | undefined;
    private _months?;
    get months(): string[];
    set months(value: string[]);
    get monthsInput(): string[] | undefined;
    private _weekdays?;
    get weekdays(): string[];
    set weekdays(value: string[]);
    resetWeekdays(): void;
    get weekdaysInput(): string[] | undefined;
    private _weeks?;
    get weeks(): string[];
    set weeks(value: string[]);
    resetWeeks(): void;
    get weeksInput(): string[] | undefined;
}
export interface BackupPolicyVmTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#create BackupPolicyVm#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#delete BackupPolicyVm#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#read BackupPolicyVm#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#update BackupPolicyVm#update}
    */
    readonly update?: string;
}
export declare function backupPolicyVmTimeoutsToTerraform(struct?: BackupPolicyVmTimeouts | cdktf.IResolvable): any;
export declare function backupPolicyVmTimeoutsToHclTerraform(struct?: BackupPolicyVmTimeouts | cdktf.IResolvable): any;
export declare class BackupPolicyVmTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyVmTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BackupPolicyVmTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm azurerm_backup_policy_vm}
*/
export declare class BackupPolicyVm extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_backup_policy_vm";
    /**
    * Generates CDKTF code for importing a BackupPolicyVm resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the BackupPolicyVm to import
    * @param importFromId The id of the existing BackupPolicyVm that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the BackupPolicyVm to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/backup_policy_vm azurerm_backup_policy_vm} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BackupPolicyVmConfig
    */
    constructor(scope: Construct, id: string, config: BackupPolicyVmConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instantRestoreRetentionDays?;
    get instantRestoreRetentionDays(): number;
    set instantRestoreRetentionDays(value: number);
    resetInstantRestoreRetentionDays(): void;
    get instantRestoreRetentionDaysInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policyType?;
    get policyType(): string;
    set policyType(value: string);
    resetPolicyType(): void;
    get policyTypeInput(): string | undefined;
    private _recoveryVaultName?;
    get recoveryVaultName(): string;
    set recoveryVaultName(value: string);
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    private _backup;
    get backup(): BackupPolicyVmBackupOutputReference;
    putBackup(value: BackupPolicyVmBackup): void;
    get backupInput(): BackupPolicyVmBackup | undefined;
    private _instantRestoreResourceGroup;
    get instantRestoreResourceGroup(): BackupPolicyVmInstantRestoreResourceGroupOutputReference;
    putInstantRestoreResourceGroup(value: BackupPolicyVmInstantRestoreResourceGroup): void;
    resetInstantRestoreResourceGroup(): void;
    get instantRestoreResourceGroupInput(): BackupPolicyVmInstantRestoreResourceGroup | undefined;
    private _retentionDaily;
    get retentionDaily(): BackupPolicyVmRetentionDailyOutputReference;
    putRetentionDaily(value: BackupPolicyVmRetentionDaily): void;
    resetRetentionDaily(): void;
    get retentionDailyInput(): BackupPolicyVmRetentionDaily | undefined;
    private _retentionMonthly;
    get retentionMonthly(): BackupPolicyVmRetentionMonthlyOutputReference;
    putRetentionMonthly(value: BackupPolicyVmRetentionMonthly): void;
    resetRetentionMonthly(): void;
    get retentionMonthlyInput(): BackupPolicyVmRetentionMonthly | undefined;
    private _retentionWeekly;
    get retentionWeekly(): BackupPolicyVmRetentionWeeklyOutputReference;
    putRetentionWeekly(value: BackupPolicyVmRetentionWeekly): void;
    resetRetentionWeekly(): void;
    get retentionWeeklyInput(): BackupPolicyVmRetentionWeekly | undefined;
    private _retentionYearly;
    get retentionYearly(): BackupPolicyVmRetentionYearlyOutputReference;
    putRetentionYearly(value: BackupPolicyVmRetentionYearly): void;
    resetRetentionYearly(): void;
    get retentionYearlyInput(): BackupPolicyVmRetentionYearly | undefined;
    private _timeouts;
    get timeouts(): BackupPolicyVmTimeoutsOutputReference;
    putTimeouts(value: BackupPolicyVmTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BackupPolicyVmTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
