/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermContainerAppEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/container_app_environment#id DataAzurermContainerAppEnvironment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Container Apps Managed Environment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/container_app_environment#name DataAzurermContainerAppEnvironment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/container_app_environment#resource_group_name DataAzurermContainerAppEnvironment#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/container_app_environment#timeouts DataAzurermContainerAppEnvironment#timeouts}
    */
    readonly timeouts?: DataAzurermContainerAppEnvironmentTimeouts;
}
export interface DataAzurermContainerAppEnvironmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/container_app_environment#read DataAzurermContainerAppEnvironment#read}
    */
    readonly read?: string;
}
export declare function dataAzurermContainerAppEnvironmentTimeoutsToTerraform(struct?: DataAzurermContainerAppEnvironmentTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermContainerAppEnvironmentTimeoutsToHclTerraform(struct?: DataAzurermContainerAppEnvironmentTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermContainerAppEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermContainerAppEnvironmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermContainerAppEnvironmentTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/container_app_environment azurerm_container_app_environment}
*/
export declare class DataAzurermContainerAppEnvironment extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_container_app_environment";
    /**
    * Generates CDKTF code for importing a DataAzurermContainerAppEnvironment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermContainerAppEnvironment to import
    * @param importFromId The id of the existing DataAzurermContainerAppEnvironment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/container_app_environment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermContainerAppEnvironment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/container_app_environment azurerm_container_app_environment} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermContainerAppEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermContainerAppEnvironmentConfig);
    get defaultDomain(): string;
    get dockerBridgeCidr(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get infrastructureSubnetId(): string;
    get internalLoadBalancerEnabled(): cdktf.IResolvable;
    get location(): string;
    get logAnalyticsWorkspaceName(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get platformReservedCidr(): string;
    get platformReservedDnsIpAddress(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get staticIpAddress(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermContainerAppEnvironmentTimeoutsOutputReference;
    putTimeouts(value: DataAzurermContainerAppEnvironmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermContainerAppEnvironmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
