/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDatabricksWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/databricks_workspace#id DataAzurermDatabricksWorkspace#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/databricks_workspace#name DataAzurermDatabricksWorkspace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/databricks_workspace#resource_group_name DataAzurermDatabricksWorkspace#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/databricks_workspace#tags DataAzurermDatabricksWorkspace#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/databricks_workspace#timeouts DataAzurermDatabricksWorkspace#timeouts}
    */
    readonly timeouts?: DataAzurermDatabricksWorkspaceTimeouts;
}
export interface DataAzurermDatabricksWorkspaceManagedDiskIdentity {
}
export declare function dataAzurermDatabricksWorkspaceManagedDiskIdentityToTerraform(struct?: DataAzurermDatabricksWorkspaceManagedDiskIdentity): any;
export declare function dataAzurermDatabricksWorkspaceManagedDiskIdentityToHclTerraform(struct?: DataAzurermDatabricksWorkspaceManagedDiskIdentity): any;
export declare class DataAzurermDatabricksWorkspaceManagedDiskIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDatabricksWorkspaceManagedDiskIdentity | undefined;
    set internalValue(value: DataAzurermDatabricksWorkspaceManagedDiskIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermDatabricksWorkspaceManagedDiskIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDatabricksWorkspaceManagedDiskIdentityOutputReference;
}
export interface DataAzurermDatabricksWorkspaceStorageAccountIdentity {
}
export declare function dataAzurermDatabricksWorkspaceStorageAccountIdentityToTerraform(struct?: DataAzurermDatabricksWorkspaceStorageAccountIdentity): any;
export declare function dataAzurermDatabricksWorkspaceStorageAccountIdentityToHclTerraform(struct?: DataAzurermDatabricksWorkspaceStorageAccountIdentity): any;
export declare class DataAzurermDatabricksWorkspaceStorageAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDatabricksWorkspaceStorageAccountIdentity | undefined;
    set internalValue(value: DataAzurermDatabricksWorkspaceStorageAccountIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermDatabricksWorkspaceStorageAccountIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDatabricksWorkspaceStorageAccountIdentityOutputReference;
}
export interface DataAzurermDatabricksWorkspaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/databricks_workspace#read DataAzurermDatabricksWorkspace#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDatabricksWorkspaceTimeoutsToTerraform(struct?: DataAzurermDatabricksWorkspaceTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermDatabricksWorkspaceTimeoutsToHclTerraform(struct?: DataAzurermDatabricksWorkspaceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDatabricksWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDatabricksWorkspaceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDatabricksWorkspaceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/databricks_workspace azurerm_databricks_workspace}
*/
export declare class DataAzurermDatabricksWorkspace extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_databricks_workspace";
    /**
    * Generates CDKTF code for importing a DataAzurermDatabricksWorkspace resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDatabricksWorkspace to import
    * @param importFromId The id of the existing DataAzurermDatabricksWorkspace that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/databricks_workspace#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDatabricksWorkspace to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/databricks_workspace azurerm_databricks_workspace} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDatabricksWorkspaceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDatabricksWorkspaceConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _managedDiskIdentity;
    get managedDiskIdentity(): DataAzurermDatabricksWorkspaceManagedDiskIdentityList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    private _storageAccountIdentity;
    get storageAccountIdentity(): DataAzurermDatabricksWorkspaceStorageAccountIdentityList;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get workspaceId(): string;
    get workspaceUrl(): string;
    private _timeouts;
    get timeouts(): DataAzurermDatabricksWorkspaceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDatabricksWorkspaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDatabricksWorkspaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
