/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMaintenanceConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/maintenance_configuration#id DataAzurermMaintenanceConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/maintenance_configuration#name DataAzurermMaintenanceConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/maintenance_configuration#resource_group_name DataAzurermMaintenanceConfiguration#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/maintenance_configuration#timeouts DataAzurermMaintenanceConfiguration#timeouts}
    */
    readonly timeouts?: DataAzurermMaintenanceConfigurationTimeouts;
}
export interface DataAzurermMaintenanceConfigurationInstallPatchesLinux {
}
export declare function dataAzurermMaintenanceConfigurationInstallPatchesLinuxToTerraform(struct?: DataAzurermMaintenanceConfigurationInstallPatchesLinux): any;
export declare function dataAzurermMaintenanceConfigurationInstallPatchesLinuxToHclTerraform(struct?: DataAzurermMaintenanceConfigurationInstallPatchesLinux): any;
export declare class DataAzurermMaintenanceConfigurationInstallPatchesLinuxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMaintenanceConfigurationInstallPatchesLinux | undefined;
    set internalValue(value: DataAzurermMaintenanceConfigurationInstallPatchesLinux | undefined);
    get classificationsToInclude(): string[];
    get packageNamesMaskToExclude(): string[];
    get packageNamesMaskToInclude(): string[];
}
export declare class DataAzurermMaintenanceConfigurationInstallPatchesLinuxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMaintenanceConfigurationInstallPatchesLinuxOutputReference;
}
export interface DataAzurermMaintenanceConfigurationInstallPatchesWindows {
}
export declare function dataAzurermMaintenanceConfigurationInstallPatchesWindowsToTerraform(struct?: DataAzurermMaintenanceConfigurationInstallPatchesWindows): any;
export declare function dataAzurermMaintenanceConfigurationInstallPatchesWindowsToHclTerraform(struct?: DataAzurermMaintenanceConfigurationInstallPatchesWindows): any;
export declare class DataAzurermMaintenanceConfigurationInstallPatchesWindowsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMaintenanceConfigurationInstallPatchesWindows | undefined;
    set internalValue(value: DataAzurermMaintenanceConfigurationInstallPatchesWindows | undefined);
    get classificationsToInclude(): string[];
    get kbNumbersToExclude(): string[];
    get kbNumbersToInclude(): string[];
}
export declare class DataAzurermMaintenanceConfigurationInstallPatchesWindowsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMaintenanceConfigurationInstallPatchesWindowsOutputReference;
}
export interface DataAzurermMaintenanceConfigurationInstallPatches {
}
export declare function dataAzurermMaintenanceConfigurationInstallPatchesToTerraform(struct?: DataAzurermMaintenanceConfigurationInstallPatches): any;
export declare function dataAzurermMaintenanceConfigurationInstallPatchesToHclTerraform(struct?: DataAzurermMaintenanceConfigurationInstallPatches): any;
export declare class DataAzurermMaintenanceConfigurationInstallPatchesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMaintenanceConfigurationInstallPatches | undefined;
    set internalValue(value: DataAzurermMaintenanceConfigurationInstallPatches | undefined);
    private _linux;
    get linux(): DataAzurermMaintenanceConfigurationInstallPatchesLinuxList;
    get reboot(): string;
    private _windows;
    get windows(): DataAzurermMaintenanceConfigurationInstallPatchesWindowsList;
}
export declare class DataAzurermMaintenanceConfigurationInstallPatchesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMaintenanceConfigurationInstallPatchesOutputReference;
}
export interface DataAzurermMaintenanceConfigurationWindow {
}
export declare function dataAzurermMaintenanceConfigurationWindowToTerraform(struct?: DataAzurermMaintenanceConfigurationWindow): any;
export declare function dataAzurermMaintenanceConfigurationWindowToHclTerraform(struct?: DataAzurermMaintenanceConfigurationWindow): any;
export declare class DataAzurermMaintenanceConfigurationWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMaintenanceConfigurationWindow | undefined;
    set internalValue(value: DataAzurermMaintenanceConfigurationWindow | undefined);
    get duration(): string;
    get expirationDateTime(): string;
    get recurEvery(): string;
    get startDateTime(): string;
    get timeZone(): string;
}
export declare class DataAzurermMaintenanceConfigurationWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMaintenanceConfigurationWindowOutputReference;
}
export interface DataAzurermMaintenanceConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/maintenance_configuration#read DataAzurermMaintenanceConfiguration#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMaintenanceConfigurationTimeoutsToTerraform(struct?: DataAzurermMaintenanceConfigurationTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermMaintenanceConfigurationTimeoutsToHclTerraform(struct?: DataAzurermMaintenanceConfigurationTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMaintenanceConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMaintenanceConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMaintenanceConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/maintenance_configuration azurerm_maintenance_configuration}
*/
export declare class DataAzurermMaintenanceConfiguration extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_maintenance_configuration";
    /**
    * Generates CDKTF code for importing a DataAzurermMaintenanceConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermMaintenanceConfiguration to import
    * @param importFromId The id of the existing DataAzurermMaintenanceConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/maintenance_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermMaintenanceConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/maintenance_configuration azurerm_maintenance_configuration} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMaintenanceConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMaintenanceConfigurationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get inGuestUserPatchMode(): string;
    private _installPatches;
    get installPatches(): DataAzurermMaintenanceConfigurationInstallPatchesList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _properties;
    get properties(): cdktf.StringMap;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get scope(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get visibility(): string;
    private _window;
    get window(): DataAzurermMaintenanceConfigurationWindowList;
    private _timeouts;
    get timeouts(): DataAzurermMaintenanceConfigurationTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMaintenanceConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMaintenanceConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
