/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMobileNetworkPacketCoreDataPlaneConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/mobile_network_packet_core_data_plane#id DataAzurermMobileNetworkPacketCoreDataPlane#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/mobile_network_packet_core_data_plane#mobile_network_packet_core_control_plane_id DataAzurermMobileNetworkPacketCoreDataPlane#mobile_network_packet_core_control_plane_id}
    */
    readonly mobileNetworkPacketCoreControlPlaneId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/mobile_network_packet_core_data_plane#name DataAzurermMobileNetworkPacketCoreDataPlane#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/mobile_network_packet_core_data_plane#timeouts DataAzurermMobileNetworkPacketCoreDataPlane#timeouts}
    */
    readonly timeouts?: DataAzurermMobileNetworkPacketCoreDataPlaneTimeouts;
}
export interface DataAzurermMobileNetworkPacketCoreDataPlaneTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/mobile_network_packet_core_data_plane#read DataAzurermMobileNetworkPacketCoreDataPlane#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMobileNetworkPacketCoreDataPlaneTimeoutsToTerraform(struct?: DataAzurermMobileNetworkPacketCoreDataPlaneTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermMobileNetworkPacketCoreDataPlaneTimeoutsToHclTerraform(struct?: DataAzurermMobileNetworkPacketCoreDataPlaneTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMobileNetworkPacketCoreDataPlaneTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMobileNetworkPacketCoreDataPlaneTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMobileNetworkPacketCoreDataPlaneTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/mobile_network_packet_core_data_plane azurerm_mobile_network_packet_core_data_plane}
*/
export declare class DataAzurermMobileNetworkPacketCoreDataPlane extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mobile_network_packet_core_data_plane";
    /**
    * Generates CDKTF code for importing a DataAzurermMobileNetworkPacketCoreDataPlane resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermMobileNetworkPacketCoreDataPlane to import
    * @param importFromId The id of the existing DataAzurermMobileNetworkPacketCoreDataPlane that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/mobile_network_packet_core_data_plane#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermMobileNetworkPacketCoreDataPlane to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/mobile_network_packet_core_data_plane azurerm_mobile_network_packet_core_data_plane} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMobileNetworkPacketCoreDataPlaneConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMobileNetworkPacketCoreDataPlaneConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _mobileNetworkPacketCoreControlPlaneId?;
    get mobileNetworkPacketCoreControlPlaneId(): string;
    set mobileNetworkPacketCoreControlPlaneId(value: string);
    get mobileNetworkPacketCoreControlPlaneIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get userPlaneAccessIpv4Address(): string;
    get userPlaneAccessIpv4Gateway(): string;
    get userPlaneAccessIpv4Subnet(): string;
    get userPlaneAccessName(): string;
    private _timeouts;
    get timeouts(): DataAzurermMobileNetworkPacketCoreDataPlaneTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMobileNetworkPacketCoreDataPlaneTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMobileNetworkPacketCoreDataPlaneTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
