/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMobileNetworkSimConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/mobile_network_sim#id DataAzurermMobileNetworkSim#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/mobile_network_sim#mobile_network_sim_group_id DataAzurermMobileNetworkSim#mobile_network_sim_group_id}
    */
    readonly mobileNetworkSimGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/mobile_network_sim#name DataAzurermMobileNetworkSim#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/mobile_network_sim#timeouts DataAzurermMobileNetworkSim#timeouts}
    */
    readonly timeouts?: DataAzurermMobileNetworkSimTimeouts;
}
export interface DataAzurermMobileNetworkSimStaticIpConfiguration {
}
export declare function dataAzurermMobileNetworkSimStaticIpConfigurationToTerraform(struct?: DataAzurermMobileNetworkSimStaticIpConfiguration): any;
export declare function dataAzurermMobileNetworkSimStaticIpConfigurationToHclTerraform(struct?: DataAzurermMobileNetworkSimStaticIpConfiguration): any;
export declare class DataAzurermMobileNetworkSimStaticIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkSimStaticIpConfiguration | undefined;
    set internalValue(value: DataAzurermMobileNetworkSimStaticIpConfiguration | undefined);
    get attachedDataNetworkId(): string;
    get sliceId(): string;
    get staticIpv4Address(): string;
}
export declare class DataAzurermMobileNetworkSimStaticIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkSimStaticIpConfigurationOutputReference;
}
export interface DataAzurermMobileNetworkSimTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/mobile_network_sim#read DataAzurermMobileNetworkSim#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMobileNetworkSimTimeoutsToTerraform(struct?: DataAzurermMobileNetworkSimTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermMobileNetworkSimTimeoutsToHclTerraform(struct?: DataAzurermMobileNetworkSimTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMobileNetworkSimTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMobileNetworkSimTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMobileNetworkSimTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/mobile_network_sim azurerm_mobile_network_sim}
*/
export declare class DataAzurermMobileNetworkSim extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mobile_network_sim";
    /**
    * Generates CDKTF code for importing a DataAzurermMobileNetworkSim resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermMobileNetworkSim to import
    * @param importFromId The id of the existing DataAzurermMobileNetworkSim that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/mobile_network_sim#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermMobileNetworkSim to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/mobile_network_sim azurerm_mobile_network_sim} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMobileNetworkSimConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMobileNetworkSimConfig);
    get deviceType(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get integratedCircuitCardIdentifier(): string;
    get internationalMobileSubscriberIdentity(): string;
    private _mobileNetworkSimGroupId?;
    get mobileNetworkSimGroupId(): string;
    set mobileNetworkSimGroupId(value: string);
    get mobileNetworkSimGroupIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get simPolicyId(): string;
    get simState(): string;
    private _staticIpConfiguration;
    get staticIpConfiguration(): DataAzurermMobileNetworkSimStaticIpConfigurationList;
    get vendorKeyFingerprint(): string;
    get vendorName(): string;
    private _timeouts;
    get timeouts(): DataAzurermMobileNetworkSimTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMobileNetworkSimTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMobileNetworkSimTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
