/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPrivateDnsZoneConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/private_dns_zone#id DataAzurermPrivateDnsZone#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/private_dns_zone#name DataAzurermPrivateDnsZone#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/private_dns_zone#resource_group_name DataAzurermPrivateDnsZone#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/private_dns_zone#tags DataAzurermPrivateDnsZone#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/private_dns_zone#timeouts DataAzurermPrivateDnsZone#timeouts}
    */
    readonly timeouts?: DataAzurermPrivateDnsZoneTimeouts;
}
export interface DataAzurermPrivateDnsZoneTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/private_dns_zone#read DataAzurermPrivateDnsZone#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPrivateDnsZoneTimeoutsToTerraform(struct?: DataAzurermPrivateDnsZoneTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermPrivateDnsZoneTimeoutsToHclTerraform(struct?: DataAzurermPrivateDnsZoneTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPrivateDnsZoneTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPrivateDnsZoneTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermPrivateDnsZoneTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/private_dns_zone azurerm_private_dns_zone}
*/
export declare class DataAzurermPrivateDnsZone extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_private_dns_zone";
    /**
    * Generates CDKTF code for importing a DataAzurermPrivateDnsZone resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermPrivateDnsZone to import
    * @param importFromId The id of the existing DataAzurermPrivateDnsZone that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/private_dns_zone#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermPrivateDnsZone to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/private_dns_zone azurerm_private_dns_zone} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPrivateDnsZoneConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPrivateDnsZoneConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get maxNumberOfRecordSets(): number;
    get maxNumberOfVirtualNetworkLinks(): number;
    get maxNumberOfVirtualNetworkLinksWithRegistration(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get numberOfRecordSets(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): DataAzurermPrivateDnsZoneTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPrivateDnsZoneTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermPrivateDnsZoneTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
