/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermServicebusQueueConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_queue#id DataAzurermServicebusQueue#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_queue#name DataAzurermServicebusQueue#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_queue#namespace_id DataAzurermServicebusQueue#namespace_id}
    */
    readonly namespaceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_queue#namespace_name DataAzurermServicebusQueue#namespace_name}
    */
    readonly namespaceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_queue#resource_group_name DataAzurermServicebusQueue#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_queue#timeouts DataAzurermServicebusQueue#timeouts}
    */
    readonly timeouts?: DataAzurermServicebusQueueTimeouts;
}
export interface DataAzurermServicebusQueueTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_queue#read DataAzurermServicebusQueue#read}
    */
    readonly read?: string;
}
export declare function dataAzurermServicebusQueueTimeoutsToTerraform(struct?: DataAzurermServicebusQueueTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermServicebusQueueTimeoutsToHclTerraform(struct?: DataAzurermServicebusQueueTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermServicebusQueueTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermServicebusQueueTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermServicebusQueueTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_queue azurerm_servicebus_queue}
*/
export declare class DataAzurermServicebusQueue extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_servicebus_queue";
    /**
    * Generates CDKTF code for importing a DataAzurermServicebusQueue resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermServicebusQueue to import
    * @param importFromId The id of the existing DataAzurermServicebusQueue that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_queue#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermServicebusQueue to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_queue azurerm_servicebus_queue} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermServicebusQueueConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermServicebusQueueConfig);
    get autoDeleteOnIdle(): string;
    get deadLetteringOnMessageExpiration(): cdktf.IResolvable;
    get defaultMessageTtl(): string;
    get duplicateDetectionHistoryTimeWindow(): string;
    get enableBatchedOperations(): cdktf.IResolvable;
    get enableExpress(): cdktf.IResolvable;
    get enablePartitioning(): cdktf.IResolvable;
    get forwardDeadLetteredMessagesTo(): string;
    get forwardTo(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lockDuration(): string;
    get maxDeliveryCount(): number;
    get maxSizeInMegabytes(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceId?;
    get namespaceId(): string;
    set namespaceId(value: string);
    resetNamespaceId(): void;
    get namespaceIdInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    resetNamespaceName(): void;
    get namespaceNameInput(): string | undefined;
    get requiresDuplicateDetection(): cdktf.IResolvable;
    get requiresSession(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    get status(): string;
    private _timeouts;
    get timeouts(): DataAzurermServicebusQueueTimeoutsOutputReference;
    putTimeouts(value: DataAzurermServicebusQueueTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermServicebusQueueTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
