/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermServicebusSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_subscription#id DataAzurermServicebusSubscription#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_subscription#name DataAzurermServicebusSubscription#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_subscription#namespace_name DataAzurermServicebusSubscription#namespace_name}
    */
    readonly namespaceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_subscription#resource_group_name DataAzurermServicebusSubscription#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_subscription#topic_id DataAzurermServicebusSubscription#topic_id}
    */
    readonly topicId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_subscription#topic_name DataAzurermServicebusSubscription#topic_name}
    */
    readonly topicName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_subscription#timeouts DataAzurermServicebusSubscription#timeouts}
    */
    readonly timeouts?: DataAzurermServicebusSubscriptionTimeouts;
}
export interface DataAzurermServicebusSubscriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_subscription#read DataAzurermServicebusSubscription#read}
    */
    readonly read?: string;
}
export declare function dataAzurermServicebusSubscriptionTimeoutsToTerraform(struct?: DataAzurermServicebusSubscriptionTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermServicebusSubscriptionTimeoutsToHclTerraform(struct?: DataAzurermServicebusSubscriptionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermServicebusSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermServicebusSubscriptionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermServicebusSubscriptionTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_subscription azurerm_servicebus_subscription}
*/
export declare class DataAzurermServicebusSubscription extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_servicebus_subscription";
    /**
    * Generates CDKTF code for importing a DataAzurermServicebusSubscription resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermServicebusSubscription to import
    * @param importFromId The id of the existing DataAzurermServicebusSubscription that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_subscription#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermServicebusSubscription to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/data-sources/servicebus_subscription azurerm_servicebus_subscription} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermServicebusSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermServicebusSubscriptionConfig);
    get autoDeleteOnIdle(): string;
    get deadLetteringOnFilterEvaluationError(): cdktf.IResolvable;
    get deadLetteringOnMessageExpiration(): cdktf.IResolvable;
    get defaultMessageTtl(): string;
    get enableBatchedOperations(): cdktf.IResolvable;
    get forwardDeadLetteredMessagesTo(): string;
    get forwardTo(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lockDuration(): string;
    get maxDeliveryCount(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    resetNamespaceName(): void;
    get namespaceNameInput(): string | undefined;
    get requiresSession(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    private _topicId?;
    get topicId(): string;
    set topicId(value: string);
    resetTopicId(): void;
    get topicIdInput(): string | undefined;
    private _topicName?;
    get topicName(): string;
    set topicName(value: string);
    resetTopicName(): void;
    get topicNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermServicebusSubscriptionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermServicebusSubscriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermServicebusSubscriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
