"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabricksWorkspace = exports.DatabricksWorkspaceTimeoutsOutputReference = exports.databricksWorkspaceTimeoutsToHclTerraform = exports.databricksWorkspaceTimeoutsToTerraform = exports.DatabricksWorkspaceCustomParametersOutputReference = exports.databricksWorkspaceCustomParametersToHclTerraform = exports.databricksWorkspaceCustomParametersToTerraform = exports.DatabricksWorkspaceStorageAccountIdentityList = exports.DatabricksWorkspaceStorageAccountIdentityOutputReference = exports.databricksWorkspaceStorageAccountIdentityToHclTerraform = exports.databricksWorkspaceStorageAccountIdentityToTerraform = exports.DatabricksWorkspaceManagedDiskIdentityList = exports.DatabricksWorkspaceManagedDiskIdentityOutputReference = exports.databricksWorkspaceManagedDiskIdentityToHclTerraform = exports.databricksWorkspaceManagedDiskIdentityToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function databricksWorkspaceManagedDiskIdentityToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.databricksWorkspaceManagedDiskIdentityToTerraform = databricksWorkspaceManagedDiskIdentityToTerraform;
function databricksWorkspaceManagedDiskIdentityToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {};
    return attrs;
}
exports.databricksWorkspaceManagedDiskIdentityToHclTerraform = databricksWorkspaceManagedDiskIdentityToHclTerraform;
class DatabricksWorkspaceManagedDiskIdentityOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // principal_id - computed: true, optional: false, required: false
    get principalId() {
        return this.getStringAttribute('principal_id');
    }
    // tenant_id - computed: true, optional: false, required: false
    get tenantId() {
        return this.getStringAttribute('tenant_id');
    }
    // type - computed: true, optional: false, required: false
    get type() {
        return this.getStringAttribute('type');
    }
}
exports.DatabricksWorkspaceManagedDiskIdentityOutputReference = DatabricksWorkspaceManagedDiskIdentityOutputReference;
_a = JSII_RTTI_SYMBOL_1;
DatabricksWorkspaceManagedDiskIdentityOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.databricksWorkspace.DatabricksWorkspaceManagedDiskIdentityOutputReference", version: "12.3.0" };
class DatabricksWorkspaceManagedDiskIdentityList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new DatabricksWorkspaceManagedDiskIdentityOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.DatabricksWorkspaceManagedDiskIdentityList = DatabricksWorkspaceManagedDiskIdentityList;
_b = JSII_RTTI_SYMBOL_1;
DatabricksWorkspaceManagedDiskIdentityList[_b] = { fqn: "@cdktf/provider-azurerm.databricksWorkspace.DatabricksWorkspaceManagedDiskIdentityList", version: "12.3.0" };
function databricksWorkspaceStorageAccountIdentityToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.databricksWorkspaceStorageAccountIdentityToTerraform = databricksWorkspaceStorageAccountIdentityToTerraform;
function databricksWorkspaceStorageAccountIdentityToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {};
    return attrs;
}
exports.databricksWorkspaceStorageAccountIdentityToHclTerraform = databricksWorkspaceStorageAccountIdentityToHclTerraform;
class DatabricksWorkspaceStorageAccountIdentityOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // principal_id - computed: true, optional: false, required: false
    get principalId() {
        return this.getStringAttribute('principal_id');
    }
    // tenant_id - computed: true, optional: false, required: false
    get tenantId() {
        return this.getStringAttribute('tenant_id');
    }
    // type - computed: true, optional: false, required: false
    get type() {
        return this.getStringAttribute('type');
    }
}
exports.DatabricksWorkspaceStorageAccountIdentityOutputReference = DatabricksWorkspaceStorageAccountIdentityOutputReference;
_c = JSII_RTTI_SYMBOL_1;
DatabricksWorkspaceStorageAccountIdentityOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.databricksWorkspace.DatabricksWorkspaceStorageAccountIdentityOutputReference", version: "12.3.0" };
class DatabricksWorkspaceStorageAccountIdentityList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new DatabricksWorkspaceStorageAccountIdentityOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.DatabricksWorkspaceStorageAccountIdentityList = DatabricksWorkspaceStorageAccountIdentityList;
_d = JSII_RTTI_SYMBOL_1;
DatabricksWorkspaceStorageAccountIdentityList[_d] = { fqn: "@cdktf/provider-azurerm.databricksWorkspace.DatabricksWorkspaceStorageAccountIdentityList", version: "12.3.0" };
function databricksWorkspaceCustomParametersToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        machine_learning_workspace_id: cdktf.stringToTerraform(struct.machineLearningWorkspaceId),
        nat_gateway_name: cdktf.stringToTerraform(struct.natGatewayName),
        no_public_ip: cdktf.booleanToTerraform(struct.noPublicIp),
        private_subnet_name: cdktf.stringToTerraform(struct.privateSubnetName),
        private_subnet_network_security_group_association_id: cdktf.stringToTerraform(struct.privateSubnetNetworkSecurityGroupAssociationId),
        public_ip_name: cdktf.stringToTerraform(struct.publicIpName),
        public_subnet_name: cdktf.stringToTerraform(struct.publicSubnetName),
        public_subnet_network_security_group_association_id: cdktf.stringToTerraform(struct.publicSubnetNetworkSecurityGroupAssociationId),
        storage_account_name: cdktf.stringToTerraform(struct.storageAccountName),
        storage_account_sku_name: cdktf.stringToTerraform(struct.storageAccountSkuName),
        virtual_network_id: cdktf.stringToTerraform(struct.virtualNetworkId),
        vnet_address_prefix: cdktf.stringToTerraform(struct.vnetAddressPrefix),
    };
}
exports.databricksWorkspaceCustomParametersToTerraform = databricksWorkspaceCustomParametersToTerraform;
function databricksWorkspaceCustomParametersToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        machine_learning_workspace_id: {
            value: cdktf.stringToHclTerraform(struct.machineLearningWorkspaceId),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        nat_gateway_name: {
            value: cdktf.stringToHclTerraform(struct.natGatewayName),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        no_public_ip: {
            value: cdktf.booleanToHclTerraform(struct.noPublicIp),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        private_subnet_name: {
            value: cdktf.stringToHclTerraform(struct.privateSubnetName),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        private_subnet_network_security_group_association_id: {
            value: cdktf.stringToHclTerraform(struct.privateSubnetNetworkSecurityGroupAssociationId),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        public_ip_name: {
            value: cdktf.stringToHclTerraform(struct.publicIpName),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        public_subnet_name: {
            value: cdktf.stringToHclTerraform(struct.publicSubnetName),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        public_subnet_network_security_group_association_id: {
            value: cdktf.stringToHclTerraform(struct.publicSubnetNetworkSecurityGroupAssociationId),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        storage_account_name: {
            value: cdktf.stringToHclTerraform(struct.storageAccountName),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        storage_account_sku_name: {
            value: cdktf.stringToHclTerraform(struct.storageAccountSkuName),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        virtual_network_id: {
            value: cdktf.stringToHclTerraform(struct.virtualNetworkId),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        vnet_address_prefix: {
            value: cdktf.stringToHclTerraform(struct.vnetAddressPrefix),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.databricksWorkspaceCustomParametersToHclTerraform = databricksWorkspaceCustomParametersToHclTerraform;
class DatabricksWorkspaceCustomParametersOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._machineLearningWorkspaceId !== undefined) {
            hasAnyValues = true;
            internalValueResult.machineLearningWorkspaceId = this._machineLearningWorkspaceId;
        }
        if (this._natGatewayName !== undefined) {
            hasAnyValues = true;
            internalValueResult.natGatewayName = this._natGatewayName;
        }
        if (this._noPublicIp !== undefined) {
            hasAnyValues = true;
            internalValueResult.noPublicIp = this._noPublicIp;
        }
        if (this._privateSubnetName !== undefined) {
            hasAnyValues = true;
            internalValueResult.privateSubnetName = this._privateSubnetName;
        }
        if (this._privateSubnetNetworkSecurityGroupAssociationId !== undefined) {
            hasAnyValues = true;
            internalValueResult.privateSubnetNetworkSecurityGroupAssociationId = this._privateSubnetNetworkSecurityGroupAssociationId;
        }
        if (this._publicIpName !== undefined) {
            hasAnyValues = true;
            internalValueResult.publicIpName = this._publicIpName;
        }
        if (this._publicSubnetName !== undefined) {
            hasAnyValues = true;
            internalValueResult.publicSubnetName = this._publicSubnetName;
        }
        if (this._publicSubnetNetworkSecurityGroupAssociationId !== undefined) {
            hasAnyValues = true;
            internalValueResult.publicSubnetNetworkSecurityGroupAssociationId = this._publicSubnetNetworkSecurityGroupAssociationId;
        }
        if (this._storageAccountName !== undefined) {
            hasAnyValues = true;
            internalValueResult.storageAccountName = this._storageAccountName;
        }
        if (this._storageAccountSkuName !== undefined) {
            hasAnyValues = true;
            internalValueResult.storageAccountSkuName = this._storageAccountSkuName;
        }
        if (this._virtualNetworkId !== undefined) {
            hasAnyValues = true;
            internalValueResult.virtualNetworkId = this._virtualNetworkId;
        }
        if (this._vnetAddressPrefix !== undefined) {
            hasAnyValues = true;
            internalValueResult.vnetAddressPrefix = this._vnetAddressPrefix;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._machineLearningWorkspaceId = undefined;
            this._natGatewayName = undefined;
            this._noPublicIp = undefined;
            this._privateSubnetName = undefined;
            this._privateSubnetNetworkSecurityGroupAssociationId = undefined;
            this._publicIpName = undefined;
            this._publicSubnetName = undefined;
            this._publicSubnetNetworkSecurityGroupAssociationId = undefined;
            this._storageAccountName = undefined;
            this._storageAccountSkuName = undefined;
            this._virtualNetworkId = undefined;
            this._vnetAddressPrefix = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._machineLearningWorkspaceId = value.machineLearningWorkspaceId;
            this._natGatewayName = value.natGatewayName;
            this._noPublicIp = value.noPublicIp;
            this._privateSubnetName = value.privateSubnetName;
            this._privateSubnetNetworkSecurityGroupAssociationId = value.privateSubnetNetworkSecurityGroupAssociationId;
            this._publicIpName = value.publicIpName;
            this._publicSubnetName = value.publicSubnetName;
            this._publicSubnetNetworkSecurityGroupAssociationId = value.publicSubnetNetworkSecurityGroupAssociationId;
            this._storageAccountName = value.storageAccountName;
            this._storageAccountSkuName = value.storageAccountSkuName;
            this._virtualNetworkId = value.virtualNetworkId;
            this._vnetAddressPrefix = value.vnetAddressPrefix;
        }
    }
    get machineLearningWorkspaceId() {
        return this.getStringAttribute('machine_learning_workspace_id');
    }
    set machineLearningWorkspaceId(value) {
        this._machineLearningWorkspaceId = value;
    }
    resetMachineLearningWorkspaceId() {
        this._machineLearningWorkspaceId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get machineLearningWorkspaceIdInput() {
        return this._machineLearningWorkspaceId;
    }
    get natGatewayName() {
        return this.getStringAttribute('nat_gateway_name');
    }
    set natGatewayName(value) {
        this._natGatewayName = value;
    }
    resetNatGatewayName() {
        this._natGatewayName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get natGatewayNameInput() {
        return this._natGatewayName;
    }
    get noPublicIp() {
        return this.getBooleanAttribute('no_public_ip');
    }
    set noPublicIp(value) {
        this._noPublicIp = value;
    }
    resetNoPublicIp() {
        this._noPublicIp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get noPublicIpInput() {
        return this._noPublicIp;
    }
    get privateSubnetName() {
        return this.getStringAttribute('private_subnet_name');
    }
    set privateSubnetName(value) {
        this._privateSubnetName = value;
    }
    resetPrivateSubnetName() {
        this._privateSubnetName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateSubnetNameInput() {
        return this._privateSubnetName;
    }
    get privateSubnetNetworkSecurityGroupAssociationId() {
        return this.getStringAttribute('private_subnet_network_security_group_association_id');
    }
    set privateSubnetNetworkSecurityGroupAssociationId(value) {
        this._privateSubnetNetworkSecurityGroupAssociationId = value;
    }
    resetPrivateSubnetNetworkSecurityGroupAssociationId() {
        this._privateSubnetNetworkSecurityGroupAssociationId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateSubnetNetworkSecurityGroupAssociationIdInput() {
        return this._privateSubnetNetworkSecurityGroupAssociationId;
    }
    get publicIpName() {
        return this.getStringAttribute('public_ip_name');
    }
    set publicIpName(value) {
        this._publicIpName = value;
    }
    resetPublicIpName() {
        this._publicIpName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publicIpNameInput() {
        return this._publicIpName;
    }
    get publicSubnetName() {
        return this.getStringAttribute('public_subnet_name');
    }
    set publicSubnetName(value) {
        this._publicSubnetName = value;
    }
    resetPublicSubnetName() {
        this._publicSubnetName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publicSubnetNameInput() {
        return this._publicSubnetName;
    }
    get publicSubnetNetworkSecurityGroupAssociationId() {
        return this.getStringAttribute('public_subnet_network_security_group_association_id');
    }
    set publicSubnetNetworkSecurityGroupAssociationId(value) {
        this._publicSubnetNetworkSecurityGroupAssociationId = value;
    }
    resetPublicSubnetNetworkSecurityGroupAssociationId() {
        this._publicSubnetNetworkSecurityGroupAssociationId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publicSubnetNetworkSecurityGroupAssociationIdInput() {
        return this._publicSubnetNetworkSecurityGroupAssociationId;
    }
    get storageAccountName() {
        return this.getStringAttribute('storage_account_name');
    }
    set storageAccountName(value) {
        this._storageAccountName = value;
    }
    resetStorageAccountName() {
        this._storageAccountName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageAccountNameInput() {
        return this._storageAccountName;
    }
    get storageAccountSkuName() {
        return this.getStringAttribute('storage_account_sku_name');
    }
    set storageAccountSkuName(value) {
        this._storageAccountSkuName = value;
    }
    resetStorageAccountSkuName() {
        this._storageAccountSkuName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageAccountSkuNameInput() {
        return this._storageAccountSkuName;
    }
    get virtualNetworkId() {
        return this.getStringAttribute('virtual_network_id');
    }
    set virtualNetworkId(value) {
        this._virtualNetworkId = value;
    }
    resetVirtualNetworkId() {
        this._virtualNetworkId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get virtualNetworkIdInput() {
        return this._virtualNetworkId;
    }
    get vnetAddressPrefix() {
        return this.getStringAttribute('vnet_address_prefix');
    }
    set vnetAddressPrefix(value) {
        this._vnetAddressPrefix = value;
    }
    resetVnetAddressPrefix() {
        this._vnetAddressPrefix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vnetAddressPrefixInput() {
        return this._vnetAddressPrefix;
    }
}
exports.DatabricksWorkspaceCustomParametersOutputReference = DatabricksWorkspaceCustomParametersOutputReference;
_e = JSII_RTTI_SYMBOL_1;
DatabricksWorkspaceCustomParametersOutputReference[_e] = { fqn: "@cdktf/provider-azurerm.databricksWorkspace.DatabricksWorkspaceCustomParametersOutputReference", version: "12.3.0" };
function databricksWorkspaceTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.databricksWorkspaceTimeoutsToTerraform = databricksWorkspaceTimeoutsToTerraform;
function databricksWorkspaceTimeoutsToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        create: {
            value: cdktf.stringToHclTerraform(struct.create),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        delete: {
            value: cdktf.stringToHclTerraform(struct.delete),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        read: {
            value: cdktf.stringToHclTerraform(struct.read),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        update: {
            value: cdktf.stringToHclTerraform(struct.update),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.databricksWorkspaceTimeoutsToHclTerraform = databricksWorkspaceTimeoutsToHclTerraform;
class DatabricksWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.DatabricksWorkspaceTimeoutsOutputReference = DatabricksWorkspaceTimeoutsOutputReference;
_f = JSII_RTTI_SYMBOL_1;
DatabricksWorkspaceTimeoutsOutputReference[_f] = { fqn: "@cdktf/provider-azurerm.databricksWorkspace.DatabricksWorkspaceTimeoutsOutputReference", version: "12.3.0" };
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/databricks_workspace azurerm_databricks_workspace}
*/
class DatabricksWorkspace extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a DatabricksWorkspace resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DatabricksWorkspace to import
    * @param importFromId The id of the existing DatabricksWorkspace that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/databricks_workspace#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DatabricksWorkspace to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "azurerm_databricks_workspace", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/databricks_workspace azurerm_databricks_workspace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabricksWorkspaceConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_databricks_workspace',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.89.0',
                providerVersionConstraint: '~> 3.10'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // managed_disk_identity - computed: true, optional: false, required: false
        this._managedDiskIdentity = new DatabricksWorkspaceManagedDiskIdentityList(this, "managed_disk_identity", false);
        // storage_account_identity - computed: true, optional: false, required: false
        this._storageAccountIdentity = new DatabricksWorkspaceStorageAccountIdentityList(this, "storage_account_identity", false);
        // custom_parameters - computed: false, optional: true, required: false
        this._customParameters = new DatabricksWorkspaceCustomParametersOutputReference(this, "custom_parameters");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new DatabricksWorkspaceTimeoutsOutputReference(this, "timeouts");
        this._customerManagedKeyEnabled = config.customerManagedKeyEnabled;
        this._id = config.id;
        this._infrastructureEncryptionEnabled = config.infrastructureEncryptionEnabled;
        this._loadBalancerBackendAddressPoolId = config.loadBalancerBackendAddressPoolId;
        this._location = config.location;
        this._managedDiskCmkKeyVaultKeyId = config.managedDiskCmkKeyVaultKeyId;
        this._managedDiskCmkRotationToLatestVersionEnabled = config.managedDiskCmkRotationToLatestVersionEnabled;
        this._managedResourceGroupName = config.managedResourceGroupName;
        this._managedServicesCmkKeyVaultKeyId = config.managedServicesCmkKeyVaultKeyId;
        this._name = config.name;
        this._networkSecurityGroupRulesRequired = config.networkSecurityGroupRulesRequired;
        this._publicNetworkAccessEnabled = config.publicNetworkAccessEnabled;
        this._resourceGroupName = config.resourceGroupName;
        this._sku = config.sku;
        this._tags = config.tags;
        this._customParameters.internalValue = config.customParameters;
        this._timeouts.internalValue = config.timeouts;
    }
    get customerManagedKeyEnabled() {
        return this.getBooleanAttribute('customer_managed_key_enabled');
    }
    set customerManagedKeyEnabled(value) {
        this._customerManagedKeyEnabled = value;
    }
    resetCustomerManagedKeyEnabled() {
        this._customerManagedKeyEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customerManagedKeyEnabledInput() {
        return this._customerManagedKeyEnabled;
    }
    // disk_encryption_set_id - computed: true, optional: false, required: false
    get diskEncryptionSetId() {
        return this.getStringAttribute('disk_encryption_set_id');
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get infrastructureEncryptionEnabled() {
        return this.getBooleanAttribute('infrastructure_encryption_enabled');
    }
    set infrastructureEncryptionEnabled(value) {
        this._infrastructureEncryptionEnabled = value;
    }
    resetInfrastructureEncryptionEnabled() {
        this._infrastructureEncryptionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get infrastructureEncryptionEnabledInput() {
        return this._infrastructureEncryptionEnabled;
    }
    get loadBalancerBackendAddressPoolId() {
        return this.getStringAttribute('load_balancer_backend_address_pool_id');
    }
    set loadBalancerBackendAddressPoolId(value) {
        this._loadBalancerBackendAddressPoolId = value;
    }
    resetLoadBalancerBackendAddressPoolId() {
        this._loadBalancerBackendAddressPoolId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get loadBalancerBackendAddressPoolIdInput() {
        return this._loadBalancerBackendAddressPoolId;
    }
    get location() {
        return this.getStringAttribute('location');
    }
    set location(value) {
        this._location = value;
    }
    // Temporarily expose input value. Use with caution.
    get locationInput() {
        return this._location;
    }
    get managedDiskCmkKeyVaultKeyId() {
        return this.getStringAttribute('managed_disk_cmk_key_vault_key_id');
    }
    set managedDiskCmkKeyVaultKeyId(value) {
        this._managedDiskCmkKeyVaultKeyId = value;
    }
    resetManagedDiskCmkKeyVaultKeyId() {
        this._managedDiskCmkKeyVaultKeyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get managedDiskCmkKeyVaultKeyIdInput() {
        return this._managedDiskCmkKeyVaultKeyId;
    }
    get managedDiskCmkRotationToLatestVersionEnabled() {
        return this.getBooleanAttribute('managed_disk_cmk_rotation_to_latest_version_enabled');
    }
    set managedDiskCmkRotationToLatestVersionEnabled(value) {
        this._managedDiskCmkRotationToLatestVersionEnabled = value;
    }
    resetManagedDiskCmkRotationToLatestVersionEnabled() {
        this._managedDiskCmkRotationToLatestVersionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get managedDiskCmkRotationToLatestVersionEnabledInput() {
        return this._managedDiskCmkRotationToLatestVersionEnabled;
    }
    get managedDiskIdentity() {
        return this._managedDiskIdentity;
    }
    // managed_resource_group_id - computed: true, optional: false, required: false
    get managedResourceGroupId() {
        return this.getStringAttribute('managed_resource_group_id');
    }
    get managedResourceGroupName() {
        return this.getStringAttribute('managed_resource_group_name');
    }
    set managedResourceGroupName(value) {
        this._managedResourceGroupName = value;
    }
    resetManagedResourceGroupName() {
        this._managedResourceGroupName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get managedResourceGroupNameInput() {
        return this._managedResourceGroupName;
    }
    get managedServicesCmkKeyVaultKeyId() {
        return this.getStringAttribute('managed_services_cmk_key_vault_key_id');
    }
    set managedServicesCmkKeyVaultKeyId(value) {
        this._managedServicesCmkKeyVaultKeyId = value;
    }
    resetManagedServicesCmkKeyVaultKeyId() {
        this._managedServicesCmkKeyVaultKeyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get managedServicesCmkKeyVaultKeyIdInput() {
        return this._managedServicesCmkKeyVaultKeyId;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get networkSecurityGroupRulesRequired() {
        return this.getStringAttribute('network_security_group_rules_required');
    }
    set networkSecurityGroupRulesRequired(value) {
        this._networkSecurityGroupRulesRequired = value;
    }
    resetNetworkSecurityGroupRulesRequired() {
        this._networkSecurityGroupRulesRequired = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkSecurityGroupRulesRequiredInput() {
        return this._networkSecurityGroupRulesRequired;
    }
    get publicNetworkAccessEnabled() {
        return this.getBooleanAttribute('public_network_access_enabled');
    }
    set publicNetworkAccessEnabled(value) {
        this._publicNetworkAccessEnabled = value;
    }
    resetPublicNetworkAccessEnabled() {
        this._publicNetworkAccessEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publicNetworkAccessEnabledInput() {
        return this._publicNetworkAccessEnabled;
    }
    get resourceGroupName() {
        return this.getStringAttribute('resource_group_name');
    }
    set resourceGroupName(value) {
        this._resourceGroupName = value;
    }
    // Temporarily expose input value. Use with caution.
    get resourceGroupNameInput() {
        return this._resourceGroupName;
    }
    get sku() {
        return this.getStringAttribute('sku');
    }
    set sku(value) {
        this._sku = value;
    }
    // Temporarily expose input value. Use with caution.
    get skuInput() {
        return this._sku;
    }
    get storageAccountIdentity() {
        return this._storageAccountIdentity;
    }
    get tags() {
        return this.getStringMapAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    // workspace_id - computed: true, optional: false, required: false
    get workspaceId() {
        return this.getStringAttribute('workspace_id');
    }
    // workspace_url - computed: true, optional: false, required: false
    get workspaceUrl() {
        return this.getStringAttribute('workspace_url');
    }
    get customParameters() {
        return this._customParameters;
    }
    putCustomParameters(value) {
        this._customParameters.internalValue = value;
    }
    resetCustomParameters() {
        this._customParameters.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customParametersInput() {
        return this._customParameters.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            customer_managed_key_enabled: cdktf.booleanToTerraform(this._customerManagedKeyEnabled),
            id: cdktf.stringToTerraform(this._id),
            infrastructure_encryption_enabled: cdktf.booleanToTerraform(this._infrastructureEncryptionEnabled),
            load_balancer_backend_address_pool_id: cdktf.stringToTerraform(this._loadBalancerBackendAddressPoolId),
            location: cdktf.stringToTerraform(this._location),
            managed_disk_cmk_key_vault_key_id: cdktf.stringToTerraform(this._managedDiskCmkKeyVaultKeyId),
            managed_disk_cmk_rotation_to_latest_version_enabled: cdktf.booleanToTerraform(this._managedDiskCmkRotationToLatestVersionEnabled),
            managed_resource_group_name: cdktf.stringToTerraform(this._managedResourceGroupName),
            managed_services_cmk_key_vault_key_id: cdktf.stringToTerraform(this._managedServicesCmkKeyVaultKeyId),
            name: cdktf.stringToTerraform(this._name),
            network_security_group_rules_required: cdktf.stringToTerraform(this._networkSecurityGroupRulesRequired),
            public_network_access_enabled: cdktf.booleanToTerraform(this._publicNetworkAccessEnabled),
            resource_group_name: cdktf.stringToTerraform(this._resourceGroupName),
            sku: cdktf.stringToTerraform(this._sku),
            tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._tags),
            custom_parameters: databricksWorkspaceCustomParametersToTerraform(this._customParameters.internalValue),
            timeouts: databricksWorkspaceTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            customer_managed_key_enabled: {
                value: cdktf.booleanToHclTerraform(this._customerManagedKeyEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            infrastructure_encryption_enabled: {
                value: cdktf.booleanToHclTerraform(this._infrastructureEncryptionEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            load_balancer_backend_address_pool_id: {
                value: cdktf.stringToHclTerraform(this._loadBalancerBackendAddressPoolId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            location: {
                value: cdktf.stringToHclTerraform(this._location),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            managed_disk_cmk_key_vault_key_id: {
                value: cdktf.stringToHclTerraform(this._managedDiskCmkKeyVaultKeyId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            managed_disk_cmk_rotation_to_latest_version_enabled: {
                value: cdktf.booleanToHclTerraform(this._managedDiskCmkRotationToLatestVersionEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            managed_resource_group_name: {
                value: cdktf.stringToHclTerraform(this._managedResourceGroupName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            managed_services_cmk_key_vault_key_id: {
                value: cdktf.stringToHclTerraform(this._managedServicesCmkKeyVaultKeyId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            network_security_group_rules_required: {
                value: cdktf.stringToHclTerraform(this._networkSecurityGroupRulesRequired),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            public_network_access_enabled: {
                value: cdktf.booleanToHclTerraform(this._publicNetworkAccessEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            resource_group_name: {
                value: cdktf.stringToHclTerraform(this._resourceGroupName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            sku: {
                value: cdktf.stringToHclTerraform(this._sku),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            tags: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._tags),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            custom_parameters: {
                value: databricksWorkspaceCustomParametersToHclTerraform(this._customParameters.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "DatabricksWorkspaceCustomParametersList",
            },
            timeouts: {
                value: databricksWorkspaceTimeoutsToHclTerraform(this._timeouts.internalValue),
                isBlock: true,
                type: "struct",
                storageClassType: "DatabricksWorkspaceTimeouts",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.DatabricksWorkspace = DatabricksWorkspace;
_g = JSII_RTTI_SYMBOL_1;
DatabricksWorkspace[_g] = { fqn: "@cdktf/provider-azurerm.databricksWorkspace.DatabricksWorkspace", version: "12.3.0" };
// =================
// STATIC PROPERTIES
// =================
DatabricksWorkspace.tfResourceType = "azurerm_databricks_workspace";
//# sourceMappingURL=data:application/json;base64,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