/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DigitalTwinsTimeSeriesDatabaseConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection#digital_twins_id DigitalTwinsTimeSeriesDatabaseConnection#digital_twins_id}
    */
    readonly digitalTwinsId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection#eventhub_consumer_group_name DigitalTwinsTimeSeriesDatabaseConnection#eventhub_consumer_group_name}
    */
    readonly eventhubConsumerGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection#eventhub_name DigitalTwinsTimeSeriesDatabaseConnection#eventhub_name}
    */
    readonly eventhubName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection#eventhub_namespace_endpoint_uri DigitalTwinsTimeSeriesDatabaseConnection#eventhub_namespace_endpoint_uri}
    */
    readonly eventhubNamespaceEndpointUri: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection#eventhub_namespace_id DigitalTwinsTimeSeriesDatabaseConnection#eventhub_namespace_id}
    */
    readonly eventhubNamespaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection#id DigitalTwinsTimeSeriesDatabaseConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection#kusto_cluster_id DigitalTwinsTimeSeriesDatabaseConnection#kusto_cluster_id}
    */
    readonly kustoClusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection#kusto_cluster_uri DigitalTwinsTimeSeriesDatabaseConnection#kusto_cluster_uri}
    */
    readonly kustoClusterUri: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection#kusto_database_name DigitalTwinsTimeSeriesDatabaseConnection#kusto_database_name}
    */
    readonly kustoDatabaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection#kusto_table_name DigitalTwinsTimeSeriesDatabaseConnection#kusto_table_name}
    */
    readonly kustoTableName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection#name DigitalTwinsTimeSeriesDatabaseConnection#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection#timeouts DigitalTwinsTimeSeriesDatabaseConnection#timeouts}
    */
    readonly timeouts?: DigitalTwinsTimeSeriesDatabaseConnectionTimeouts;
}
export interface DigitalTwinsTimeSeriesDatabaseConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection#create DigitalTwinsTimeSeriesDatabaseConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection#delete DigitalTwinsTimeSeriesDatabaseConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection#read DigitalTwinsTimeSeriesDatabaseConnection#read}
    */
    readonly read?: string;
}
export declare function digitalTwinsTimeSeriesDatabaseConnectionTimeoutsToTerraform(struct?: DigitalTwinsTimeSeriesDatabaseConnectionTimeouts | cdktf.IResolvable): any;
export declare function digitalTwinsTimeSeriesDatabaseConnectionTimeoutsToHclTerraform(struct?: DigitalTwinsTimeSeriesDatabaseConnectionTimeouts | cdktf.IResolvable): any;
export declare class DigitalTwinsTimeSeriesDatabaseConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DigitalTwinsTimeSeriesDatabaseConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DigitalTwinsTimeSeriesDatabaseConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection azurerm_digital_twins_time_series_database_connection}
*/
export declare class DigitalTwinsTimeSeriesDatabaseConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_digital_twins_time_series_database_connection";
    /**
    * Generates CDKTF code for importing a DigitalTwinsTimeSeriesDatabaseConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DigitalTwinsTimeSeriesDatabaseConnection to import
    * @param importFromId The id of the existing DigitalTwinsTimeSeriesDatabaseConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DigitalTwinsTimeSeriesDatabaseConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/digital_twins_time_series_database_connection azurerm_digital_twins_time_series_database_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DigitalTwinsTimeSeriesDatabaseConnectionConfig
    */
    constructor(scope: Construct, id: string, config: DigitalTwinsTimeSeriesDatabaseConnectionConfig);
    private _digitalTwinsId?;
    get digitalTwinsId(): string;
    set digitalTwinsId(value: string);
    get digitalTwinsIdInput(): string | undefined;
    private _eventhubConsumerGroupName?;
    get eventhubConsumerGroupName(): string;
    set eventhubConsumerGroupName(value: string);
    resetEventhubConsumerGroupName(): void;
    get eventhubConsumerGroupNameInput(): string | undefined;
    private _eventhubName?;
    get eventhubName(): string;
    set eventhubName(value: string);
    get eventhubNameInput(): string | undefined;
    private _eventhubNamespaceEndpointUri?;
    get eventhubNamespaceEndpointUri(): string;
    set eventhubNamespaceEndpointUri(value: string);
    get eventhubNamespaceEndpointUriInput(): string | undefined;
    private _eventhubNamespaceId?;
    get eventhubNamespaceId(): string;
    set eventhubNamespaceId(value: string);
    get eventhubNamespaceIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kustoClusterId?;
    get kustoClusterId(): string;
    set kustoClusterId(value: string);
    get kustoClusterIdInput(): string | undefined;
    private _kustoClusterUri?;
    get kustoClusterUri(): string;
    set kustoClusterUri(value: string);
    get kustoClusterUriInput(): string | undefined;
    private _kustoDatabaseName?;
    get kustoDatabaseName(): string;
    set kustoDatabaseName(value: string);
    get kustoDatabaseNameInput(): string | undefined;
    private _kustoTableName?;
    get kustoTableName(): string;
    set kustoTableName(value: string);
    resetKustoTableName(): void;
    get kustoTableNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DigitalTwinsTimeSeriesDatabaseConnectionTimeoutsOutputReference;
    putTimeouts(value: DigitalTwinsTimeSeriesDatabaseConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DigitalTwinsTimeSeriesDatabaseConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
