/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LabServiceLabConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#description LabServiceLab#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#id LabServiceLab#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#lab_plan_id LabServiceLab#lab_plan_id}
    */
    readonly labPlanId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#location LabServiceLab#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#name LabServiceLab#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#resource_group_name LabServiceLab#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#tags LabServiceLab#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#title LabServiceLab#title}
    */
    readonly title: string;
    /**
    * auto_shutdown block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#auto_shutdown LabServiceLab#auto_shutdown}
    */
    readonly autoShutdown?: LabServiceLabAutoShutdown;
    /**
    * connection_setting block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#connection_setting LabServiceLab#connection_setting}
    */
    readonly connectionSetting?: LabServiceLabConnectionSetting;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#network LabServiceLab#network}
    */
    readonly network?: LabServiceLabNetwork;
    /**
    * roster block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#roster LabServiceLab#roster}
    */
    readonly roster?: LabServiceLabRoster;
    /**
    * security block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#security LabServiceLab#security}
    */
    readonly security: LabServiceLabSecurity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#timeouts LabServiceLab#timeouts}
    */
    readonly timeouts?: LabServiceLabTimeouts;
    /**
    * virtual_machine block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#virtual_machine LabServiceLab#virtual_machine}
    */
    readonly virtualMachine: LabServiceLabVirtualMachine;
}
export interface LabServiceLabAutoShutdown {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#disconnect_delay LabServiceLab#disconnect_delay}
    */
    readonly disconnectDelay?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#idle_delay LabServiceLab#idle_delay}
    */
    readonly idleDelay?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#no_connect_delay LabServiceLab#no_connect_delay}
    */
    readonly noConnectDelay?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#shutdown_on_idle LabServiceLab#shutdown_on_idle}
    */
    readonly shutdownOnIdle?: string;
}
export declare function labServiceLabAutoShutdownToTerraform(struct?: LabServiceLabAutoShutdownOutputReference | LabServiceLabAutoShutdown): any;
export declare function labServiceLabAutoShutdownToHclTerraform(struct?: LabServiceLabAutoShutdownOutputReference | LabServiceLabAutoShutdown): any;
export declare class LabServiceLabAutoShutdownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServiceLabAutoShutdown | undefined;
    set internalValue(value: LabServiceLabAutoShutdown | undefined);
    private _disconnectDelay?;
    get disconnectDelay(): string;
    set disconnectDelay(value: string);
    resetDisconnectDelay(): void;
    get disconnectDelayInput(): string | undefined;
    private _idleDelay?;
    get idleDelay(): string;
    set idleDelay(value: string);
    resetIdleDelay(): void;
    get idleDelayInput(): string | undefined;
    private _noConnectDelay?;
    get noConnectDelay(): string;
    set noConnectDelay(value: string);
    resetNoConnectDelay(): void;
    get noConnectDelayInput(): string | undefined;
    private _shutdownOnIdle?;
    get shutdownOnIdle(): string;
    set shutdownOnIdle(value: string);
    resetShutdownOnIdle(): void;
    get shutdownOnIdleInput(): string | undefined;
}
export interface LabServiceLabConnectionSetting {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#client_rdp_access LabServiceLab#client_rdp_access}
    */
    readonly clientRdpAccess?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#client_ssh_access LabServiceLab#client_ssh_access}
    */
    readonly clientSshAccess?: string;
}
export declare function labServiceLabConnectionSettingToTerraform(struct?: LabServiceLabConnectionSettingOutputReference | LabServiceLabConnectionSetting): any;
export declare function labServiceLabConnectionSettingToHclTerraform(struct?: LabServiceLabConnectionSettingOutputReference | LabServiceLabConnectionSetting): any;
export declare class LabServiceLabConnectionSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServiceLabConnectionSetting | undefined;
    set internalValue(value: LabServiceLabConnectionSetting | undefined);
    private _clientRdpAccess?;
    get clientRdpAccess(): string;
    set clientRdpAccess(value: string);
    resetClientRdpAccess(): void;
    get clientRdpAccessInput(): string | undefined;
    private _clientSshAccess?;
    get clientSshAccess(): string;
    set clientSshAccess(value: string);
    resetClientSshAccess(): void;
    get clientSshAccessInput(): string | undefined;
}
export interface LabServiceLabNetwork {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#subnet_id LabServiceLab#subnet_id}
    */
    readonly subnetId?: string;
}
export declare function labServiceLabNetworkToTerraform(struct?: LabServiceLabNetworkOutputReference | LabServiceLabNetwork): any;
export declare function labServiceLabNetworkToHclTerraform(struct?: LabServiceLabNetworkOutputReference | LabServiceLabNetwork): any;
export declare class LabServiceLabNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServiceLabNetwork | undefined;
    set internalValue(value: LabServiceLabNetwork | undefined);
    get loadBalancerId(): string;
    get publicIpId(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
}
export interface LabServiceLabRoster {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#active_directory_group_id LabServiceLab#active_directory_group_id}
    */
    readonly activeDirectoryGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#lms_instance LabServiceLab#lms_instance}
    */
    readonly lmsInstance?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#lti_client_id LabServiceLab#lti_client_id}
    */
    readonly ltiClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#lti_context_id LabServiceLab#lti_context_id}
    */
    readonly ltiContextId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#lti_roster_endpoint LabServiceLab#lti_roster_endpoint}
    */
    readonly ltiRosterEndpoint?: string;
}
export declare function labServiceLabRosterToTerraform(struct?: LabServiceLabRosterOutputReference | LabServiceLabRoster): any;
export declare function labServiceLabRosterToHclTerraform(struct?: LabServiceLabRosterOutputReference | LabServiceLabRoster): any;
export declare class LabServiceLabRosterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServiceLabRoster | undefined;
    set internalValue(value: LabServiceLabRoster | undefined);
    private _activeDirectoryGroupId?;
    get activeDirectoryGroupId(): string;
    set activeDirectoryGroupId(value: string);
    resetActiveDirectoryGroupId(): void;
    get activeDirectoryGroupIdInput(): string | undefined;
    private _lmsInstance?;
    get lmsInstance(): string;
    set lmsInstance(value: string);
    resetLmsInstance(): void;
    get lmsInstanceInput(): string | undefined;
    private _ltiClientId?;
    get ltiClientId(): string;
    set ltiClientId(value: string);
    resetLtiClientId(): void;
    get ltiClientIdInput(): string | undefined;
    private _ltiContextId?;
    get ltiContextId(): string;
    set ltiContextId(value: string);
    resetLtiContextId(): void;
    get ltiContextIdInput(): string | undefined;
    private _ltiRosterEndpoint?;
    get ltiRosterEndpoint(): string;
    set ltiRosterEndpoint(value: string);
    resetLtiRosterEndpoint(): void;
    get ltiRosterEndpointInput(): string | undefined;
}
export interface LabServiceLabSecurity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#open_access_enabled LabServiceLab#open_access_enabled}
    */
    readonly openAccessEnabled: boolean | cdktf.IResolvable;
}
export declare function labServiceLabSecurityToTerraform(struct?: LabServiceLabSecurityOutputReference | LabServiceLabSecurity): any;
export declare function labServiceLabSecurityToHclTerraform(struct?: LabServiceLabSecurityOutputReference | LabServiceLabSecurity): any;
export declare class LabServiceLabSecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServiceLabSecurity | undefined;
    set internalValue(value: LabServiceLabSecurity | undefined);
    private _openAccessEnabled?;
    get openAccessEnabled(): boolean | cdktf.IResolvable;
    set openAccessEnabled(value: boolean | cdktf.IResolvable);
    get openAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get registrationCode(): string;
}
export interface LabServiceLabTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#create LabServiceLab#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#delete LabServiceLab#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#read LabServiceLab#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#update LabServiceLab#update}
    */
    readonly update?: string;
}
export declare function labServiceLabTimeoutsToTerraform(struct?: LabServiceLabTimeouts | cdktf.IResolvable): any;
export declare function labServiceLabTimeoutsToHclTerraform(struct?: LabServiceLabTimeouts | cdktf.IResolvable): any;
export declare class LabServiceLabTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServiceLabTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LabServiceLabTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface LabServiceLabVirtualMachineAdminUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#password LabServiceLab#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#username LabServiceLab#username}
    */
    readonly username: string;
}
export declare function labServiceLabVirtualMachineAdminUserToTerraform(struct?: LabServiceLabVirtualMachineAdminUserOutputReference | LabServiceLabVirtualMachineAdminUser): any;
export declare function labServiceLabVirtualMachineAdminUserToHclTerraform(struct?: LabServiceLabVirtualMachineAdminUserOutputReference | LabServiceLabVirtualMachineAdminUser): any;
export declare class LabServiceLabVirtualMachineAdminUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServiceLabVirtualMachineAdminUser | undefined;
    set internalValue(value: LabServiceLabVirtualMachineAdminUser | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface LabServiceLabVirtualMachineImageReference {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#id LabServiceLab#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#offer LabServiceLab#offer}
    */
    readonly offer?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#publisher LabServiceLab#publisher}
    */
    readonly publisher?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#sku LabServiceLab#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#version LabServiceLab#version}
    */
    readonly version?: string;
}
export declare function labServiceLabVirtualMachineImageReferenceToTerraform(struct?: LabServiceLabVirtualMachineImageReferenceOutputReference | LabServiceLabVirtualMachineImageReference): any;
export declare function labServiceLabVirtualMachineImageReferenceToHclTerraform(struct?: LabServiceLabVirtualMachineImageReferenceOutputReference | LabServiceLabVirtualMachineImageReference): any;
export declare class LabServiceLabVirtualMachineImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServiceLabVirtualMachineImageReference | undefined;
    set internalValue(value: LabServiceLabVirtualMachineImageReference | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _offer?;
    get offer(): string;
    set offer(value: string);
    resetOffer(): void;
    get offerInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    resetPublisher(): void;
    get publisherInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface LabServiceLabVirtualMachineNonAdminUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#password LabServiceLab#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#username LabServiceLab#username}
    */
    readonly username: string;
}
export declare function labServiceLabVirtualMachineNonAdminUserToTerraform(struct?: LabServiceLabVirtualMachineNonAdminUserOutputReference | LabServiceLabVirtualMachineNonAdminUser): any;
export declare function labServiceLabVirtualMachineNonAdminUserToHclTerraform(struct?: LabServiceLabVirtualMachineNonAdminUserOutputReference | LabServiceLabVirtualMachineNonAdminUser): any;
export declare class LabServiceLabVirtualMachineNonAdminUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServiceLabVirtualMachineNonAdminUser | undefined;
    set internalValue(value: LabServiceLabVirtualMachineNonAdminUser | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface LabServiceLabVirtualMachineSku {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#capacity LabServiceLab#capacity}
    */
    readonly capacity: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#name LabServiceLab#name}
    */
    readonly name: string;
}
export declare function labServiceLabVirtualMachineSkuToTerraform(struct?: LabServiceLabVirtualMachineSkuOutputReference | LabServiceLabVirtualMachineSku): any;
export declare function labServiceLabVirtualMachineSkuToHclTerraform(struct?: LabServiceLabVirtualMachineSkuOutputReference | LabServiceLabVirtualMachineSku): any;
export declare class LabServiceLabVirtualMachineSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServiceLabVirtualMachineSku | undefined;
    set internalValue(value: LabServiceLabVirtualMachineSku | undefined);
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    get capacityInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface LabServiceLabVirtualMachine {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#additional_capability_gpu_drivers_installed LabServiceLab#additional_capability_gpu_drivers_installed}
    */
    readonly additionalCapabilityGpuDriversInstalled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#create_option LabServiceLab#create_option}
    */
    readonly createOption?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#shared_password_enabled LabServiceLab#shared_password_enabled}
    */
    readonly sharedPasswordEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#usage_quota LabServiceLab#usage_quota}
    */
    readonly usageQuota?: string;
    /**
    * admin_user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#admin_user LabServiceLab#admin_user}
    */
    readonly adminUser: LabServiceLabVirtualMachineAdminUser;
    /**
    * image_reference block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#image_reference LabServiceLab#image_reference}
    */
    readonly imageReference: LabServiceLabVirtualMachineImageReference;
    /**
    * non_admin_user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#non_admin_user LabServiceLab#non_admin_user}
    */
    readonly nonAdminUser?: LabServiceLabVirtualMachineNonAdminUser;
    /**
    * sku block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#sku LabServiceLab#sku}
    */
    readonly sku: LabServiceLabVirtualMachineSku;
}
export declare function labServiceLabVirtualMachineToTerraform(struct?: LabServiceLabVirtualMachineOutputReference | LabServiceLabVirtualMachine): any;
export declare function labServiceLabVirtualMachineToHclTerraform(struct?: LabServiceLabVirtualMachineOutputReference | LabServiceLabVirtualMachine): any;
export declare class LabServiceLabVirtualMachineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServiceLabVirtualMachine | undefined;
    set internalValue(value: LabServiceLabVirtualMachine | undefined);
    private _additionalCapabilityGpuDriversInstalled?;
    get additionalCapabilityGpuDriversInstalled(): boolean | cdktf.IResolvable;
    set additionalCapabilityGpuDriversInstalled(value: boolean | cdktf.IResolvable);
    resetAdditionalCapabilityGpuDriversInstalled(): void;
    get additionalCapabilityGpuDriversInstalledInput(): boolean | cdktf.IResolvable | undefined;
    private _createOption?;
    get createOption(): string;
    set createOption(value: string);
    resetCreateOption(): void;
    get createOptionInput(): string | undefined;
    private _sharedPasswordEnabled?;
    get sharedPasswordEnabled(): boolean | cdktf.IResolvable;
    set sharedPasswordEnabled(value: boolean | cdktf.IResolvable);
    resetSharedPasswordEnabled(): void;
    get sharedPasswordEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _usageQuota?;
    get usageQuota(): string;
    set usageQuota(value: string);
    resetUsageQuota(): void;
    get usageQuotaInput(): string | undefined;
    private _adminUser;
    get adminUser(): LabServiceLabVirtualMachineAdminUserOutputReference;
    putAdminUser(value: LabServiceLabVirtualMachineAdminUser): void;
    get adminUserInput(): LabServiceLabVirtualMachineAdminUser | undefined;
    private _imageReference;
    get imageReference(): LabServiceLabVirtualMachineImageReferenceOutputReference;
    putImageReference(value: LabServiceLabVirtualMachineImageReference): void;
    get imageReferenceInput(): LabServiceLabVirtualMachineImageReference | undefined;
    private _nonAdminUser;
    get nonAdminUser(): LabServiceLabVirtualMachineNonAdminUserOutputReference;
    putNonAdminUser(value: LabServiceLabVirtualMachineNonAdminUser): void;
    resetNonAdminUser(): void;
    get nonAdminUserInput(): LabServiceLabVirtualMachineNonAdminUser | undefined;
    private _sku;
    get sku(): LabServiceLabVirtualMachineSkuOutputReference;
    putSku(value: LabServiceLabVirtualMachineSku): void;
    get skuInput(): LabServiceLabVirtualMachineSku | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab azurerm_lab_service_lab}
*/
export declare class LabServiceLab extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_lab_service_lab";
    /**
    * Generates CDKTF code for importing a LabServiceLab resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LabServiceLab to import
    * @param importFromId The id of the existing LabServiceLab that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LabServiceLab to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/lab_service_lab azurerm_lab_service_lab} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LabServiceLabConfig
    */
    constructor(scope: Construct, id: string, config: LabServiceLabConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labPlanId?;
    get labPlanId(): string;
    set labPlanId(value: string);
    resetLabPlanId(): void;
    get labPlanIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _autoShutdown;
    get autoShutdown(): LabServiceLabAutoShutdownOutputReference;
    putAutoShutdown(value: LabServiceLabAutoShutdown): void;
    resetAutoShutdown(): void;
    get autoShutdownInput(): LabServiceLabAutoShutdown | undefined;
    private _connectionSetting;
    get connectionSetting(): LabServiceLabConnectionSettingOutputReference;
    putConnectionSetting(value: LabServiceLabConnectionSetting): void;
    resetConnectionSetting(): void;
    get connectionSettingInput(): LabServiceLabConnectionSetting | undefined;
    private _network;
    get network(): LabServiceLabNetworkOutputReference;
    putNetwork(value: LabServiceLabNetwork): void;
    resetNetwork(): void;
    get networkInput(): LabServiceLabNetwork | undefined;
    private _roster;
    get roster(): LabServiceLabRosterOutputReference;
    putRoster(value: LabServiceLabRoster): void;
    resetRoster(): void;
    get rosterInput(): LabServiceLabRoster | undefined;
    private _security;
    get security(): LabServiceLabSecurityOutputReference;
    putSecurity(value: LabServiceLabSecurity): void;
    get securityInput(): LabServiceLabSecurity | undefined;
    private _timeouts;
    get timeouts(): LabServiceLabTimeoutsOutputReference;
    putTimeouts(value: LabServiceLabTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LabServiceLabTimeouts | undefined;
    private _virtualMachine;
    get virtualMachine(): LabServiceLabVirtualMachineOutputReference;
    putVirtualMachine(value: LabServiceLabVirtualMachine): void;
    get virtualMachineInput(): LabServiceLabVirtualMachine | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
