/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogAnalyticsWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#allow_resource_only_permissions LogAnalyticsWorkspace#allow_resource_only_permissions}
    */
    readonly allowResourceOnlyPermissions?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#cmk_for_query_forced LogAnalyticsWorkspace#cmk_for_query_forced}
    */
    readonly cmkForQueryForced?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#daily_quota_gb LogAnalyticsWorkspace#daily_quota_gb}
    */
    readonly dailyQuotaGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#data_collection_rule_id LogAnalyticsWorkspace#data_collection_rule_id}
    */
    readonly dataCollectionRuleId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#id LogAnalyticsWorkspace#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#immediate_data_purge_on_30_days_enabled LogAnalyticsWorkspace#immediate_data_purge_on_30_days_enabled}
    */
    readonly immediateDataPurgeOn30DaysEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#internet_ingestion_enabled LogAnalyticsWorkspace#internet_ingestion_enabled}
    */
    readonly internetIngestionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#internet_query_enabled LogAnalyticsWorkspace#internet_query_enabled}
    */
    readonly internetQueryEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#local_authentication_disabled LogAnalyticsWorkspace#local_authentication_disabled}
    */
    readonly localAuthenticationDisabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#location LogAnalyticsWorkspace#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#name LogAnalyticsWorkspace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#reservation_capacity_in_gb_per_day LogAnalyticsWorkspace#reservation_capacity_in_gb_per_day}
    */
    readonly reservationCapacityInGbPerDay?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#resource_group_name LogAnalyticsWorkspace#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#retention_in_days LogAnalyticsWorkspace#retention_in_days}
    */
    readonly retentionInDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#sku LogAnalyticsWorkspace#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#tags LogAnalyticsWorkspace#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#identity LogAnalyticsWorkspace#identity}
    */
    readonly identity?: LogAnalyticsWorkspaceIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#timeouts LogAnalyticsWorkspace#timeouts}
    */
    readonly timeouts?: LogAnalyticsWorkspaceTimeouts;
}
export interface LogAnalyticsWorkspaceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#identity_ids LogAnalyticsWorkspace#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#type LogAnalyticsWorkspace#type}
    */
    readonly type: string;
}
export declare function logAnalyticsWorkspaceIdentityToTerraform(struct?: LogAnalyticsWorkspaceIdentityOutputReference | LogAnalyticsWorkspaceIdentity): any;
export declare function logAnalyticsWorkspaceIdentityToHclTerraform(struct?: LogAnalyticsWorkspaceIdentityOutputReference | LogAnalyticsWorkspaceIdentity): any;
export declare class LogAnalyticsWorkspaceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogAnalyticsWorkspaceIdentity | undefined;
    set internalValue(value: LogAnalyticsWorkspaceIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface LogAnalyticsWorkspaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#create LogAnalyticsWorkspace#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#delete LogAnalyticsWorkspace#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#read LogAnalyticsWorkspace#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#update LogAnalyticsWorkspace#update}
    */
    readonly update?: string;
}
export declare function logAnalyticsWorkspaceTimeoutsToTerraform(struct?: LogAnalyticsWorkspaceTimeouts | cdktf.IResolvable): any;
export declare function logAnalyticsWorkspaceTimeoutsToHclTerraform(struct?: LogAnalyticsWorkspaceTimeouts | cdktf.IResolvable): any;
export declare class LogAnalyticsWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogAnalyticsWorkspaceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LogAnalyticsWorkspaceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace azurerm_log_analytics_workspace}
*/
export declare class LogAnalyticsWorkspace extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_log_analytics_workspace";
    /**
    * Generates CDKTF code for importing a LogAnalyticsWorkspace resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LogAnalyticsWorkspace to import
    * @param importFromId The id of the existing LogAnalyticsWorkspace that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LogAnalyticsWorkspace to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/log_analytics_workspace azurerm_log_analytics_workspace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogAnalyticsWorkspaceConfig
    */
    constructor(scope: Construct, id: string, config: LogAnalyticsWorkspaceConfig);
    private _allowResourceOnlyPermissions?;
    get allowResourceOnlyPermissions(): boolean | cdktf.IResolvable;
    set allowResourceOnlyPermissions(value: boolean | cdktf.IResolvable);
    resetAllowResourceOnlyPermissions(): void;
    get allowResourceOnlyPermissionsInput(): boolean | cdktf.IResolvable | undefined;
    private _cmkForQueryForced?;
    get cmkForQueryForced(): boolean | cdktf.IResolvable;
    set cmkForQueryForced(value: boolean | cdktf.IResolvable);
    resetCmkForQueryForced(): void;
    get cmkForQueryForcedInput(): boolean | cdktf.IResolvable | undefined;
    private _dailyQuotaGb?;
    get dailyQuotaGb(): number;
    set dailyQuotaGb(value: number);
    resetDailyQuotaGb(): void;
    get dailyQuotaGbInput(): number | undefined;
    private _dataCollectionRuleId?;
    get dataCollectionRuleId(): string;
    set dataCollectionRuleId(value: string);
    resetDataCollectionRuleId(): void;
    get dataCollectionRuleIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _immediateDataPurgeOn30DaysEnabled?;
    get immediateDataPurgeOn30DaysEnabled(): boolean | cdktf.IResolvable;
    set immediateDataPurgeOn30DaysEnabled(value: boolean | cdktf.IResolvable);
    resetImmediateDataPurgeOn30DaysEnabled(): void;
    get immediateDataPurgeOn30DaysEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _internetIngestionEnabled?;
    get internetIngestionEnabled(): boolean | cdktf.IResolvable;
    set internetIngestionEnabled(value: boolean | cdktf.IResolvable);
    resetInternetIngestionEnabled(): void;
    get internetIngestionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _internetQueryEnabled?;
    get internetQueryEnabled(): boolean | cdktf.IResolvable;
    set internetQueryEnabled(value: boolean | cdktf.IResolvable);
    resetInternetQueryEnabled(): void;
    get internetQueryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _localAuthenticationDisabled?;
    get localAuthenticationDisabled(): boolean | cdktf.IResolvable;
    set localAuthenticationDisabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthenticationDisabled(): void;
    get localAuthenticationDisabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primarySharedKey(): string;
    private _reservationCapacityInGbPerDay?;
    get reservationCapacityInGbPerDay(): number;
    set reservationCapacityInGbPerDay(value: number);
    resetReservationCapacityInGbPerDay(): void;
    get reservationCapacityInGbPerDayInput(): number | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    resetRetentionInDays(): void;
    get retentionInDaysInput(): number | undefined;
    get secondarySharedKey(): string;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get workspaceId(): string;
    private _identity;
    get identity(): LogAnalyticsWorkspaceIdentityOutputReference;
    putIdentity(value: LogAnalyticsWorkspaceIdentity): void;
    resetIdentity(): void;
    get identityInput(): LogAnalyticsWorkspaceIdentity | undefined;
    private _timeouts;
    get timeouts(): LogAnalyticsWorkspaceTimeoutsOutputReference;
    putTimeouts(value: LogAnalyticsWorkspaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LogAnalyticsWorkspaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
