/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagedDiskConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#create_option ManagedDisk#create_option}
    */
    readonly createOption: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#disk_access_id ManagedDisk#disk_access_id}
    */
    readonly diskAccessId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#disk_encryption_set_id ManagedDisk#disk_encryption_set_id}
    */
    readonly diskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#disk_iops_read_only ManagedDisk#disk_iops_read_only}
    */
    readonly diskIopsReadOnly?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#disk_iops_read_write ManagedDisk#disk_iops_read_write}
    */
    readonly diskIopsReadWrite?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#disk_mbps_read_only ManagedDisk#disk_mbps_read_only}
    */
    readonly diskMbpsReadOnly?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#disk_mbps_read_write ManagedDisk#disk_mbps_read_write}
    */
    readonly diskMbpsReadWrite?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#disk_size_gb ManagedDisk#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#edge_zone ManagedDisk#edge_zone}
    */
    readonly edgeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#gallery_image_reference_id ManagedDisk#gallery_image_reference_id}
    */
    readonly galleryImageReferenceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#hyper_v_generation ManagedDisk#hyper_v_generation}
    */
    readonly hyperVGeneration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#id ManagedDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#image_reference_id ManagedDisk#image_reference_id}
    */
    readonly imageReferenceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#location ManagedDisk#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#logical_sector_size ManagedDisk#logical_sector_size}
    */
    readonly logicalSectorSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#max_shares ManagedDisk#max_shares}
    */
    readonly maxShares?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#name ManagedDisk#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#network_access_policy ManagedDisk#network_access_policy}
    */
    readonly networkAccessPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#on_demand_bursting_enabled ManagedDisk#on_demand_bursting_enabled}
    */
    readonly onDemandBurstingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#optimized_frequent_attach_enabled ManagedDisk#optimized_frequent_attach_enabled}
    */
    readonly optimizedFrequentAttachEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#os_type ManagedDisk#os_type}
    */
    readonly osType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#performance_plus_enabled ManagedDisk#performance_plus_enabled}
    */
    readonly performancePlusEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#public_network_access_enabled ManagedDisk#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#resource_group_name ManagedDisk#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#secure_vm_disk_encryption_set_id ManagedDisk#secure_vm_disk_encryption_set_id}
    */
    readonly secureVmDiskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#security_type ManagedDisk#security_type}
    */
    readonly securityType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#source_resource_id ManagedDisk#source_resource_id}
    */
    readonly sourceResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#source_uri ManagedDisk#source_uri}
    */
    readonly sourceUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#storage_account_id ManagedDisk#storage_account_id}
    */
    readonly storageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#storage_account_type ManagedDisk#storage_account_type}
    */
    readonly storageAccountType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#tags ManagedDisk#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#tier ManagedDisk#tier}
    */
    readonly tier?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#trusted_launch_enabled ManagedDisk#trusted_launch_enabled}
    */
    readonly trustedLaunchEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#upload_size_bytes ManagedDisk#upload_size_bytes}
    */
    readonly uploadSizeBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#zone ManagedDisk#zone}
    */
    readonly zone?: string;
    /**
    * encryption_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#encryption_settings ManagedDisk#encryption_settings}
    */
    readonly encryptionSettings?: ManagedDiskEncryptionSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#timeouts ManagedDisk#timeouts}
    */
    readonly timeouts?: ManagedDiskTimeouts;
}
export interface ManagedDiskEncryptionSettingsDiskEncryptionKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#secret_url ManagedDisk#secret_url}
    */
    readonly secretUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#source_vault_id ManagedDisk#source_vault_id}
    */
    readonly sourceVaultId: string;
}
export declare function managedDiskEncryptionSettingsDiskEncryptionKeyToTerraform(struct?: ManagedDiskEncryptionSettingsDiskEncryptionKeyOutputReference | ManagedDiskEncryptionSettingsDiskEncryptionKey): any;
export declare function managedDiskEncryptionSettingsDiskEncryptionKeyToHclTerraform(struct?: ManagedDiskEncryptionSettingsDiskEncryptionKeyOutputReference | ManagedDiskEncryptionSettingsDiskEncryptionKey): any;
export declare class ManagedDiskEncryptionSettingsDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedDiskEncryptionSettingsDiskEncryptionKey | undefined;
    set internalValue(value: ManagedDiskEncryptionSettingsDiskEncryptionKey | undefined);
    private _secretUrl?;
    get secretUrl(): string;
    set secretUrl(value: string);
    get secretUrlInput(): string | undefined;
    private _sourceVaultId?;
    get sourceVaultId(): string;
    set sourceVaultId(value: string);
    get sourceVaultIdInput(): string | undefined;
}
export interface ManagedDiskEncryptionSettingsKeyEncryptionKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#key_url ManagedDisk#key_url}
    */
    readonly keyUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#source_vault_id ManagedDisk#source_vault_id}
    */
    readonly sourceVaultId: string;
}
export declare function managedDiskEncryptionSettingsKeyEncryptionKeyToTerraform(struct?: ManagedDiskEncryptionSettingsKeyEncryptionKeyOutputReference | ManagedDiskEncryptionSettingsKeyEncryptionKey): any;
export declare function managedDiskEncryptionSettingsKeyEncryptionKeyToHclTerraform(struct?: ManagedDiskEncryptionSettingsKeyEncryptionKeyOutputReference | ManagedDiskEncryptionSettingsKeyEncryptionKey): any;
export declare class ManagedDiskEncryptionSettingsKeyEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedDiskEncryptionSettingsKeyEncryptionKey | undefined;
    set internalValue(value: ManagedDiskEncryptionSettingsKeyEncryptionKey | undefined);
    private _keyUrl?;
    get keyUrl(): string;
    set keyUrl(value: string);
    get keyUrlInput(): string | undefined;
    private _sourceVaultId?;
    get sourceVaultId(): string;
    set sourceVaultId(value: string);
    get sourceVaultIdInput(): string | undefined;
}
export interface ManagedDiskEncryptionSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#enabled ManagedDisk#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * disk_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#disk_encryption_key ManagedDisk#disk_encryption_key}
    */
    readonly diskEncryptionKey?: ManagedDiskEncryptionSettingsDiskEncryptionKey;
    /**
    * key_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#key_encryption_key ManagedDisk#key_encryption_key}
    */
    readonly keyEncryptionKey?: ManagedDiskEncryptionSettingsKeyEncryptionKey;
}
export declare function managedDiskEncryptionSettingsToTerraform(struct?: ManagedDiskEncryptionSettingsOutputReference | ManagedDiskEncryptionSettings): any;
export declare function managedDiskEncryptionSettingsToHclTerraform(struct?: ManagedDiskEncryptionSettingsOutputReference | ManagedDiskEncryptionSettings): any;
export declare class ManagedDiskEncryptionSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedDiskEncryptionSettings | undefined;
    set internalValue(value: ManagedDiskEncryptionSettings | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diskEncryptionKey;
    get diskEncryptionKey(): ManagedDiskEncryptionSettingsDiskEncryptionKeyOutputReference;
    putDiskEncryptionKey(value: ManagedDiskEncryptionSettingsDiskEncryptionKey): void;
    resetDiskEncryptionKey(): void;
    get diskEncryptionKeyInput(): ManagedDiskEncryptionSettingsDiskEncryptionKey | undefined;
    private _keyEncryptionKey;
    get keyEncryptionKey(): ManagedDiskEncryptionSettingsKeyEncryptionKeyOutputReference;
    putKeyEncryptionKey(value: ManagedDiskEncryptionSettingsKeyEncryptionKey): void;
    resetKeyEncryptionKey(): void;
    get keyEncryptionKeyInput(): ManagedDiskEncryptionSettingsKeyEncryptionKey | undefined;
}
export interface ManagedDiskTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#create ManagedDisk#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#delete ManagedDisk#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#read ManagedDisk#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#update ManagedDisk#update}
    */
    readonly update?: string;
}
export declare function managedDiskTimeoutsToTerraform(struct?: ManagedDiskTimeouts | cdktf.IResolvable): any;
export declare function managedDiskTimeoutsToHclTerraform(struct?: ManagedDiskTimeouts | cdktf.IResolvable): any;
export declare class ManagedDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedDiskTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedDiskTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk azurerm_managed_disk}
*/
export declare class ManagedDisk extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_managed_disk";
    /**
    * Generates CDKTF code for importing a ManagedDisk resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ManagedDisk to import
    * @param importFromId The id of the existing ManagedDisk that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ManagedDisk to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/managed_disk azurerm_managed_disk} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedDiskConfig
    */
    constructor(scope: Construct, id: string, config: ManagedDiskConfig);
    private _createOption?;
    get createOption(): string;
    set createOption(value: string);
    get createOptionInput(): string | undefined;
    private _diskAccessId?;
    get diskAccessId(): string;
    set diskAccessId(value: string);
    resetDiskAccessId(): void;
    get diskAccessIdInput(): string | undefined;
    private _diskEncryptionSetId?;
    get diskEncryptionSetId(): string;
    set diskEncryptionSetId(value: string);
    resetDiskEncryptionSetId(): void;
    get diskEncryptionSetIdInput(): string | undefined;
    private _diskIopsReadOnly?;
    get diskIopsReadOnly(): number;
    set diskIopsReadOnly(value: number);
    resetDiskIopsReadOnly(): void;
    get diskIopsReadOnlyInput(): number | undefined;
    private _diskIopsReadWrite?;
    get diskIopsReadWrite(): number;
    set diskIopsReadWrite(value: number);
    resetDiskIopsReadWrite(): void;
    get diskIopsReadWriteInput(): number | undefined;
    private _diskMbpsReadOnly?;
    get diskMbpsReadOnly(): number;
    set diskMbpsReadOnly(value: number);
    resetDiskMbpsReadOnly(): void;
    get diskMbpsReadOnlyInput(): number | undefined;
    private _diskMbpsReadWrite?;
    get diskMbpsReadWrite(): number;
    set diskMbpsReadWrite(value: number);
    resetDiskMbpsReadWrite(): void;
    get diskMbpsReadWriteInput(): number | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _edgeZone?;
    get edgeZone(): string;
    set edgeZone(value: string);
    resetEdgeZone(): void;
    get edgeZoneInput(): string | undefined;
    private _galleryImageReferenceId?;
    get galleryImageReferenceId(): string;
    set galleryImageReferenceId(value: string);
    resetGalleryImageReferenceId(): void;
    get galleryImageReferenceIdInput(): string | undefined;
    private _hyperVGeneration?;
    get hyperVGeneration(): string;
    set hyperVGeneration(value: string);
    resetHyperVGeneration(): void;
    get hyperVGenerationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imageReferenceId?;
    get imageReferenceId(): string;
    set imageReferenceId(value: string);
    resetImageReferenceId(): void;
    get imageReferenceIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _logicalSectorSize?;
    get logicalSectorSize(): number;
    set logicalSectorSize(value: number);
    resetLogicalSectorSize(): void;
    get logicalSectorSizeInput(): number | undefined;
    private _maxShares?;
    get maxShares(): number;
    set maxShares(value: number);
    resetMaxShares(): void;
    get maxSharesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkAccessPolicy?;
    get networkAccessPolicy(): string;
    set networkAccessPolicy(value: string);
    resetNetworkAccessPolicy(): void;
    get networkAccessPolicyInput(): string | undefined;
    private _onDemandBurstingEnabled?;
    get onDemandBurstingEnabled(): boolean | cdktf.IResolvable;
    set onDemandBurstingEnabled(value: boolean | cdktf.IResolvable);
    resetOnDemandBurstingEnabled(): void;
    get onDemandBurstingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _optimizedFrequentAttachEnabled?;
    get optimizedFrequentAttachEnabled(): boolean | cdktf.IResolvable;
    set optimizedFrequentAttachEnabled(value: boolean | cdktf.IResolvable);
    resetOptimizedFrequentAttachEnabled(): void;
    get optimizedFrequentAttachEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _osType?;
    get osType(): string;
    set osType(value: string);
    resetOsType(): void;
    get osTypeInput(): string | undefined;
    private _performancePlusEnabled?;
    get performancePlusEnabled(): boolean | cdktf.IResolvable;
    set performancePlusEnabled(value: boolean | cdktf.IResolvable);
    resetPerformancePlusEnabled(): void;
    get performancePlusEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _secureVmDiskEncryptionSetId?;
    get secureVmDiskEncryptionSetId(): string;
    set secureVmDiskEncryptionSetId(value: string);
    resetSecureVmDiskEncryptionSetId(): void;
    get secureVmDiskEncryptionSetIdInput(): string | undefined;
    private _securityType?;
    get securityType(): string;
    set securityType(value: string);
    resetSecurityType(): void;
    get securityTypeInput(): string | undefined;
    private _sourceResourceId?;
    get sourceResourceId(): string;
    set sourceResourceId(value: string);
    resetSourceResourceId(): void;
    get sourceResourceIdInput(): string | undefined;
    private _sourceUri?;
    get sourceUri(): string;
    set sourceUri(value: string);
    resetSourceUri(): void;
    get sourceUriInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    resetStorageAccountId(): void;
    get storageAccountIdInput(): string | undefined;
    private _storageAccountType?;
    get storageAccountType(): string;
    set storageAccountType(value: string);
    get storageAccountTypeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    resetTier(): void;
    get tierInput(): string | undefined;
    private _trustedLaunchEnabled?;
    get trustedLaunchEnabled(): boolean | cdktf.IResolvable;
    set trustedLaunchEnabled(value: boolean | cdktf.IResolvable);
    resetTrustedLaunchEnabled(): void;
    get trustedLaunchEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _uploadSizeBytes?;
    get uploadSizeBytes(): number;
    set uploadSizeBytes(value: number);
    resetUploadSizeBytes(): void;
    get uploadSizeBytesInput(): number | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _encryptionSettings;
    get encryptionSettings(): ManagedDiskEncryptionSettingsOutputReference;
    putEncryptionSettings(value: ManagedDiskEncryptionSettings): void;
    resetEncryptionSettings(): void;
    get encryptionSettingsInput(): ManagedDiskEncryptionSettings | undefined;
    private _timeouts;
    get timeouts(): ManagedDiskTimeoutsOutputReference;
    putTimeouts(value: ManagedDiskTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ManagedDiskTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
