/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MediaServicesAccountFilterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#first_quality_bitrate MediaServicesAccountFilter#first_quality_bitrate}
    */
    readonly firstQualityBitrate?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#id MediaServicesAccountFilter#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#media_services_account_name MediaServicesAccountFilter#media_services_account_name}
    */
    readonly mediaServicesAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#name MediaServicesAccountFilter#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#resource_group_name MediaServicesAccountFilter#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * presentation_time_range block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#presentation_time_range MediaServicesAccountFilter#presentation_time_range}
    */
    readonly presentationTimeRange?: MediaServicesAccountFilterPresentationTimeRange;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#timeouts MediaServicesAccountFilter#timeouts}
    */
    readonly timeouts?: MediaServicesAccountFilterTimeouts;
    /**
    * track_selection block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#track_selection MediaServicesAccountFilter#track_selection}
    */
    readonly trackSelection?: MediaServicesAccountFilterTrackSelection[] | cdktf.IResolvable;
}
export interface MediaServicesAccountFilterPresentationTimeRange {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#end_in_units MediaServicesAccountFilter#end_in_units}
    */
    readonly endInUnits?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#force_end MediaServicesAccountFilter#force_end}
    */
    readonly forceEnd?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#live_backoff_in_units MediaServicesAccountFilter#live_backoff_in_units}
    */
    readonly liveBackoffInUnits?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#presentation_window_in_units MediaServicesAccountFilter#presentation_window_in_units}
    */
    readonly presentationWindowInUnits?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#start_in_units MediaServicesAccountFilter#start_in_units}
    */
    readonly startInUnits?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#unit_timescale_in_milliseconds MediaServicesAccountFilter#unit_timescale_in_milliseconds}
    */
    readonly unitTimescaleInMilliseconds: number;
}
export declare function mediaServicesAccountFilterPresentationTimeRangeToTerraform(struct?: MediaServicesAccountFilterPresentationTimeRangeOutputReference | MediaServicesAccountFilterPresentationTimeRange): any;
export declare function mediaServicesAccountFilterPresentationTimeRangeToHclTerraform(struct?: MediaServicesAccountFilterPresentationTimeRangeOutputReference | MediaServicesAccountFilterPresentationTimeRange): any;
export declare class MediaServicesAccountFilterPresentationTimeRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaServicesAccountFilterPresentationTimeRange | undefined;
    set internalValue(value: MediaServicesAccountFilterPresentationTimeRange | undefined);
    private _endInUnits?;
    get endInUnits(): number;
    set endInUnits(value: number);
    resetEndInUnits(): void;
    get endInUnitsInput(): number | undefined;
    private _forceEnd?;
    get forceEnd(): boolean | cdktf.IResolvable;
    set forceEnd(value: boolean | cdktf.IResolvable);
    resetForceEnd(): void;
    get forceEndInput(): boolean | cdktf.IResolvable | undefined;
    private _liveBackoffInUnits?;
    get liveBackoffInUnits(): number;
    set liveBackoffInUnits(value: number);
    resetLiveBackoffInUnits(): void;
    get liveBackoffInUnitsInput(): number | undefined;
    private _presentationWindowInUnits?;
    get presentationWindowInUnits(): number;
    set presentationWindowInUnits(value: number);
    resetPresentationWindowInUnits(): void;
    get presentationWindowInUnitsInput(): number | undefined;
    private _startInUnits?;
    get startInUnits(): number;
    set startInUnits(value: number);
    resetStartInUnits(): void;
    get startInUnitsInput(): number | undefined;
    private _unitTimescaleInMilliseconds?;
    get unitTimescaleInMilliseconds(): number;
    set unitTimescaleInMilliseconds(value: number);
    get unitTimescaleInMillisecondsInput(): number | undefined;
}
export interface MediaServicesAccountFilterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#create MediaServicesAccountFilter#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#delete MediaServicesAccountFilter#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#read MediaServicesAccountFilter#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#update MediaServicesAccountFilter#update}
    */
    readonly update?: string;
}
export declare function mediaServicesAccountFilterTimeoutsToTerraform(struct?: MediaServicesAccountFilterTimeouts | cdktf.IResolvable): any;
export declare function mediaServicesAccountFilterTimeoutsToHclTerraform(struct?: MediaServicesAccountFilterTimeouts | cdktf.IResolvable): any;
export declare class MediaServicesAccountFilterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaServicesAccountFilterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MediaServicesAccountFilterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface MediaServicesAccountFilterTrackSelectionCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#operation MediaServicesAccountFilter#operation}
    */
    readonly operation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#property MediaServicesAccountFilter#property}
    */
    readonly property: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#value MediaServicesAccountFilter#value}
    */
    readonly value: string;
}
export declare function mediaServicesAccountFilterTrackSelectionConditionToTerraform(struct?: MediaServicesAccountFilterTrackSelectionCondition | cdktf.IResolvable): any;
export declare function mediaServicesAccountFilterTrackSelectionConditionToHclTerraform(struct?: MediaServicesAccountFilterTrackSelectionCondition | cdktf.IResolvable): any;
export declare class MediaServicesAccountFilterTrackSelectionConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaServicesAccountFilterTrackSelectionCondition | cdktf.IResolvable | undefined;
    set internalValue(value: MediaServicesAccountFilterTrackSelectionCondition | cdktf.IResolvable | undefined);
    private _operation?;
    get operation(): string;
    set operation(value: string);
    get operationInput(): string | undefined;
    private _property?;
    get property(): string;
    set property(value: string);
    get propertyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class MediaServicesAccountFilterTrackSelectionConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaServicesAccountFilterTrackSelectionCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaServicesAccountFilterTrackSelectionConditionOutputReference;
}
export interface MediaServicesAccountFilterTrackSelection {
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#condition MediaServicesAccountFilter#condition}
    */
    readonly condition: MediaServicesAccountFilterTrackSelectionCondition[] | cdktf.IResolvable;
}
export declare function mediaServicesAccountFilterTrackSelectionToTerraform(struct?: MediaServicesAccountFilterTrackSelection | cdktf.IResolvable): any;
export declare function mediaServicesAccountFilterTrackSelectionToHclTerraform(struct?: MediaServicesAccountFilterTrackSelection | cdktf.IResolvable): any;
export declare class MediaServicesAccountFilterTrackSelectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaServicesAccountFilterTrackSelection | cdktf.IResolvable | undefined;
    set internalValue(value: MediaServicesAccountFilterTrackSelection | cdktf.IResolvable | undefined);
    private _condition;
    get condition(): MediaServicesAccountFilterTrackSelectionConditionList;
    putCondition(value: MediaServicesAccountFilterTrackSelectionCondition[] | cdktf.IResolvable): void;
    get conditionInput(): cdktf.IResolvable | MediaServicesAccountFilterTrackSelectionCondition[] | undefined;
}
export declare class MediaServicesAccountFilterTrackSelectionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaServicesAccountFilterTrackSelection[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaServicesAccountFilterTrackSelectionOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter azurerm_media_services_account_filter}
*/
export declare class MediaServicesAccountFilter extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_media_services_account_filter";
    /**
    * Generates CDKTF code for importing a MediaServicesAccountFilter resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MediaServicesAccountFilter to import
    * @param importFromId The id of the existing MediaServicesAccountFilter that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MediaServicesAccountFilter to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/media_services_account_filter azurerm_media_services_account_filter} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MediaServicesAccountFilterConfig
    */
    constructor(scope: Construct, id: string, config: MediaServicesAccountFilterConfig);
    private _firstQualityBitrate?;
    get firstQualityBitrate(): number;
    set firstQualityBitrate(value: number);
    resetFirstQualityBitrate(): void;
    get firstQualityBitrateInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mediaServicesAccountName?;
    get mediaServicesAccountName(): string;
    set mediaServicesAccountName(value: string);
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _presentationTimeRange;
    get presentationTimeRange(): MediaServicesAccountFilterPresentationTimeRangeOutputReference;
    putPresentationTimeRange(value: MediaServicesAccountFilterPresentationTimeRange): void;
    resetPresentationTimeRange(): void;
    get presentationTimeRangeInput(): MediaServicesAccountFilterPresentationTimeRange | undefined;
    private _timeouts;
    get timeouts(): MediaServicesAccountFilterTimeoutsOutputReference;
    putTimeouts(value: MediaServicesAccountFilterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MediaServicesAccountFilterTimeouts | undefined;
    private _trackSelection;
    get trackSelection(): MediaServicesAccountFilterTrackSelectionList;
    putTrackSelection(value: MediaServicesAccountFilterTrackSelection[] | cdktf.IResolvable): void;
    resetTrackSelection(): void;
    get trackSelectionInput(): cdktf.IResolvable | MediaServicesAccountFilterTrackSelection[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
