/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorAlertProcessingRuleActionGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#add_action_group_ids MonitorAlertProcessingRuleActionGroup#add_action_group_ids}
    */
    readonly addActionGroupIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#description MonitorAlertProcessingRuleActionGroup#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#enabled MonitorAlertProcessingRuleActionGroup#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#id MonitorAlertProcessingRuleActionGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#name MonitorAlertProcessingRuleActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#resource_group_name MonitorAlertProcessingRuleActionGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#scopes MonitorAlertProcessingRuleActionGroup#scopes}
    */
    readonly scopes: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#tags MonitorAlertProcessingRuleActionGroup#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#condition MonitorAlertProcessingRuleActionGroup#condition}
    */
    readonly condition?: MonitorAlertProcessingRuleActionGroupCondition;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#schedule MonitorAlertProcessingRuleActionGroup#schedule}
    */
    readonly schedule?: MonitorAlertProcessingRuleActionGroupSchedule;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#timeouts MonitorAlertProcessingRuleActionGroup#timeouts}
    */
    readonly timeouts?: MonitorAlertProcessingRuleActionGroupTimeouts;
}
export interface MonitorAlertProcessingRuleActionGroupConditionAlertContext {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#operator MonitorAlertProcessingRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#values MonitorAlertProcessingRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleActionGroupConditionAlertContextToTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionAlertContextOutputReference | MonitorAlertProcessingRuleActionGroupConditionAlertContext): any;
export declare function monitorAlertProcessingRuleActionGroupConditionAlertContextToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionAlertContextOutputReference | MonitorAlertProcessingRuleActionGroupConditionAlertContext): any;
export declare class MonitorAlertProcessingRuleActionGroupConditionAlertContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleActionGroupConditionAlertContext | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupConditionAlertContext | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleActionGroupConditionAlertRuleId {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#operator MonitorAlertProcessingRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#values MonitorAlertProcessingRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleActionGroupConditionAlertRuleIdToTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionAlertRuleIdOutputReference | MonitorAlertProcessingRuleActionGroupConditionAlertRuleId): any;
export declare function monitorAlertProcessingRuleActionGroupConditionAlertRuleIdToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionAlertRuleIdOutputReference | MonitorAlertProcessingRuleActionGroupConditionAlertRuleId): any;
export declare class MonitorAlertProcessingRuleActionGroupConditionAlertRuleIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleActionGroupConditionAlertRuleId | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupConditionAlertRuleId | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleActionGroupConditionAlertRuleName {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#operator MonitorAlertProcessingRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#values MonitorAlertProcessingRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleActionGroupConditionAlertRuleNameToTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionAlertRuleNameOutputReference | MonitorAlertProcessingRuleActionGroupConditionAlertRuleName): any;
export declare function monitorAlertProcessingRuleActionGroupConditionAlertRuleNameToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionAlertRuleNameOutputReference | MonitorAlertProcessingRuleActionGroupConditionAlertRuleName): any;
export declare class MonitorAlertProcessingRuleActionGroupConditionAlertRuleNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleActionGroupConditionAlertRuleName | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupConditionAlertRuleName | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleActionGroupConditionDescription {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#operator MonitorAlertProcessingRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#values MonitorAlertProcessingRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleActionGroupConditionDescriptionToTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionDescriptionOutputReference | MonitorAlertProcessingRuleActionGroupConditionDescription): any;
export declare function monitorAlertProcessingRuleActionGroupConditionDescriptionToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionDescriptionOutputReference | MonitorAlertProcessingRuleActionGroupConditionDescription): any;
export declare class MonitorAlertProcessingRuleActionGroupConditionDescriptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleActionGroupConditionDescription | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupConditionDescription | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleActionGroupConditionMonitorCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#operator MonitorAlertProcessingRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#values MonitorAlertProcessingRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleActionGroupConditionMonitorConditionToTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionMonitorConditionOutputReference | MonitorAlertProcessingRuleActionGroupConditionMonitorCondition): any;
export declare function monitorAlertProcessingRuleActionGroupConditionMonitorConditionToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionMonitorConditionOutputReference | MonitorAlertProcessingRuleActionGroupConditionMonitorCondition): any;
export declare class MonitorAlertProcessingRuleActionGroupConditionMonitorConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleActionGroupConditionMonitorCondition | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupConditionMonitorCondition | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleActionGroupConditionMonitorService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#operator MonitorAlertProcessingRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#values MonitorAlertProcessingRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleActionGroupConditionMonitorServiceToTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionMonitorServiceOutputReference | MonitorAlertProcessingRuleActionGroupConditionMonitorService): any;
export declare function monitorAlertProcessingRuleActionGroupConditionMonitorServiceToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionMonitorServiceOutputReference | MonitorAlertProcessingRuleActionGroupConditionMonitorService): any;
export declare class MonitorAlertProcessingRuleActionGroupConditionMonitorServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleActionGroupConditionMonitorService | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupConditionMonitorService | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleActionGroupConditionSeverity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#operator MonitorAlertProcessingRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#values MonitorAlertProcessingRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleActionGroupConditionSeverityToTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionSeverityOutputReference | MonitorAlertProcessingRuleActionGroupConditionSeverity): any;
export declare function monitorAlertProcessingRuleActionGroupConditionSeverityToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionSeverityOutputReference | MonitorAlertProcessingRuleActionGroupConditionSeverity): any;
export declare class MonitorAlertProcessingRuleActionGroupConditionSeverityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleActionGroupConditionSeverity | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupConditionSeverity | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleActionGroupConditionSignalType {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#operator MonitorAlertProcessingRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#values MonitorAlertProcessingRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleActionGroupConditionSignalTypeToTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionSignalTypeOutputReference | MonitorAlertProcessingRuleActionGroupConditionSignalType): any;
export declare function monitorAlertProcessingRuleActionGroupConditionSignalTypeToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionSignalTypeOutputReference | MonitorAlertProcessingRuleActionGroupConditionSignalType): any;
export declare class MonitorAlertProcessingRuleActionGroupConditionSignalTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleActionGroupConditionSignalType | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupConditionSignalType | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleActionGroupConditionTargetResource {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#operator MonitorAlertProcessingRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#values MonitorAlertProcessingRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleActionGroupConditionTargetResourceToTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionTargetResourceOutputReference | MonitorAlertProcessingRuleActionGroupConditionTargetResource): any;
export declare function monitorAlertProcessingRuleActionGroupConditionTargetResourceToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionTargetResourceOutputReference | MonitorAlertProcessingRuleActionGroupConditionTargetResource): any;
export declare class MonitorAlertProcessingRuleActionGroupConditionTargetResourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleActionGroupConditionTargetResource | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupConditionTargetResource | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleActionGroupConditionTargetResourceGroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#operator MonitorAlertProcessingRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#values MonitorAlertProcessingRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleActionGroupConditionTargetResourceGroupToTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionTargetResourceGroupOutputReference | MonitorAlertProcessingRuleActionGroupConditionTargetResourceGroup): any;
export declare function monitorAlertProcessingRuleActionGroupConditionTargetResourceGroupToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionTargetResourceGroupOutputReference | MonitorAlertProcessingRuleActionGroupConditionTargetResourceGroup): any;
export declare class MonitorAlertProcessingRuleActionGroupConditionTargetResourceGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleActionGroupConditionTargetResourceGroup | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupConditionTargetResourceGroup | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleActionGroupConditionTargetResourceType {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#operator MonitorAlertProcessingRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#values MonitorAlertProcessingRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleActionGroupConditionTargetResourceTypeToTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionTargetResourceTypeOutputReference | MonitorAlertProcessingRuleActionGroupConditionTargetResourceType): any;
export declare function monitorAlertProcessingRuleActionGroupConditionTargetResourceTypeToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionTargetResourceTypeOutputReference | MonitorAlertProcessingRuleActionGroupConditionTargetResourceType): any;
export declare class MonitorAlertProcessingRuleActionGroupConditionTargetResourceTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleActionGroupConditionTargetResourceType | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupConditionTargetResourceType | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleActionGroupCondition {
    /**
    * alert_context block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#alert_context MonitorAlertProcessingRuleActionGroup#alert_context}
    */
    readonly alertContext?: MonitorAlertProcessingRuleActionGroupConditionAlertContext;
    /**
    * alert_rule_id block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#alert_rule_id MonitorAlertProcessingRuleActionGroup#alert_rule_id}
    */
    readonly alertRuleId?: MonitorAlertProcessingRuleActionGroupConditionAlertRuleId;
    /**
    * alert_rule_name block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#alert_rule_name MonitorAlertProcessingRuleActionGroup#alert_rule_name}
    */
    readonly alertRuleName?: MonitorAlertProcessingRuleActionGroupConditionAlertRuleName;
    /**
    * description block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#description MonitorAlertProcessingRuleActionGroup#description}
    */
    readonly description?: MonitorAlertProcessingRuleActionGroupConditionDescription;
    /**
    * monitor_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#monitor_condition MonitorAlertProcessingRuleActionGroup#monitor_condition}
    */
    readonly monitorCondition?: MonitorAlertProcessingRuleActionGroupConditionMonitorCondition;
    /**
    * monitor_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#monitor_service MonitorAlertProcessingRuleActionGroup#monitor_service}
    */
    readonly monitorService?: MonitorAlertProcessingRuleActionGroupConditionMonitorService;
    /**
    * severity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#severity MonitorAlertProcessingRuleActionGroup#severity}
    */
    readonly severity?: MonitorAlertProcessingRuleActionGroupConditionSeverity;
    /**
    * signal_type block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#signal_type MonitorAlertProcessingRuleActionGroup#signal_type}
    */
    readonly signalType?: MonitorAlertProcessingRuleActionGroupConditionSignalType;
    /**
    * target_resource block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#target_resource MonitorAlertProcessingRuleActionGroup#target_resource}
    */
    readonly targetResource?: MonitorAlertProcessingRuleActionGroupConditionTargetResource;
    /**
    * target_resource_group block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#target_resource_group MonitorAlertProcessingRuleActionGroup#target_resource_group}
    */
    readonly targetResourceGroup?: MonitorAlertProcessingRuleActionGroupConditionTargetResourceGroup;
    /**
    * target_resource_type block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#target_resource_type MonitorAlertProcessingRuleActionGroup#target_resource_type}
    */
    readonly targetResourceType?: MonitorAlertProcessingRuleActionGroupConditionTargetResourceType;
}
export declare function monitorAlertProcessingRuleActionGroupConditionToTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionOutputReference | MonitorAlertProcessingRuleActionGroupCondition): any;
export declare function monitorAlertProcessingRuleActionGroupConditionToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupConditionOutputReference | MonitorAlertProcessingRuleActionGroupCondition): any;
export declare class MonitorAlertProcessingRuleActionGroupConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleActionGroupCondition | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupCondition | undefined);
    private _alertContext;
    get alertContext(): MonitorAlertProcessingRuleActionGroupConditionAlertContextOutputReference;
    putAlertContext(value: MonitorAlertProcessingRuleActionGroupConditionAlertContext): void;
    resetAlertContext(): void;
    get alertContextInput(): MonitorAlertProcessingRuleActionGroupConditionAlertContext | undefined;
    private _alertRuleId;
    get alertRuleId(): MonitorAlertProcessingRuleActionGroupConditionAlertRuleIdOutputReference;
    putAlertRuleId(value: MonitorAlertProcessingRuleActionGroupConditionAlertRuleId): void;
    resetAlertRuleId(): void;
    get alertRuleIdInput(): MonitorAlertProcessingRuleActionGroupConditionAlertRuleId | undefined;
    private _alertRuleName;
    get alertRuleName(): MonitorAlertProcessingRuleActionGroupConditionAlertRuleNameOutputReference;
    putAlertRuleName(value: MonitorAlertProcessingRuleActionGroupConditionAlertRuleName): void;
    resetAlertRuleName(): void;
    get alertRuleNameInput(): MonitorAlertProcessingRuleActionGroupConditionAlertRuleName | undefined;
    private _description;
    get description(): MonitorAlertProcessingRuleActionGroupConditionDescriptionOutputReference;
    putDescription(value: MonitorAlertProcessingRuleActionGroupConditionDescription): void;
    resetDescription(): void;
    get descriptionInput(): MonitorAlertProcessingRuleActionGroupConditionDescription | undefined;
    private _monitorCondition;
    get monitorCondition(): MonitorAlertProcessingRuleActionGroupConditionMonitorConditionOutputReference;
    putMonitorCondition(value: MonitorAlertProcessingRuleActionGroupConditionMonitorCondition): void;
    resetMonitorCondition(): void;
    get monitorConditionInput(): MonitorAlertProcessingRuleActionGroupConditionMonitorCondition | undefined;
    private _monitorService;
    get monitorService(): MonitorAlertProcessingRuleActionGroupConditionMonitorServiceOutputReference;
    putMonitorService(value: MonitorAlertProcessingRuleActionGroupConditionMonitorService): void;
    resetMonitorService(): void;
    get monitorServiceInput(): MonitorAlertProcessingRuleActionGroupConditionMonitorService | undefined;
    private _severity;
    get severity(): MonitorAlertProcessingRuleActionGroupConditionSeverityOutputReference;
    putSeverity(value: MonitorAlertProcessingRuleActionGroupConditionSeverity): void;
    resetSeverity(): void;
    get severityInput(): MonitorAlertProcessingRuleActionGroupConditionSeverity | undefined;
    private _signalType;
    get signalType(): MonitorAlertProcessingRuleActionGroupConditionSignalTypeOutputReference;
    putSignalType(value: MonitorAlertProcessingRuleActionGroupConditionSignalType): void;
    resetSignalType(): void;
    get signalTypeInput(): MonitorAlertProcessingRuleActionGroupConditionSignalType | undefined;
    private _targetResource;
    get targetResource(): MonitorAlertProcessingRuleActionGroupConditionTargetResourceOutputReference;
    putTargetResource(value: MonitorAlertProcessingRuleActionGroupConditionTargetResource): void;
    resetTargetResource(): void;
    get targetResourceInput(): MonitorAlertProcessingRuleActionGroupConditionTargetResource | undefined;
    private _targetResourceGroup;
    get targetResourceGroup(): MonitorAlertProcessingRuleActionGroupConditionTargetResourceGroupOutputReference;
    putTargetResourceGroup(value: MonitorAlertProcessingRuleActionGroupConditionTargetResourceGroup): void;
    resetTargetResourceGroup(): void;
    get targetResourceGroupInput(): MonitorAlertProcessingRuleActionGroupConditionTargetResourceGroup | undefined;
    private _targetResourceType;
    get targetResourceType(): MonitorAlertProcessingRuleActionGroupConditionTargetResourceTypeOutputReference;
    putTargetResourceType(value: MonitorAlertProcessingRuleActionGroupConditionTargetResourceType): void;
    resetTargetResourceType(): void;
    get targetResourceTypeInput(): MonitorAlertProcessingRuleActionGroupConditionTargetResourceType | undefined;
}
export interface MonitorAlertProcessingRuleActionGroupScheduleRecurrenceDaily {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#end_time MonitorAlertProcessingRuleActionGroup#end_time}
    */
    readonly endTime: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#start_time MonitorAlertProcessingRuleActionGroup#start_time}
    */
    readonly startTime: string;
}
export declare function monitorAlertProcessingRuleActionGroupScheduleRecurrenceDailyToTerraform(struct?: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceDaily | cdktf.IResolvable): any;
export declare function monitorAlertProcessingRuleActionGroupScheduleRecurrenceDailyToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceDaily | cdktf.IResolvable): any;
export declare class MonitorAlertProcessingRuleActionGroupScheduleRecurrenceDailyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorAlertProcessingRuleActionGroupScheduleRecurrenceDaily | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceDaily | cdktf.IResolvable | undefined);
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    get endTimeInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export declare class MonitorAlertProcessingRuleActionGroupScheduleRecurrenceDailyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceDaily[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorAlertProcessingRuleActionGroupScheduleRecurrenceDailyOutputReference;
}
export interface MonitorAlertProcessingRuleActionGroupScheduleRecurrenceMonthly {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#days_of_month MonitorAlertProcessingRuleActionGroup#days_of_month}
    */
    readonly daysOfMonth: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#end_time MonitorAlertProcessingRuleActionGroup#end_time}
    */
    readonly endTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#start_time MonitorAlertProcessingRuleActionGroup#start_time}
    */
    readonly startTime?: string;
}
export declare function monitorAlertProcessingRuleActionGroupScheduleRecurrenceMonthlyToTerraform(struct?: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceMonthly | cdktf.IResolvable): any;
export declare function monitorAlertProcessingRuleActionGroupScheduleRecurrenceMonthlyToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceMonthly | cdktf.IResolvable): any;
export declare class MonitorAlertProcessingRuleActionGroupScheduleRecurrenceMonthlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorAlertProcessingRuleActionGroupScheduleRecurrenceMonthly | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceMonthly | cdktf.IResolvable | undefined);
    private _daysOfMonth?;
    get daysOfMonth(): number[];
    set daysOfMonth(value: number[]);
    get daysOfMonthInput(): number[] | undefined;
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export declare class MonitorAlertProcessingRuleActionGroupScheduleRecurrenceMonthlyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceMonthly[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorAlertProcessingRuleActionGroupScheduleRecurrenceMonthlyOutputReference;
}
export interface MonitorAlertProcessingRuleActionGroupScheduleRecurrenceWeekly {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#days_of_week MonitorAlertProcessingRuleActionGroup#days_of_week}
    */
    readonly daysOfWeek: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#end_time MonitorAlertProcessingRuleActionGroup#end_time}
    */
    readonly endTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#start_time MonitorAlertProcessingRuleActionGroup#start_time}
    */
    readonly startTime?: string;
}
export declare function monitorAlertProcessingRuleActionGroupScheduleRecurrenceWeeklyToTerraform(struct?: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceWeekly | cdktf.IResolvable): any;
export declare function monitorAlertProcessingRuleActionGroupScheduleRecurrenceWeeklyToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceWeekly | cdktf.IResolvable): any;
export declare class MonitorAlertProcessingRuleActionGroupScheduleRecurrenceWeeklyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorAlertProcessingRuleActionGroupScheduleRecurrenceWeekly | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceWeekly | cdktf.IResolvable | undefined);
    private _daysOfWeek?;
    get daysOfWeek(): string[];
    set daysOfWeek(value: string[]);
    get daysOfWeekInput(): string[] | undefined;
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export declare class MonitorAlertProcessingRuleActionGroupScheduleRecurrenceWeeklyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceWeekly[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorAlertProcessingRuleActionGroupScheduleRecurrenceWeeklyOutputReference;
}
export interface MonitorAlertProcessingRuleActionGroupScheduleRecurrence {
    /**
    * daily block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#daily MonitorAlertProcessingRuleActionGroup#daily}
    */
    readonly daily?: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceDaily[] | cdktf.IResolvable;
    /**
    * monthly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#monthly MonitorAlertProcessingRuleActionGroup#monthly}
    */
    readonly monthly?: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceMonthly[] | cdktf.IResolvable;
    /**
    * weekly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#weekly MonitorAlertProcessingRuleActionGroup#weekly}
    */
    readonly weekly?: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceWeekly[] | cdktf.IResolvable;
}
export declare function monitorAlertProcessingRuleActionGroupScheduleRecurrenceToTerraform(struct?: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceOutputReference | MonitorAlertProcessingRuleActionGroupScheduleRecurrence): any;
export declare function monitorAlertProcessingRuleActionGroupScheduleRecurrenceToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceOutputReference | MonitorAlertProcessingRuleActionGroupScheduleRecurrence): any;
export declare class MonitorAlertProcessingRuleActionGroupScheduleRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleActionGroupScheduleRecurrence | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupScheduleRecurrence | undefined);
    private _daily;
    get daily(): MonitorAlertProcessingRuleActionGroupScheduleRecurrenceDailyList;
    putDaily(value: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceDaily[] | cdktf.IResolvable): void;
    resetDaily(): void;
    get dailyInput(): cdktf.IResolvable | MonitorAlertProcessingRuleActionGroupScheduleRecurrenceDaily[] | undefined;
    private _monthly;
    get monthly(): MonitorAlertProcessingRuleActionGroupScheduleRecurrenceMonthlyList;
    putMonthly(value: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceMonthly[] | cdktf.IResolvable): void;
    resetMonthly(): void;
    get monthlyInput(): cdktf.IResolvable | MonitorAlertProcessingRuleActionGroupScheduleRecurrenceMonthly[] | undefined;
    private _weekly;
    get weekly(): MonitorAlertProcessingRuleActionGroupScheduleRecurrenceWeeklyList;
    putWeekly(value: MonitorAlertProcessingRuleActionGroupScheduleRecurrenceWeekly[] | cdktf.IResolvable): void;
    resetWeekly(): void;
    get weeklyInput(): cdktf.IResolvable | MonitorAlertProcessingRuleActionGroupScheduleRecurrenceWeekly[] | undefined;
}
export interface MonitorAlertProcessingRuleActionGroupSchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#effective_from MonitorAlertProcessingRuleActionGroup#effective_from}
    */
    readonly effectiveFrom?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#effective_until MonitorAlertProcessingRuleActionGroup#effective_until}
    */
    readonly effectiveUntil?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#time_zone MonitorAlertProcessingRuleActionGroup#time_zone}
    */
    readonly timeZone?: string;
    /**
    * recurrence block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#recurrence MonitorAlertProcessingRuleActionGroup#recurrence}
    */
    readonly recurrence?: MonitorAlertProcessingRuleActionGroupScheduleRecurrence;
}
export declare function monitorAlertProcessingRuleActionGroupScheduleToTerraform(struct?: MonitorAlertProcessingRuleActionGroupScheduleOutputReference | MonitorAlertProcessingRuleActionGroupSchedule): any;
export declare function monitorAlertProcessingRuleActionGroupScheduleToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupScheduleOutputReference | MonitorAlertProcessingRuleActionGroupSchedule): any;
export declare class MonitorAlertProcessingRuleActionGroupScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleActionGroupSchedule | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupSchedule | undefined);
    private _effectiveFrom?;
    get effectiveFrom(): string;
    set effectiveFrom(value: string);
    resetEffectiveFrom(): void;
    get effectiveFromInput(): string | undefined;
    private _effectiveUntil?;
    get effectiveUntil(): string;
    set effectiveUntil(value: string);
    resetEffectiveUntil(): void;
    get effectiveUntilInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _recurrence;
    get recurrence(): MonitorAlertProcessingRuleActionGroupScheduleRecurrenceOutputReference;
    putRecurrence(value: MonitorAlertProcessingRuleActionGroupScheduleRecurrence): void;
    resetRecurrence(): void;
    get recurrenceInput(): MonitorAlertProcessingRuleActionGroupScheduleRecurrence | undefined;
}
export interface MonitorAlertProcessingRuleActionGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#create MonitorAlertProcessingRuleActionGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#delete MonitorAlertProcessingRuleActionGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#read MonitorAlertProcessingRuleActionGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#update MonitorAlertProcessingRuleActionGroup#update}
    */
    readonly update?: string;
}
export declare function monitorAlertProcessingRuleActionGroupTimeoutsToTerraform(struct?: MonitorAlertProcessingRuleActionGroupTimeouts | cdktf.IResolvable): any;
export declare function monitorAlertProcessingRuleActionGroupTimeoutsToHclTerraform(struct?: MonitorAlertProcessingRuleActionGroupTimeouts | cdktf.IResolvable): any;
export declare class MonitorAlertProcessingRuleActionGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleActionGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAlertProcessingRuleActionGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group azurerm_monitor_alert_processing_rule_action_group}
*/
export declare class MonitorAlertProcessingRuleActionGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_alert_processing_rule_action_group";
    /**
    * Generates CDKTF code for importing a MonitorAlertProcessingRuleActionGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MonitorAlertProcessingRuleActionGroup to import
    * @param importFromId The id of the existing MonitorAlertProcessingRuleActionGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MonitorAlertProcessingRuleActionGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_alert_processing_rule_action_group azurerm_monitor_alert_processing_rule_action_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorAlertProcessingRuleActionGroupConfig
    */
    constructor(scope: Construct, id: string, config: MonitorAlertProcessingRuleActionGroupConfig);
    private _addActionGroupIds?;
    get addActionGroupIds(): string[];
    set addActionGroupIds(value: string[]);
    get addActionGroupIdsInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _condition;
    get condition(): MonitorAlertProcessingRuleActionGroupConditionOutputReference;
    putCondition(value: MonitorAlertProcessingRuleActionGroupCondition): void;
    resetCondition(): void;
    get conditionInput(): MonitorAlertProcessingRuleActionGroupCondition | undefined;
    private _schedule;
    get schedule(): MonitorAlertProcessingRuleActionGroupScheduleOutputReference;
    putSchedule(value: MonitorAlertProcessingRuleActionGroupSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): MonitorAlertProcessingRuleActionGroupSchedule | undefined;
    private _timeouts;
    get timeouts(): MonitorAlertProcessingRuleActionGroupTimeoutsOutputReference;
    putTimeouts(value: MonitorAlertProcessingRuleActionGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorAlertProcessingRuleActionGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
