/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorDataCollectionRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#data_collection_endpoint_id MonitorDataCollectionRule#data_collection_endpoint_id}
    */
    readonly dataCollectionEndpointId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#description MonitorDataCollectionRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#id MonitorDataCollectionRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#kind MonitorDataCollectionRule#kind}
    */
    readonly kind?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#location MonitorDataCollectionRule#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#resource_group_name MonitorDataCollectionRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#tags MonitorDataCollectionRule#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * data_flow block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#data_flow MonitorDataCollectionRule#data_flow}
    */
    readonly dataFlow: MonitorDataCollectionRuleDataFlow[] | cdktf.IResolvable;
    /**
    * data_sources block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#data_sources MonitorDataCollectionRule#data_sources}
    */
    readonly dataSources?: MonitorDataCollectionRuleDataSources;
    /**
    * destinations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#destinations MonitorDataCollectionRule#destinations}
    */
    readonly destinations: MonitorDataCollectionRuleDestinations;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#identity MonitorDataCollectionRule#identity}
    */
    readonly identity?: MonitorDataCollectionRuleIdentity;
    /**
    * stream_declaration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#stream_declaration MonitorDataCollectionRule#stream_declaration}
    */
    readonly streamDeclaration?: MonitorDataCollectionRuleStreamDeclaration[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#timeouts MonitorDataCollectionRule#timeouts}
    */
    readonly timeouts?: MonitorDataCollectionRuleTimeouts;
}
export interface MonitorDataCollectionRuleDataFlow {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#built_in_transform MonitorDataCollectionRule#built_in_transform}
    */
    readonly builtInTransform?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#destinations MonitorDataCollectionRule#destinations}
    */
    readonly destinations: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#output_stream MonitorDataCollectionRule#output_stream}
    */
    readonly outputStream?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#streams MonitorDataCollectionRule#streams}
    */
    readonly streams: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#transform_kql MonitorDataCollectionRule#transform_kql}
    */
    readonly transformKql?: string;
}
export declare function monitorDataCollectionRuleDataFlowToTerraform(struct?: MonitorDataCollectionRuleDataFlow | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDataFlowToHclTerraform(struct?: MonitorDataCollectionRuleDataFlow | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataFlowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataFlow | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataFlow | cdktf.IResolvable | undefined);
    private _builtInTransform?;
    get builtInTransform(): string;
    set builtInTransform(value: string);
    resetBuiltInTransform(): void;
    get builtInTransformInput(): string | undefined;
    private _destinations?;
    get destinations(): string[];
    set destinations(value: string[]);
    get destinationsInput(): string[] | undefined;
    private _outputStream?;
    get outputStream(): string;
    set outputStream(value: string);
    resetOutputStream(): void;
    get outputStreamInput(): string | undefined;
    private _streams?;
    get streams(): string[];
    set streams(value: string[]);
    get streamsInput(): string[] | undefined;
    private _transformKql?;
    get transformKql(): string;
    set transformKql(value: string);
    resetTransformKql(): void;
    get transformKqlInput(): string | undefined;
}
export declare class MonitorDataCollectionRuleDataFlowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataFlow[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataFlowOutputReference;
}
export interface MonitorDataCollectionRuleDataSourcesDataImportEventHubDataSource {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#consumer_group MonitorDataCollectionRule#consumer_group}
    */
    readonly consumerGroup?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#stream MonitorDataCollectionRule#stream}
    */
    readonly stream: string;
}
export declare function monitorDataCollectionRuleDataSourcesDataImportEventHubDataSourceToTerraform(struct?: MonitorDataCollectionRuleDataSourcesDataImportEventHubDataSource | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDataSourcesDataImportEventHubDataSourceToHclTerraform(struct?: MonitorDataCollectionRuleDataSourcesDataImportEventHubDataSource | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataSourcesDataImportEventHubDataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataSourcesDataImportEventHubDataSource | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesDataImportEventHubDataSource | cdktf.IResolvable | undefined);
    private _consumerGroup?;
    get consumerGroup(): string;
    set consumerGroup(value: string);
    resetConsumerGroup(): void;
    get consumerGroupInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _stream?;
    get stream(): string;
    set stream(value: string);
    get streamInput(): string | undefined;
}
export declare class MonitorDataCollectionRuleDataSourcesDataImportEventHubDataSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataSourcesDataImportEventHubDataSource[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataSourcesDataImportEventHubDataSourceOutputReference;
}
export interface MonitorDataCollectionRuleDataSourcesDataImport {
    /**
    * event_hub_data_source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#event_hub_data_source MonitorDataCollectionRule#event_hub_data_source}
    */
    readonly eventHubDataSource: MonitorDataCollectionRuleDataSourcesDataImportEventHubDataSource[] | cdktf.IResolvable;
}
export declare function monitorDataCollectionRuleDataSourcesDataImportToTerraform(struct?: MonitorDataCollectionRuleDataSourcesDataImportOutputReference | MonitorDataCollectionRuleDataSourcesDataImport): any;
export declare function monitorDataCollectionRuleDataSourcesDataImportToHclTerraform(struct?: MonitorDataCollectionRuleDataSourcesDataImportOutputReference | MonitorDataCollectionRuleDataSourcesDataImport): any;
export declare class MonitorDataCollectionRuleDataSourcesDataImportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDataCollectionRuleDataSourcesDataImport | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesDataImport | undefined);
    private _eventHubDataSource;
    get eventHubDataSource(): MonitorDataCollectionRuleDataSourcesDataImportEventHubDataSourceList;
    putEventHubDataSource(value: MonitorDataCollectionRuleDataSourcesDataImportEventHubDataSource[] | cdktf.IResolvable): void;
    get eventHubDataSourceInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataSourcesDataImportEventHubDataSource[] | undefined;
}
export interface MonitorDataCollectionRuleDataSourcesExtension {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#extension_json MonitorDataCollectionRule#extension_json}
    */
    readonly extensionJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#extension_name MonitorDataCollectionRule#extension_name}
    */
    readonly extensionName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#input_data_sources MonitorDataCollectionRule#input_data_sources}
    */
    readonly inputDataSources?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#streams MonitorDataCollectionRule#streams}
    */
    readonly streams: string[];
}
export declare function monitorDataCollectionRuleDataSourcesExtensionToTerraform(struct?: MonitorDataCollectionRuleDataSourcesExtension | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDataSourcesExtensionToHclTerraform(struct?: MonitorDataCollectionRuleDataSourcesExtension | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataSourcesExtensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataSourcesExtension | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesExtension | cdktf.IResolvable | undefined);
    private _extensionJson?;
    get extensionJson(): string;
    set extensionJson(value: string);
    resetExtensionJson(): void;
    get extensionJsonInput(): string | undefined;
    private _extensionName?;
    get extensionName(): string;
    set extensionName(value: string);
    get extensionNameInput(): string | undefined;
    private _inputDataSources?;
    get inputDataSources(): string[];
    set inputDataSources(value: string[]);
    resetInputDataSources(): void;
    get inputDataSourcesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _streams?;
    get streams(): string[];
    set streams(value: string[]);
    get streamsInput(): string[] | undefined;
}
export declare class MonitorDataCollectionRuleDataSourcesExtensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataSourcesExtension[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataSourcesExtensionOutputReference;
}
export interface MonitorDataCollectionRuleDataSourcesIisLog {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#log_directories MonitorDataCollectionRule#log_directories}
    */
    readonly logDirectories?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#streams MonitorDataCollectionRule#streams}
    */
    readonly streams: string[];
}
export declare function monitorDataCollectionRuleDataSourcesIisLogToTerraform(struct?: MonitorDataCollectionRuleDataSourcesIisLog | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDataSourcesIisLogToHclTerraform(struct?: MonitorDataCollectionRuleDataSourcesIisLog | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataSourcesIisLogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataSourcesIisLog | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesIisLog | cdktf.IResolvable | undefined);
    private _logDirectories?;
    get logDirectories(): string[];
    set logDirectories(value: string[]);
    resetLogDirectories(): void;
    get logDirectoriesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _streams?;
    get streams(): string[];
    set streams(value: string[]);
    get streamsInput(): string[] | undefined;
}
export declare class MonitorDataCollectionRuleDataSourcesIisLogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataSourcesIisLog[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataSourcesIisLogOutputReference;
}
export interface MonitorDataCollectionRuleDataSourcesLogFileSettingsText {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#record_start_timestamp_format MonitorDataCollectionRule#record_start_timestamp_format}
    */
    readonly recordStartTimestampFormat: string;
}
export declare function monitorDataCollectionRuleDataSourcesLogFileSettingsTextToTerraform(struct?: MonitorDataCollectionRuleDataSourcesLogFileSettingsTextOutputReference | MonitorDataCollectionRuleDataSourcesLogFileSettingsText): any;
export declare function monitorDataCollectionRuleDataSourcesLogFileSettingsTextToHclTerraform(struct?: MonitorDataCollectionRuleDataSourcesLogFileSettingsTextOutputReference | MonitorDataCollectionRuleDataSourcesLogFileSettingsText): any;
export declare class MonitorDataCollectionRuleDataSourcesLogFileSettingsTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDataCollectionRuleDataSourcesLogFileSettingsText | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesLogFileSettingsText | undefined);
    private _recordStartTimestampFormat?;
    get recordStartTimestampFormat(): string;
    set recordStartTimestampFormat(value: string);
    get recordStartTimestampFormatInput(): string | undefined;
}
export interface MonitorDataCollectionRuleDataSourcesLogFileSettings {
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#text MonitorDataCollectionRule#text}
    */
    readonly text: MonitorDataCollectionRuleDataSourcesLogFileSettingsText;
}
export declare function monitorDataCollectionRuleDataSourcesLogFileSettingsToTerraform(struct?: MonitorDataCollectionRuleDataSourcesLogFileSettingsOutputReference | MonitorDataCollectionRuleDataSourcesLogFileSettings): any;
export declare function monitorDataCollectionRuleDataSourcesLogFileSettingsToHclTerraform(struct?: MonitorDataCollectionRuleDataSourcesLogFileSettingsOutputReference | MonitorDataCollectionRuleDataSourcesLogFileSettings): any;
export declare class MonitorDataCollectionRuleDataSourcesLogFileSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDataCollectionRuleDataSourcesLogFileSettings | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesLogFileSettings | undefined);
    private _text;
    get text(): MonitorDataCollectionRuleDataSourcesLogFileSettingsTextOutputReference;
    putText(value: MonitorDataCollectionRuleDataSourcesLogFileSettingsText): void;
    get textInput(): MonitorDataCollectionRuleDataSourcesLogFileSettingsText | undefined;
}
export interface MonitorDataCollectionRuleDataSourcesLogFile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#file_patterns MonitorDataCollectionRule#file_patterns}
    */
    readonly filePatterns: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#format MonitorDataCollectionRule#format}
    */
    readonly format: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#streams MonitorDataCollectionRule#streams}
    */
    readonly streams: string[];
    /**
    * settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#settings MonitorDataCollectionRule#settings}
    */
    readonly settings?: MonitorDataCollectionRuleDataSourcesLogFileSettings;
}
export declare function monitorDataCollectionRuleDataSourcesLogFileToTerraform(struct?: MonitorDataCollectionRuleDataSourcesLogFile | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDataSourcesLogFileToHclTerraform(struct?: MonitorDataCollectionRuleDataSourcesLogFile | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataSourcesLogFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataSourcesLogFile | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesLogFile | cdktf.IResolvable | undefined);
    private _filePatterns?;
    get filePatterns(): string[];
    set filePatterns(value: string[]);
    get filePatternsInput(): string[] | undefined;
    private _format?;
    get format(): string;
    set format(value: string);
    get formatInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _streams?;
    get streams(): string[];
    set streams(value: string[]);
    get streamsInput(): string[] | undefined;
    private _settings;
    get settings(): MonitorDataCollectionRuleDataSourcesLogFileSettingsOutputReference;
    putSettings(value: MonitorDataCollectionRuleDataSourcesLogFileSettings): void;
    resetSettings(): void;
    get settingsInput(): MonitorDataCollectionRuleDataSourcesLogFileSettings | undefined;
}
export declare class MonitorDataCollectionRuleDataSourcesLogFileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataSourcesLogFile[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataSourcesLogFileOutputReference;
}
export interface MonitorDataCollectionRuleDataSourcesPerformanceCounter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#counter_specifiers MonitorDataCollectionRule#counter_specifiers}
    */
    readonly counterSpecifiers: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#sampling_frequency_in_seconds MonitorDataCollectionRule#sampling_frequency_in_seconds}
    */
    readonly samplingFrequencyInSeconds: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#streams MonitorDataCollectionRule#streams}
    */
    readonly streams: string[];
}
export declare function monitorDataCollectionRuleDataSourcesPerformanceCounterToTerraform(struct?: MonitorDataCollectionRuleDataSourcesPerformanceCounter | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDataSourcesPerformanceCounterToHclTerraform(struct?: MonitorDataCollectionRuleDataSourcesPerformanceCounter | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataSourcesPerformanceCounterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataSourcesPerformanceCounter | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesPerformanceCounter | cdktf.IResolvable | undefined);
    private _counterSpecifiers?;
    get counterSpecifiers(): string[];
    set counterSpecifiers(value: string[]);
    get counterSpecifiersInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _samplingFrequencyInSeconds?;
    get samplingFrequencyInSeconds(): number;
    set samplingFrequencyInSeconds(value: number);
    get samplingFrequencyInSecondsInput(): number | undefined;
    private _streams?;
    get streams(): string[];
    set streams(value: string[]);
    get streamsInput(): string[] | undefined;
}
export declare class MonitorDataCollectionRuleDataSourcesPerformanceCounterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataSourcesPerformanceCounter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataSourcesPerformanceCounterOutputReference;
}
export interface MonitorDataCollectionRuleDataSourcesPlatformTelemetry {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#streams MonitorDataCollectionRule#streams}
    */
    readonly streams: string[];
}
export declare function monitorDataCollectionRuleDataSourcesPlatformTelemetryToTerraform(struct?: MonitorDataCollectionRuleDataSourcesPlatformTelemetry | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDataSourcesPlatformTelemetryToHclTerraform(struct?: MonitorDataCollectionRuleDataSourcesPlatformTelemetry | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataSourcesPlatformTelemetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataSourcesPlatformTelemetry | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesPlatformTelemetry | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _streams?;
    get streams(): string[];
    set streams(value: string[]);
    get streamsInput(): string[] | undefined;
}
export declare class MonitorDataCollectionRuleDataSourcesPlatformTelemetryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataSourcesPlatformTelemetry[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataSourcesPlatformTelemetryOutputReference;
}
export interface MonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#label MonitorDataCollectionRule#label}
    */
    readonly label: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#value MonitorDataCollectionRule#value}
    */
    readonly value: string;
}
export declare function monitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilterToTerraform(struct?: MonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilter | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilterToHclTerraform(struct?: MonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilter | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilter | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilter | cdktf.IResolvable | undefined);
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class MonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilterOutputReference;
}
export interface MonitorDataCollectionRuleDataSourcesPrometheusForwarder {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#streams MonitorDataCollectionRule#streams}
    */
    readonly streams: string[];
    /**
    * label_include_filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#label_include_filter MonitorDataCollectionRule#label_include_filter}
    */
    readonly labelIncludeFilter?: MonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilter[] | cdktf.IResolvable;
}
export declare function monitorDataCollectionRuleDataSourcesPrometheusForwarderToTerraform(struct?: MonitorDataCollectionRuleDataSourcesPrometheusForwarder | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDataSourcesPrometheusForwarderToHclTerraform(struct?: MonitorDataCollectionRuleDataSourcesPrometheusForwarder | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataSourcesPrometheusForwarderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataSourcesPrometheusForwarder | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesPrometheusForwarder | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _streams?;
    get streams(): string[];
    set streams(value: string[]);
    get streamsInput(): string[] | undefined;
    private _labelIncludeFilter;
    get labelIncludeFilter(): MonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilterList;
    putLabelIncludeFilter(value: MonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilter[] | cdktf.IResolvable): void;
    resetLabelIncludeFilter(): void;
    get labelIncludeFilterInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilter[] | undefined;
}
export declare class MonitorDataCollectionRuleDataSourcesPrometheusForwarderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataSourcesPrometheusForwarder[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataSourcesPrometheusForwarderOutputReference;
}
export interface MonitorDataCollectionRuleDataSourcesSyslog {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#facility_names MonitorDataCollectionRule#facility_names}
    */
    readonly facilityNames: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#log_levels MonitorDataCollectionRule#log_levels}
    */
    readonly logLevels: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#streams MonitorDataCollectionRule#streams}
    */
    readonly streams?: string[];
}
export declare function monitorDataCollectionRuleDataSourcesSyslogToTerraform(struct?: MonitorDataCollectionRuleDataSourcesSyslog | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDataSourcesSyslogToHclTerraform(struct?: MonitorDataCollectionRuleDataSourcesSyslog | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataSourcesSyslogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataSourcesSyslog | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesSyslog | cdktf.IResolvable | undefined);
    private _facilityNames?;
    get facilityNames(): string[];
    set facilityNames(value: string[]);
    get facilityNamesInput(): string[] | undefined;
    private _logLevels?;
    get logLevels(): string[];
    set logLevels(value: string[]);
    get logLevelsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _streams?;
    get streams(): string[];
    set streams(value: string[]);
    resetStreams(): void;
    get streamsInput(): string[] | undefined;
}
export declare class MonitorDataCollectionRuleDataSourcesSyslogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataSourcesSyslog[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataSourcesSyslogOutputReference;
}
export interface MonitorDataCollectionRuleDataSourcesWindowsEventLog {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#streams MonitorDataCollectionRule#streams}
    */
    readonly streams: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#x_path_queries MonitorDataCollectionRule#x_path_queries}
    */
    readonly xPathQueries: string[];
}
export declare function monitorDataCollectionRuleDataSourcesWindowsEventLogToTerraform(struct?: MonitorDataCollectionRuleDataSourcesWindowsEventLog | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDataSourcesWindowsEventLogToHclTerraform(struct?: MonitorDataCollectionRuleDataSourcesWindowsEventLog | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataSourcesWindowsEventLogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataSourcesWindowsEventLog | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesWindowsEventLog | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _streams?;
    get streams(): string[];
    set streams(value: string[]);
    get streamsInput(): string[] | undefined;
    private _xPathQueries?;
    get xPathQueries(): string[];
    set xPathQueries(value: string[]);
    get xPathQueriesInput(): string[] | undefined;
}
export declare class MonitorDataCollectionRuleDataSourcesWindowsEventLogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataSourcesWindowsEventLog[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataSourcesWindowsEventLogOutputReference;
}
export interface MonitorDataCollectionRuleDataSourcesWindowsFirewallLog {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#streams MonitorDataCollectionRule#streams}
    */
    readonly streams: string[];
}
export declare function monitorDataCollectionRuleDataSourcesWindowsFirewallLogToTerraform(struct?: MonitorDataCollectionRuleDataSourcesWindowsFirewallLog | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDataSourcesWindowsFirewallLogToHclTerraform(struct?: MonitorDataCollectionRuleDataSourcesWindowsFirewallLog | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataSourcesWindowsFirewallLogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataSourcesWindowsFirewallLog | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesWindowsFirewallLog | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _streams?;
    get streams(): string[];
    set streams(value: string[]);
    get streamsInput(): string[] | undefined;
}
export declare class MonitorDataCollectionRuleDataSourcesWindowsFirewallLogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataSourcesWindowsFirewallLog[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataSourcesWindowsFirewallLogOutputReference;
}
export interface MonitorDataCollectionRuleDataSources {
    /**
    * data_import block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#data_import MonitorDataCollectionRule#data_import}
    */
    readonly dataImport?: MonitorDataCollectionRuleDataSourcesDataImport;
    /**
    * extension block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#extension MonitorDataCollectionRule#extension}
    */
    readonly extension?: MonitorDataCollectionRuleDataSourcesExtension[] | cdktf.IResolvable;
    /**
    * iis_log block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#iis_log MonitorDataCollectionRule#iis_log}
    */
    readonly iisLog?: MonitorDataCollectionRuleDataSourcesIisLog[] | cdktf.IResolvable;
    /**
    * log_file block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#log_file MonitorDataCollectionRule#log_file}
    */
    readonly logFile?: MonitorDataCollectionRuleDataSourcesLogFile[] | cdktf.IResolvable;
    /**
    * performance_counter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#performance_counter MonitorDataCollectionRule#performance_counter}
    */
    readonly performanceCounter?: MonitorDataCollectionRuleDataSourcesPerformanceCounter[] | cdktf.IResolvable;
    /**
    * platform_telemetry block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#platform_telemetry MonitorDataCollectionRule#platform_telemetry}
    */
    readonly platformTelemetry?: MonitorDataCollectionRuleDataSourcesPlatformTelemetry[] | cdktf.IResolvable;
    /**
    * prometheus_forwarder block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#prometheus_forwarder MonitorDataCollectionRule#prometheus_forwarder}
    */
    readonly prometheusForwarder?: MonitorDataCollectionRuleDataSourcesPrometheusForwarder[] | cdktf.IResolvable;
    /**
    * syslog block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#syslog MonitorDataCollectionRule#syslog}
    */
    readonly syslog?: MonitorDataCollectionRuleDataSourcesSyslog[] | cdktf.IResolvable;
    /**
    * windows_event_log block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#windows_event_log MonitorDataCollectionRule#windows_event_log}
    */
    readonly windowsEventLog?: MonitorDataCollectionRuleDataSourcesWindowsEventLog[] | cdktf.IResolvable;
    /**
    * windows_firewall_log block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#windows_firewall_log MonitorDataCollectionRule#windows_firewall_log}
    */
    readonly windowsFirewallLog?: MonitorDataCollectionRuleDataSourcesWindowsFirewallLog[] | cdktf.IResolvable;
}
export declare function monitorDataCollectionRuleDataSourcesToTerraform(struct?: MonitorDataCollectionRuleDataSourcesOutputReference | MonitorDataCollectionRuleDataSources): any;
export declare function monitorDataCollectionRuleDataSourcesToHclTerraform(struct?: MonitorDataCollectionRuleDataSourcesOutputReference | MonitorDataCollectionRuleDataSources): any;
export declare class MonitorDataCollectionRuleDataSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDataCollectionRuleDataSources | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSources | undefined);
    private _dataImport;
    get dataImport(): MonitorDataCollectionRuleDataSourcesDataImportOutputReference;
    putDataImport(value: MonitorDataCollectionRuleDataSourcesDataImport): void;
    resetDataImport(): void;
    get dataImportInput(): MonitorDataCollectionRuleDataSourcesDataImport | undefined;
    private _extension;
    get extension(): MonitorDataCollectionRuleDataSourcesExtensionList;
    putExtension(value: MonitorDataCollectionRuleDataSourcesExtension[] | cdktf.IResolvable): void;
    resetExtension(): void;
    get extensionInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataSourcesExtension[] | undefined;
    private _iisLog;
    get iisLog(): MonitorDataCollectionRuleDataSourcesIisLogList;
    putIisLog(value: MonitorDataCollectionRuleDataSourcesIisLog[] | cdktf.IResolvable): void;
    resetIisLog(): void;
    get iisLogInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataSourcesIisLog[] | undefined;
    private _logFile;
    get logFile(): MonitorDataCollectionRuleDataSourcesLogFileList;
    putLogFile(value: MonitorDataCollectionRuleDataSourcesLogFile[] | cdktf.IResolvable): void;
    resetLogFile(): void;
    get logFileInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataSourcesLogFile[] | undefined;
    private _performanceCounter;
    get performanceCounter(): MonitorDataCollectionRuleDataSourcesPerformanceCounterList;
    putPerformanceCounter(value: MonitorDataCollectionRuleDataSourcesPerformanceCounter[] | cdktf.IResolvable): void;
    resetPerformanceCounter(): void;
    get performanceCounterInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataSourcesPerformanceCounter[] | undefined;
    private _platformTelemetry;
    get platformTelemetry(): MonitorDataCollectionRuleDataSourcesPlatformTelemetryList;
    putPlatformTelemetry(value: MonitorDataCollectionRuleDataSourcesPlatformTelemetry[] | cdktf.IResolvable): void;
    resetPlatformTelemetry(): void;
    get platformTelemetryInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataSourcesPlatformTelemetry[] | undefined;
    private _prometheusForwarder;
    get prometheusForwarder(): MonitorDataCollectionRuleDataSourcesPrometheusForwarderList;
    putPrometheusForwarder(value: MonitorDataCollectionRuleDataSourcesPrometheusForwarder[] | cdktf.IResolvable): void;
    resetPrometheusForwarder(): void;
    get prometheusForwarderInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataSourcesPrometheusForwarder[] | undefined;
    private _syslog;
    get syslog(): MonitorDataCollectionRuleDataSourcesSyslogList;
    putSyslog(value: MonitorDataCollectionRuleDataSourcesSyslog[] | cdktf.IResolvable): void;
    resetSyslog(): void;
    get syslogInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataSourcesSyslog[] | undefined;
    private _windowsEventLog;
    get windowsEventLog(): MonitorDataCollectionRuleDataSourcesWindowsEventLogList;
    putWindowsEventLog(value: MonitorDataCollectionRuleDataSourcesWindowsEventLog[] | cdktf.IResolvable): void;
    resetWindowsEventLog(): void;
    get windowsEventLogInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataSourcesWindowsEventLog[] | undefined;
    private _windowsFirewallLog;
    get windowsFirewallLog(): MonitorDataCollectionRuleDataSourcesWindowsFirewallLogList;
    putWindowsFirewallLog(value: MonitorDataCollectionRuleDataSourcesWindowsFirewallLog[] | cdktf.IResolvable): void;
    resetWindowsFirewallLog(): void;
    get windowsFirewallLogInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataSourcesWindowsFirewallLog[] | undefined;
}
export interface MonitorDataCollectionRuleDestinationsAzureMonitorMetrics {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
}
export declare function monitorDataCollectionRuleDestinationsAzureMonitorMetricsToTerraform(struct?: MonitorDataCollectionRuleDestinationsAzureMonitorMetricsOutputReference | MonitorDataCollectionRuleDestinationsAzureMonitorMetrics): any;
export declare function monitorDataCollectionRuleDestinationsAzureMonitorMetricsToHclTerraform(struct?: MonitorDataCollectionRuleDestinationsAzureMonitorMetricsOutputReference | MonitorDataCollectionRuleDestinationsAzureMonitorMetrics): any;
export declare class MonitorDataCollectionRuleDestinationsAzureMonitorMetricsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDataCollectionRuleDestinationsAzureMonitorMetrics | undefined;
    set internalValue(value: MonitorDataCollectionRuleDestinationsAzureMonitorMetrics | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface MonitorDataCollectionRuleDestinationsEventHub {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#event_hub_id MonitorDataCollectionRule#event_hub_id}
    */
    readonly eventHubId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
}
export declare function monitorDataCollectionRuleDestinationsEventHubToTerraform(struct?: MonitorDataCollectionRuleDestinationsEventHubOutputReference | MonitorDataCollectionRuleDestinationsEventHub): any;
export declare function monitorDataCollectionRuleDestinationsEventHubToHclTerraform(struct?: MonitorDataCollectionRuleDestinationsEventHubOutputReference | MonitorDataCollectionRuleDestinationsEventHub): any;
export declare class MonitorDataCollectionRuleDestinationsEventHubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDataCollectionRuleDestinationsEventHub | undefined;
    set internalValue(value: MonitorDataCollectionRuleDestinationsEventHub | undefined);
    private _eventHubId?;
    get eventHubId(): string;
    set eventHubId(value: string);
    get eventHubIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface MonitorDataCollectionRuleDestinationsEventHubDirect {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#event_hub_id MonitorDataCollectionRule#event_hub_id}
    */
    readonly eventHubId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
}
export declare function monitorDataCollectionRuleDestinationsEventHubDirectToTerraform(struct?: MonitorDataCollectionRuleDestinationsEventHubDirectOutputReference | MonitorDataCollectionRuleDestinationsEventHubDirect): any;
export declare function monitorDataCollectionRuleDestinationsEventHubDirectToHclTerraform(struct?: MonitorDataCollectionRuleDestinationsEventHubDirectOutputReference | MonitorDataCollectionRuleDestinationsEventHubDirect): any;
export declare class MonitorDataCollectionRuleDestinationsEventHubDirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDataCollectionRuleDestinationsEventHubDirect | undefined;
    set internalValue(value: MonitorDataCollectionRuleDestinationsEventHubDirect | undefined);
    private _eventHubId?;
    get eventHubId(): string;
    set eventHubId(value: string);
    get eventHubIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface MonitorDataCollectionRuleDestinationsLogAnalytics {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#workspace_resource_id MonitorDataCollectionRule#workspace_resource_id}
    */
    readonly workspaceResourceId: string;
}
export declare function monitorDataCollectionRuleDestinationsLogAnalyticsToTerraform(struct?: MonitorDataCollectionRuleDestinationsLogAnalytics | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDestinationsLogAnalyticsToHclTerraform(struct?: MonitorDataCollectionRuleDestinationsLogAnalytics | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDestinationsLogAnalyticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDestinationsLogAnalytics | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDestinationsLogAnalytics | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _workspaceResourceId?;
    get workspaceResourceId(): string;
    set workspaceResourceId(value: string);
    get workspaceResourceIdInput(): string | undefined;
}
export declare class MonitorDataCollectionRuleDestinationsLogAnalyticsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDestinationsLogAnalytics[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDestinationsLogAnalyticsOutputReference;
}
export interface MonitorDataCollectionRuleDestinationsMonitorAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#monitor_account_id MonitorDataCollectionRule#monitor_account_id}
    */
    readonly monitorAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
}
export declare function monitorDataCollectionRuleDestinationsMonitorAccountToTerraform(struct?: MonitorDataCollectionRuleDestinationsMonitorAccount | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDestinationsMonitorAccountToHclTerraform(struct?: MonitorDataCollectionRuleDestinationsMonitorAccount | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDestinationsMonitorAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDestinationsMonitorAccount | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDestinationsMonitorAccount | cdktf.IResolvable | undefined);
    private _monitorAccountId?;
    get monitorAccountId(): string;
    set monitorAccountId(value: string);
    get monitorAccountIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class MonitorDataCollectionRuleDestinationsMonitorAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDestinationsMonitorAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDestinationsMonitorAccountOutputReference;
}
export interface MonitorDataCollectionRuleDestinationsStorageBlob {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#container_name MonitorDataCollectionRule#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#storage_account_id MonitorDataCollectionRule#storage_account_id}
    */
    readonly storageAccountId: string;
}
export declare function monitorDataCollectionRuleDestinationsStorageBlobToTerraform(struct?: MonitorDataCollectionRuleDestinationsStorageBlob | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDestinationsStorageBlobToHclTerraform(struct?: MonitorDataCollectionRuleDestinationsStorageBlob | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDestinationsStorageBlobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDestinationsStorageBlob | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDestinationsStorageBlob | cdktf.IResolvable | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
}
export declare class MonitorDataCollectionRuleDestinationsStorageBlobList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDestinationsStorageBlob[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDestinationsStorageBlobOutputReference;
}
export interface MonitorDataCollectionRuleDestinationsStorageBlobDirect {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#container_name MonitorDataCollectionRule#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#storage_account_id MonitorDataCollectionRule#storage_account_id}
    */
    readonly storageAccountId: string;
}
export declare function monitorDataCollectionRuleDestinationsStorageBlobDirectToTerraform(struct?: MonitorDataCollectionRuleDestinationsStorageBlobDirect | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDestinationsStorageBlobDirectToHclTerraform(struct?: MonitorDataCollectionRuleDestinationsStorageBlobDirect | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDestinationsStorageBlobDirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDestinationsStorageBlobDirect | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDestinationsStorageBlobDirect | cdktf.IResolvable | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
}
export declare class MonitorDataCollectionRuleDestinationsStorageBlobDirectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDestinationsStorageBlobDirect[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDestinationsStorageBlobDirectOutputReference;
}
export interface MonitorDataCollectionRuleDestinationsStorageTableDirect {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#storage_account_id MonitorDataCollectionRule#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#table_name MonitorDataCollectionRule#table_name}
    */
    readonly tableName: string;
}
export declare function monitorDataCollectionRuleDestinationsStorageTableDirectToTerraform(struct?: MonitorDataCollectionRuleDestinationsStorageTableDirect | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleDestinationsStorageTableDirectToHclTerraform(struct?: MonitorDataCollectionRuleDestinationsStorageTableDirect | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDestinationsStorageTableDirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDestinationsStorageTableDirect | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDestinationsStorageTableDirect | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _tableName?;
    get tableName(): string;
    set tableName(value: string);
    get tableNameInput(): string | undefined;
}
export declare class MonitorDataCollectionRuleDestinationsStorageTableDirectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDestinationsStorageTableDirect[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDestinationsStorageTableDirectOutputReference;
}
export interface MonitorDataCollectionRuleDestinations {
    /**
    * azure_monitor_metrics block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#azure_monitor_metrics MonitorDataCollectionRule#azure_monitor_metrics}
    */
    readonly azureMonitorMetrics?: MonitorDataCollectionRuleDestinationsAzureMonitorMetrics;
    /**
    * event_hub block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#event_hub MonitorDataCollectionRule#event_hub}
    */
    readonly eventHub?: MonitorDataCollectionRuleDestinationsEventHub;
    /**
    * event_hub_direct block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#event_hub_direct MonitorDataCollectionRule#event_hub_direct}
    */
    readonly eventHubDirect?: MonitorDataCollectionRuleDestinationsEventHubDirect;
    /**
    * log_analytics block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#log_analytics MonitorDataCollectionRule#log_analytics}
    */
    readonly logAnalytics?: MonitorDataCollectionRuleDestinationsLogAnalytics[] | cdktf.IResolvable;
    /**
    * monitor_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#monitor_account MonitorDataCollectionRule#monitor_account}
    */
    readonly monitorAccount?: MonitorDataCollectionRuleDestinationsMonitorAccount[] | cdktf.IResolvable;
    /**
    * storage_blob block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#storage_blob MonitorDataCollectionRule#storage_blob}
    */
    readonly storageBlob?: MonitorDataCollectionRuleDestinationsStorageBlob[] | cdktf.IResolvable;
    /**
    * storage_blob_direct block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#storage_blob_direct MonitorDataCollectionRule#storage_blob_direct}
    */
    readonly storageBlobDirect?: MonitorDataCollectionRuleDestinationsStorageBlobDirect[] | cdktf.IResolvable;
    /**
    * storage_table_direct block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#storage_table_direct MonitorDataCollectionRule#storage_table_direct}
    */
    readonly storageTableDirect?: MonitorDataCollectionRuleDestinationsStorageTableDirect[] | cdktf.IResolvable;
}
export declare function monitorDataCollectionRuleDestinationsToTerraform(struct?: MonitorDataCollectionRuleDestinationsOutputReference | MonitorDataCollectionRuleDestinations): any;
export declare function monitorDataCollectionRuleDestinationsToHclTerraform(struct?: MonitorDataCollectionRuleDestinationsOutputReference | MonitorDataCollectionRuleDestinations): any;
export declare class MonitorDataCollectionRuleDestinationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDataCollectionRuleDestinations | undefined;
    set internalValue(value: MonitorDataCollectionRuleDestinations | undefined);
    private _azureMonitorMetrics;
    get azureMonitorMetrics(): MonitorDataCollectionRuleDestinationsAzureMonitorMetricsOutputReference;
    putAzureMonitorMetrics(value: MonitorDataCollectionRuleDestinationsAzureMonitorMetrics): void;
    resetAzureMonitorMetrics(): void;
    get azureMonitorMetricsInput(): MonitorDataCollectionRuleDestinationsAzureMonitorMetrics | undefined;
    private _eventHub;
    get eventHub(): MonitorDataCollectionRuleDestinationsEventHubOutputReference;
    putEventHub(value: MonitorDataCollectionRuleDestinationsEventHub): void;
    resetEventHub(): void;
    get eventHubInput(): MonitorDataCollectionRuleDestinationsEventHub | undefined;
    private _eventHubDirect;
    get eventHubDirect(): MonitorDataCollectionRuleDestinationsEventHubDirectOutputReference;
    putEventHubDirect(value: MonitorDataCollectionRuleDestinationsEventHubDirect): void;
    resetEventHubDirect(): void;
    get eventHubDirectInput(): MonitorDataCollectionRuleDestinationsEventHubDirect | undefined;
    private _logAnalytics;
    get logAnalytics(): MonitorDataCollectionRuleDestinationsLogAnalyticsList;
    putLogAnalytics(value: MonitorDataCollectionRuleDestinationsLogAnalytics[] | cdktf.IResolvable): void;
    resetLogAnalytics(): void;
    get logAnalyticsInput(): cdktf.IResolvable | MonitorDataCollectionRuleDestinationsLogAnalytics[] | undefined;
    private _monitorAccount;
    get monitorAccount(): MonitorDataCollectionRuleDestinationsMonitorAccountList;
    putMonitorAccount(value: MonitorDataCollectionRuleDestinationsMonitorAccount[] | cdktf.IResolvable): void;
    resetMonitorAccount(): void;
    get monitorAccountInput(): cdktf.IResolvable | MonitorDataCollectionRuleDestinationsMonitorAccount[] | undefined;
    private _storageBlob;
    get storageBlob(): MonitorDataCollectionRuleDestinationsStorageBlobList;
    putStorageBlob(value: MonitorDataCollectionRuleDestinationsStorageBlob[] | cdktf.IResolvable): void;
    resetStorageBlob(): void;
    get storageBlobInput(): cdktf.IResolvable | MonitorDataCollectionRuleDestinationsStorageBlob[] | undefined;
    private _storageBlobDirect;
    get storageBlobDirect(): MonitorDataCollectionRuleDestinationsStorageBlobDirectList;
    putStorageBlobDirect(value: MonitorDataCollectionRuleDestinationsStorageBlobDirect[] | cdktf.IResolvable): void;
    resetStorageBlobDirect(): void;
    get storageBlobDirectInput(): cdktf.IResolvable | MonitorDataCollectionRuleDestinationsStorageBlobDirect[] | undefined;
    private _storageTableDirect;
    get storageTableDirect(): MonitorDataCollectionRuleDestinationsStorageTableDirectList;
    putStorageTableDirect(value: MonitorDataCollectionRuleDestinationsStorageTableDirect[] | cdktf.IResolvable): void;
    resetStorageTableDirect(): void;
    get storageTableDirectInput(): cdktf.IResolvable | MonitorDataCollectionRuleDestinationsStorageTableDirect[] | undefined;
}
export interface MonitorDataCollectionRuleIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#identity_ids MonitorDataCollectionRule#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#type MonitorDataCollectionRule#type}
    */
    readonly type: string;
}
export declare function monitorDataCollectionRuleIdentityToTerraform(struct?: MonitorDataCollectionRuleIdentityOutputReference | MonitorDataCollectionRuleIdentity): any;
export declare function monitorDataCollectionRuleIdentityToHclTerraform(struct?: MonitorDataCollectionRuleIdentityOutputReference | MonitorDataCollectionRuleIdentity): any;
export declare class MonitorDataCollectionRuleIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDataCollectionRuleIdentity | undefined;
    set internalValue(value: MonitorDataCollectionRuleIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface MonitorDataCollectionRuleStreamDeclarationColumn {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#type MonitorDataCollectionRule#type}
    */
    readonly type: string;
}
export declare function monitorDataCollectionRuleStreamDeclarationColumnToTerraform(struct?: MonitorDataCollectionRuleStreamDeclarationColumn | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleStreamDeclarationColumnToHclTerraform(struct?: MonitorDataCollectionRuleStreamDeclarationColumn | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleStreamDeclarationColumnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleStreamDeclarationColumn | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleStreamDeclarationColumn | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class MonitorDataCollectionRuleStreamDeclarationColumnList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleStreamDeclarationColumn[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleStreamDeclarationColumnOutputReference;
}
export interface MonitorDataCollectionRuleStreamDeclaration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#stream_name MonitorDataCollectionRule#stream_name}
    */
    readonly streamName: string;
    /**
    * column block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#column MonitorDataCollectionRule#column}
    */
    readonly column: MonitorDataCollectionRuleStreamDeclarationColumn[] | cdktf.IResolvable;
}
export declare function monitorDataCollectionRuleStreamDeclarationToTerraform(struct?: MonitorDataCollectionRuleStreamDeclaration | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleStreamDeclarationToHclTerraform(struct?: MonitorDataCollectionRuleStreamDeclaration | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleStreamDeclarationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleStreamDeclaration | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleStreamDeclaration | cdktf.IResolvable | undefined);
    private _streamName?;
    get streamName(): string;
    set streamName(value: string);
    get streamNameInput(): string | undefined;
    private _column;
    get column(): MonitorDataCollectionRuleStreamDeclarationColumnList;
    putColumn(value: MonitorDataCollectionRuleStreamDeclarationColumn[] | cdktf.IResolvable): void;
    get columnInput(): cdktf.IResolvable | MonitorDataCollectionRuleStreamDeclarationColumn[] | undefined;
}
export declare class MonitorDataCollectionRuleStreamDeclarationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleStreamDeclaration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleStreamDeclarationOutputReference;
}
export interface MonitorDataCollectionRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#create MonitorDataCollectionRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#delete MonitorDataCollectionRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#read MonitorDataCollectionRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#update MonitorDataCollectionRule#update}
    */
    readonly update?: string;
}
export declare function monitorDataCollectionRuleTimeoutsToTerraform(struct?: MonitorDataCollectionRuleTimeouts | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleTimeoutsToHclTerraform(struct?: MonitorDataCollectionRuleTimeouts | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDataCollectionRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule azurerm_monitor_data_collection_rule}
*/
export declare class MonitorDataCollectionRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_data_collection_rule";
    /**
    * Generates CDKTF code for importing a MonitorDataCollectionRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MonitorDataCollectionRule to import
    * @param importFromId The id of the existing MonitorDataCollectionRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MonitorDataCollectionRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/monitor_data_collection_rule azurerm_monitor_data_collection_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorDataCollectionRuleConfig
    */
    constructor(scope: Construct, id: string, config: MonitorDataCollectionRuleConfig);
    private _dataCollectionEndpointId?;
    get dataCollectionEndpointId(): string;
    set dataCollectionEndpointId(value: string);
    resetDataCollectionEndpointId(): void;
    get dataCollectionEndpointIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get immutableId(): string;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    resetKind(): void;
    get kindInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _dataFlow;
    get dataFlow(): MonitorDataCollectionRuleDataFlowList;
    putDataFlow(value: MonitorDataCollectionRuleDataFlow[] | cdktf.IResolvable): void;
    get dataFlowInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataFlow[] | undefined;
    private _dataSources;
    get dataSources(): MonitorDataCollectionRuleDataSourcesOutputReference;
    putDataSources(value: MonitorDataCollectionRuleDataSources): void;
    resetDataSources(): void;
    get dataSourcesInput(): MonitorDataCollectionRuleDataSources | undefined;
    private _destinations;
    get destinations(): MonitorDataCollectionRuleDestinationsOutputReference;
    putDestinations(value: MonitorDataCollectionRuleDestinations): void;
    get destinationsInput(): MonitorDataCollectionRuleDestinations | undefined;
    private _identity;
    get identity(): MonitorDataCollectionRuleIdentityOutputReference;
    putIdentity(value: MonitorDataCollectionRuleIdentity): void;
    resetIdentity(): void;
    get identityInput(): MonitorDataCollectionRuleIdentity | undefined;
    private _streamDeclaration;
    get streamDeclaration(): MonitorDataCollectionRuleStreamDeclarationList;
    putStreamDeclaration(value: MonitorDataCollectionRuleStreamDeclaration[] | cdktf.IResolvable): void;
    resetStreamDeclaration(): void;
    get streamDeclarationInput(): cdktf.IResolvable | MonitorDataCollectionRuleStreamDeclaration[] | undefined;
    private _timeouts;
    get timeouts(): MonitorDataCollectionRuleTimeoutsOutputReference;
    putTimeouts(value: MonitorDataCollectionRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorDataCollectionRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
