"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AzurermProvider = exports.azurermProviderFeaturesToHclTerraform = exports.azurermProviderFeaturesToTerraform = exports.azurermProviderFeaturesVirtualMachineScaleSetToHclTerraform = exports.azurermProviderFeaturesVirtualMachineScaleSetToTerraform = exports.azurermProviderFeaturesVirtualMachineToHclTerraform = exports.azurermProviderFeaturesVirtualMachineToTerraform = exports.azurermProviderFeaturesTemplateDeploymentToHclTerraform = exports.azurermProviderFeaturesTemplateDeploymentToTerraform = exports.azurermProviderFeaturesSubscriptionToHclTerraform = exports.azurermProviderFeaturesSubscriptionToTerraform = exports.azurermProviderFeaturesResourceGroupToHclTerraform = exports.azurermProviderFeaturesResourceGroupToTerraform = exports.azurermProviderFeaturesManagedDiskToHclTerraform = exports.azurermProviderFeaturesManagedDiskToTerraform = exports.azurermProviderFeaturesLogAnalyticsWorkspaceToHclTerraform = exports.azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform = exports.azurermProviderFeaturesKeyVaultToHclTerraform = exports.azurermProviderFeaturesKeyVaultToTerraform = exports.azurermProviderFeaturesCognitiveAccountToHclTerraform = exports.azurermProviderFeaturesCognitiveAccountToTerraform = exports.azurermProviderFeaturesApplicationInsightsToHclTerraform = exports.azurermProviderFeaturesApplicationInsightsToTerraform = exports.azurermProviderFeaturesAppConfigurationToHclTerraform = exports.azurermProviderFeaturesAppConfigurationToTerraform = exports.azurermProviderFeaturesApiManagementToHclTerraform = exports.azurermProviderFeaturesApiManagementToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function azurermProviderFeaturesApiManagementToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
        recover_soft_deleted: cdktf.booleanToTerraform(struct.recoverSoftDeleted),
    };
}
exports.azurermProviderFeaturesApiManagementToTerraform = azurermProviderFeaturesApiManagementToTerraform;
function azurermProviderFeaturesApiManagementToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        purge_soft_delete_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.purgeSoftDeleteOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        recover_soft_deleted: {
            value: cdktf.booleanToHclTerraform(struct.recoverSoftDeleted),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesApiManagementToHclTerraform = azurermProviderFeaturesApiManagementToHclTerraform;
function azurermProviderFeaturesAppConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
        recover_soft_deleted: cdktf.booleanToTerraform(struct.recoverSoftDeleted),
    };
}
exports.azurermProviderFeaturesAppConfigurationToTerraform = azurermProviderFeaturesAppConfigurationToTerraform;
function azurermProviderFeaturesAppConfigurationToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        purge_soft_delete_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.purgeSoftDeleteOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        recover_soft_deleted: {
            value: cdktf.booleanToHclTerraform(struct.recoverSoftDeleted),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesAppConfigurationToHclTerraform = azurermProviderFeaturesAppConfigurationToHclTerraform;
function azurermProviderFeaturesApplicationInsightsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        disable_generated_rule: cdktf.booleanToTerraform(struct.disableGeneratedRule),
    };
}
exports.azurermProviderFeaturesApplicationInsightsToTerraform = azurermProviderFeaturesApplicationInsightsToTerraform;
function azurermProviderFeaturesApplicationInsightsToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        disable_generated_rule: {
            value: cdktf.booleanToHclTerraform(struct.disableGeneratedRule),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesApplicationInsightsToHclTerraform = azurermProviderFeaturesApplicationInsightsToHclTerraform;
function azurermProviderFeaturesCognitiveAccountToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
    };
}
exports.azurermProviderFeaturesCognitiveAccountToTerraform = azurermProviderFeaturesCognitiveAccountToTerraform;
function azurermProviderFeaturesCognitiveAccountToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        purge_soft_delete_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.purgeSoftDeleteOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesCognitiveAccountToHclTerraform = azurermProviderFeaturesCognitiveAccountToHclTerraform;
function azurermProviderFeaturesKeyVaultToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
        purge_soft_deleted_certificates_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedCertificatesOnDestroy),
        purge_soft_deleted_hardware_security_modules_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedHardwareSecurityModulesOnDestroy),
        purge_soft_deleted_keys_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedKeysOnDestroy),
        purge_soft_deleted_secrets_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedSecretsOnDestroy),
        recover_soft_deleted_certificates: cdktf.booleanToTerraform(struct.recoverSoftDeletedCertificates),
        recover_soft_deleted_key_vaults: cdktf.booleanToTerraform(struct.recoverSoftDeletedKeyVaults),
        recover_soft_deleted_keys: cdktf.booleanToTerraform(struct.recoverSoftDeletedKeys),
        recover_soft_deleted_secrets: cdktf.booleanToTerraform(struct.recoverSoftDeletedSecrets),
    };
}
exports.azurermProviderFeaturesKeyVaultToTerraform = azurermProviderFeaturesKeyVaultToTerraform;
function azurermProviderFeaturesKeyVaultToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        purge_soft_delete_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.purgeSoftDeleteOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        purge_soft_deleted_certificates_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.purgeSoftDeletedCertificatesOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        purge_soft_deleted_hardware_security_modules_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.purgeSoftDeletedHardwareSecurityModulesOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        purge_soft_deleted_keys_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.purgeSoftDeletedKeysOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        purge_soft_deleted_secrets_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.purgeSoftDeletedSecretsOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        recover_soft_deleted_certificates: {
            value: cdktf.booleanToHclTerraform(struct.recoverSoftDeletedCertificates),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        recover_soft_deleted_key_vaults: {
            value: cdktf.booleanToHclTerraform(struct.recoverSoftDeletedKeyVaults),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        recover_soft_deleted_keys: {
            value: cdktf.booleanToHclTerraform(struct.recoverSoftDeletedKeys),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        recover_soft_deleted_secrets: {
            value: cdktf.booleanToHclTerraform(struct.recoverSoftDeletedSecrets),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesKeyVaultToHclTerraform = azurermProviderFeaturesKeyVaultToHclTerraform;
function azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        permanently_delete_on_destroy: cdktf.booleanToTerraform(struct.permanentlyDeleteOnDestroy),
    };
}
exports.azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform = azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform;
function azurermProviderFeaturesLogAnalyticsWorkspaceToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        permanently_delete_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.permanentlyDeleteOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesLogAnalyticsWorkspaceToHclTerraform = azurermProviderFeaturesLogAnalyticsWorkspaceToHclTerraform;
function azurermProviderFeaturesManagedDiskToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        expand_without_downtime: cdktf.booleanToTerraform(struct.expandWithoutDowntime),
    };
}
exports.azurermProviderFeaturesManagedDiskToTerraform = azurermProviderFeaturesManagedDiskToTerraform;
function azurermProviderFeaturesManagedDiskToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        expand_without_downtime: {
            value: cdktf.booleanToHclTerraform(struct.expandWithoutDowntime),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesManagedDiskToHclTerraform = azurermProviderFeaturesManagedDiskToHclTerraform;
function azurermProviderFeaturesResourceGroupToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        prevent_deletion_if_contains_resources: cdktf.booleanToTerraform(struct.preventDeletionIfContainsResources),
    };
}
exports.azurermProviderFeaturesResourceGroupToTerraform = azurermProviderFeaturesResourceGroupToTerraform;
function azurermProviderFeaturesResourceGroupToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        prevent_deletion_if_contains_resources: {
            value: cdktf.booleanToHclTerraform(struct.preventDeletionIfContainsResources),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesResourceGroupToHclTerraform = azurermProviderFeaturesResourceGroupToHclTerraform;
function azurermProviderFeaturesSubscriptionToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        prevent_cancellation_on_destroy: cdktf.booleanToTerraform(struct.preventCancellationOnDestroy),
    };
}
exports.azurermProviderFeaturesSubscriptionToTerraform = azurermProviderFeaturesSubscriptionToTerraform;
function azurermProviderFeaturesSubscriptionToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        prevent_cancellation_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.preventCancellationOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesSubscriptionToHclTerraform = azurermProviderFeaturesSubscriptionToHclTerraform;
function azurermProviderFeaturesTemplateDeploymentToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        delete_nested_items_during_deletion: cdktf.booleanToTerraform(struct.deleteNestedItemsDuringDeletion),
    };
}
exports.azurermProviderFeaturesTemplateDeploymentToTerraform = azurermProviderFeaturesTemplateDeploymentToTerraform;
function azurermProviderFeaturesTemplateDeploymentToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        delete_nested_items_during_deletion: {
            value: cdktf.booleanToHclTerraform(struct.deleteNestedItemsDuringDeletion),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesTemplateDeploymentToHclTerraform = azurermProviderFeaturesTemplateDeploymentToHclTerraform;
function azurermProviderFeaturesVirtualMachineToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        delete_os_disk_on_deletion: cdktf.booleanToTerraform(struct.deleteOsDiskOnDeletion),
        graceful_shutdown: cdktf.booleanToTerraform(struct.gracefulShutdown),
        skip_shutdown_and_force_delete: cdktf.booleanToTerraform(struct.skipShutdownAndForceDelete),
    };
}
exports.azurermProviderFeaturesVirtualMachineToTerraform = azurermProviderFeaturesVirtualMachineToTerraform;
function azurermProviderFeaturesVirtualMachineToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        delete_os_disk_on_deletion: {
            value: cdktf.booleanToHclTerraform(struct.deleteOsDiskOnDeletion),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        graceful_shutdown: {
            value: cdktf.booleanToHclTerraform(struct.gracefulShutdown),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        skip_shutdown_and_force_delete: {
            value: cdktf.booleanToHclTerraform(struct.skipShutdownAndForceDelete),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesVirtualMachineToHclTerraform = azurermProviderFeaturesVirtualMachineToHclTerraform;
function azurermProviderFeaturesVirtualMachineScaleSetToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        force_delete: cdktf.booleanToTerraform(struct.forceDelete),
        roll_instances_when_required: cdktf.booleanToTerraform(struct.rollInstancesWhenRequired),
        scale_to_zero_before_deletion: cdktf.booleanToTerraform(struct.scaleToZeroBeforeDeletion),
    };
}
exports.azurermProviderFeaturesVirtualMachineScaleSetToTerraform = azurermProviderFeaturesVirtualMachineScaleSetToTerraform;
function azurermProviderFeaturesVirtualMachineScaleSetToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        force_delete: {
            value: cdktf.booleanToHclTerraform(struct.forceDelete),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        roll_instances_when_required: {
            value: cdktf.booleanToHclTerraform(struct.rollInstancesWhenRequired),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        scale_to_zero_before_deletion: {
            value: cdktf.booleanToHclTerraform(struct.scaleToZeroBeforeDeletion),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesVirtualMachineScaleSetToHclTerraform = azurermProviderFeaturesVirtualMachineScaleSetToHclTerraform;
function azurermProviderFeaturesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        api_management: azurermProviderFeaturesApiManagementToTerraform(struct.apiManagement),
        app_configuration: azurermProviderFeaturesAppConfigurationToTerraform(struct.appConfiguration),
        application_insights: azurermProviderFeaturesApplicationInsightsToTerraform(struct.applicationInsights),
        cognitive_account: azurermProviderFeaturesCognitiveAccountToTerraform(struct.cognitiveAccount),
        key_vault: azurermProviderFeaturesKeyVaultToTerraform(struct.keyVault),
        log_analytics_workspace: azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform(struct.logAnalyticsWorkspace),
        managed_disk: azurermProviderFeaturesManagedDiskToTerraform(struct.managedDisk),
        resource_group: azurermProviderFeaturesResourceGroupToTerraform(struct.resourceGroup),
        subscription: azurermProviderFeaturesSubscriptionToTerraform(struct.subscription),
        template_deployment: azurermProviderFeaturesTemplateDeploymentToTerraform(struct.templateDeployment),
        virtual_machine: azurermProviderFeaturesVirtualMachineToTerraform(struct.virtualMachine),
        virtual_machine_scale_set: azurermProviderFeaturesVirtualMachineScaleSetToTerraform(struct.virtualMachineScaleSet),
    };
}
exports.azurermProviderFeaturesToTerraform = azurermProviderFeaturesToTerraform;
function azurermProviderFeaturesToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        api_management: {
            value: azurermProviderFeaturesApiManagementToHclTerraform(struct.apiManagement),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesApiManagementList",
        },
        app_configuration: {
            value: azurermProviderFeaturesAppConfigurationToHclTerraform(struct.appConfiguration),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesAppConfigurationList",
        },
        application_insights: {
            value: azurermProviderFeaturesApplicationInsightsToHclTerraform(struct.applicationInsights),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesApplicationInsightsList",
        },
        cognitive_account: {
            value: azurermProviderFeaturesCognitiveAccountToHclTerraform(struct.cognitiveAccount),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesCognitiveAccountList",
        },
        key_vault: {
            value: azurermProviderFeaturesKeyVaultToHclTerraform(struct.keyVault),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesKeyVaultList",
        },
        log_analytics_workspace: {
            value: azurermProviderFeaturesLogAnalyticsWorkspaceToHclTerraform(struct.logAnalyticsWorkspace),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesLogAnalyticsWorkspaceList",
        },
        managed_disk: {
            value: azurermProviderFeaturesManagedDiskToHclTerraform(struct.managedDisk),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesManagedDiskList",
        },
        resource_group: {
            value: azurermProviderFeaturesResourceGroupToHclTerraform(struct.resourceGroup),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesResourceGroupList",
        },
        subscription: {
            value: azurermProviderFeaturesSubscriptionToHclTerraform(struct.subscription),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesSubscriptionList",
        },
        template_deployment: {
            value: azurermProviderFeaturesTemplateDeploymentToHclTerraform(struct.templateDeployment),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesTemplateDeploymentList",
        },
        virtual_machine: {
            value: azurermProviderFeaturesVirtualMachineToHclTerraform(struct.virtualMachine),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesVirtualMachineList",
        },
        virtual_machine_scale_set: {
            value: azurermProviderFeaturesVirtualMachineScaleSetToHclTerraform(struct.virtualMachineScaleSet),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesVirtualMachineScaleSetList",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesToHclTerraform = azurermProviderFeaturesToHclTerraform;
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs azurerm}
*/
class AzurermProvider extends cdktf.TerraformProvider {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a AzurermProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AzurermProvider to import
    * @param importFromId The id of the existing AzurermProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AzurermProvider to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "azurerm", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs azurerm} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AzurermProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.89.0',
                providerVersionConstraint: '~> 3.10'
            },
            terraformProviderSource: 'azurerm'
        });
        this._auxiliaryTenantIds = config.auxiliaryTenantIds;
        this._clientCertificate = config.clientCertificate;
        this._clientCertificatePassword = config.clientCertificatePassword;
        this._clientCertificatePath = config.clientCertificatePath;
        this._clientId = config.clientId;
        this._clientIdFilePath = config.clientIdFilePath;
        this._clientSecret = config.clientSecret;
        this._clientSecretFilePath = config.clientSecretFilePath;
        this._disableCorrelationRequestId = config.disableCorrelationRequestId;
        this._disableTerraformPartnerId = config.disableTerraformPartnerId;
        this._environment = config.environment;
        this._metadataHost = config.metadataHost;
        this._msiEndpoint = config.msiEndpoint;
        this._oidcRequestToken = config.oidcRequestToken;
        this._oidcRequestUrl = config.oidcRequestUrl;
        this._oidcToken = config.oidcToken;
        this._oidcTokenFilePath = config.oidcTokenFilePath;
        this._partnerId = config.partnerId;
        this._skipProviderRegistration = config.skipProviderRegistration;
        this._storageUseAzuread = config.storageUseAzuread;
        this._subscriptionId = config.subscriptionId;
        this._tenantId = config.tenantId;
        this._useAksWorkloadIdentity = config.useAksWorkloadIdentity;
        this._useCli = config.useCli;
        this._useMsi = config.useMsi;
        this._useOidc = config.useOidc;
        this._alias = config.alias;
        this._features = config.features;
    }
    get auxiliaryTenantIds() {
        return this._auxiliaryTenantIds;
    }
    set auxiliaryTenantIds(value) {
        this._auxiliaryTenantIds = value;
    }
    resetAuxiliaryTenantIds() {
        this._auxiliaryTenantIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get auxiliaryTenantIdsInput() {
        return this._auxiliaryTenantIds;
    }
    get clientCertificate() {
        return this._clientCertificate;
    }
    set clientCertificate(value) {
        this._clientCertificate = value;
    }
    resetClientCertificate() {
        this._clientCertificate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertificateInput() {
        return this._clientCertificate;
    }
    get clientCertificatePassword() {
        return this._clientCertificatePassword;
    }
    set clientCertificatePassword(value) {
        this._clientCertificatePassword = value;
    }
    resetClientCertificatePassword() {
        this._clientCertificatePassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertificatePasswordInput() {
        return this._clientCertificatePassword;
    }
    get clientCertificatePath() {
        return this._clientCertificatePath;
    }
    set clientCertificatePath(value) {
        this._clientCertificatePath = value;
    }
    resetClientCertificatePath() {
        this._clientCertificatePath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertificatePathInput() {
        return this._clientCertificatePath;
    }
    get clientId() {
        return this._clientId;
    }
    set clientId(value) {
        this._clientId = value;
    }
    resetClientId() {
        this._clientId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientIdInput() {
        return this._clientId;
    }
    get clientIdFilePath() {
        return this._clientIdFilePath;
    }
    set clientIdFilePath(value) {
        this._clientIdFilePath = value;
    }
    resetClientIdFilePath() {
        this._clientIdFilePath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientIdFilePathInput() {
        return this._clientIdFilePath;
    }
    get clientSecret() {
        return this._clientSecret;
    }
    set clientSecret(value) {
        this._clientSecret = value;
    }
    resetClientSecret() {
        this._clientSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientSecretInput() {
        return this._clientSecret;
    }
    get clientSecretFilePath() {
        return this._clientSecretFilePath;
    }
    set clientSecretFilePath(value) {
        this._clientSecretFilePath = value;
    }
    resetClientSecretFilePath() {
        this._clientSecretFilePath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientSecretFilePathInput() {
        return this._clientSecretFilePath;
    }
    get disableCorrelationRequestId() {
        return this._disableCorrelationRequestId;
    }
    set disableCorrelationRequestId(value) {
        this._disableCorrelationRequestId = value;
    }
    resetDisableCorrelationRequestId() {
        this._disableCorrelationRequestId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableCorrelationRequestIdInput() {
        return this._disableCorrelationRequestId;
    }
    get disableTerraformPartnerId() {
        return this._disableTerraformPartnerId;
    }
    set disableTerraformPartnerId(value) {
        this._disableTerraformPartnerId = value;
    }
    resetDisableTerraformPartnerId() {
        this._disableTerraformPartnerId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableTerraformPartnerIdInput() {
        return this._disableTerraformPartnerId;
    }
    get environment() {
        return this._environment;
    }
    set environment(value) {
        this._environment = value;
    }
    resetEnvironment() {
        this._environment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get environmentInput() {
        return this._environment;
    }
    get metadataHost() {
        return this._metadataHost;
    }
    set metadataHost(value) {
        this._metadataHost = value;
    }
    resetMetadataHost() {
        this._metadataHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get metadataHostInput() {
        return this._metadataHost;
    }
    get msiEndpoint() {
        return this._msiEndpoint;
    }
    set msiEndpoint(value) {
        this._msiEndpoint = value;
    }
    resetMsiEndpoint() {
        this._msiEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get msiEndpointInput() {
        return this._msiEndpoint;
    }
    get oidcRequestToken() {
        return this._oidcRequestToken;
    }
    set oidcRequestToken(value) {
        this._oidcRequestToken = value;
    }
    resetOidcRequestToken() {
        this._oidcRequestToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcRequestTokenInput() {
        return this._oidcRequestToken;
    }
    get oidcRequestUrl() {
        return this._oidcRequestUrl;
    }
    set oidcRequestUrl(value) {
        this._oidcRequestUrl = value;
    }
    resetOidcRequestUrl() {
        this._oidcRequestUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcRequestUrlInput() {
        return this._oidcRequestUrl;
    }
    get oidcToken() {
        return this._oidcToken;
    }
    set oidcToken(value) {
        this._oidcToken = value;
    }
    resetOidcToken() {
        this._oidcToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcTokenInput() {
        return this._oidcToken;
    }
    get oidcTokenFilePath() {
        return this._oidcTokenFilePath;
    }
    set oidcTokenFilePath(value) {
        this._oidcTokenFilePath = value;
    }
    resetOidcTokenFilePath() {
        this._oidcTokenFilePath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcTokenFilePathInput() {
        return this._oidcTokenFilePath;
    }
    get partnerId() {
        return this._partnerId;
    }
    set partnerId(value) {
        this._partnerId = value;
    }
    resetPartnerId() {
        this._partnerId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get partnerIdInput() {
        return this._partnerId;
    }
    get skipProviderRegistration() {
        return this._skipProviderRegistration;
    }
    set skipProviderRegistration(value) {
        this._skipProviderRegistration = value;
    }
    resetSkipProviderRegistration() {
        this._skipProviderRegistration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipProviderRegistrationInput() {
        return this._skipProviderRegistration;
    }
    get storageUseAzuread() {
        return this._storageUseAzuread;
    }
    set storageUseAzuread(value) {
        this._storageUseAzuread = value;
    }
    resetStorageUseAzuread() {
        this._storageUseAzuread = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageUseAzureadInput() {
        return this._storageUseAzuread;
    }
    get subscriptionId() {
        return this._subscriptionId;
    }
    set subscriptionId(value) {
        this._subscriptionId = value;
    }
    resetSubscriptionId() {
        this._subscriptionId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subscriptionIdInput() {
        return this._subscriptionId;
    }
    get tenantId() {
        return this._tenantId;
    }
    set tenantId(value) {
        this._tenantId = value;
    }
    resetTenantId() {
        this._tenantId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tenantIdInput() {
        return this._tenantId;
    }
    get useAksWorkloadIdentity() {
        return this._useAksWorkloadIdentity;
    }
    set useAksWorkloadIdentity(value) {
        this._useAksWorkloadIdentity = value;
    }
    resetUseAksWorkloadIdentity() {
        this._useAksWorkloadIdentity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useAksWorkloadIdentityInput() {
        return this._useAksWorkloadIdentity;
    }
    get useCli() {
        return this._useCli;
    }
    set useCli(value) {
        this._useCli = value;
    }
    resetUseCli() {
        this._useCli = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useCliInput() {
        return this._useCli;
    }
    get useMsi() {
        return this._useMsi;
    }
    set useMsi(value) {
        this._useMsi = value;
    }
    resetUseMsi() {
        this._useMsi = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useMsiInput() {
        return this._useMsi;
    }
    get useOidc() {
        return this._useOidc;
    }
    set useOidc(value) {
        this._useOidc = value;
    }
    resetUseOidc() {
        this._useOidc = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useOidcInput() {
        return this._useOidc;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get features() {
        return this._features;
    }
    set features(value) {
        this._features = value;
    }
    // Temporarily expose input value. Use with caution.
    get featuresInput() {
        return this._features;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            auxiliary_tenant_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._auxiliaryTenantIds),
            client_certificate: cdktf.stringToTerraform(this._clientCertificate),
            client_certificate_password: cdktf.stringToTerraform(this._clientCertificatePassword),
            client_certificate_path: cdktf.stringToTerraform(this._clientCertificatePath),
            client_id: cdktf.stringToTerraform(this._clientId),
            client_id_file_path: cdktf.stringToTerraform(this._clientIdFilePath),
            client_secret: cdktf.stringToTerraform(this._clientSecret),
            client_secret_file_path: cdktf.stringToTerraform(this._clientSecretFilePath),
            disable_correlation_request_id: cdktf.booleanToTerraform(this._disableCorrelationRequestId),
            disable_terraform_partner_id: cdktf.booleanToTerraform(this._disableTerraformPartnerId),
            environment: cdktf.stringToTerraform(this._environment),
            metadata_host: cdktf.stringToTerraform(this._metadataHost),
            msi_endpoint: cdktf.stringToTerraform(this._msiEndpoint),
            oidc_request_token: cdktf.stringToTerraform(this._oidcRequestToken),
            oidc_request_url: cdktf.stringToTerraform(this._oidcRequestUrl),
            oidc_token: cdktf.stringToTerraform(this._oidcToken),
            oidc_token_file_path: cdktf.stringToTerraform(this._oidcTokenFilePath),
            partner_id: cdktf.stringToTerraform(this._partnerId),
            skip_provider_registration: cdktf.booleanToTerraform(this._skipProviderRegistration),
            storage_use_azuread: cdktf.booleanToTerraform(this._storageUseAzuread),
            subscription_id: cdktf.stringToTerraform(this._subscriptionId),
            tenant_id: cdktf.stringToTerraform(this._tenantId),
            use_aks_workload_identity: cdktf.booleanToTerraform(this._useAksWorkloadIdentity),
            use_cli: cdktf.booleanToTerraform(this._useCli),
            use_msi: cdktf.booleanToTerraform(this._useMsi),
            use_oidc: cdktf.booleanToTerraform(this._useOidc),
            alias: cdktf.stringToTerraform(this._alias),
            features: azurermProviderFeaturesToTerraform(this._features),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            auxiliary_tenant_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._auxiliaryTenantIds),
                isBlock: false,
                type: "list",
                storageClassType: "stringList",
            },
            client_certificate: {
                value: cdktf.stringToHclTerraform(this._clientCertificate),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_certificate_password: {
                value: cdktf.stringToHclTerraform(this._clientCertificatePassword),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_certificate_path: {
                value: cdktf.stringToHclTerraform(this._clientCertificatePath),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_id: {
                value: cdktf.stringToHclTerraform(this._clientId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_id_file_path: {
                value: cdktf.stringToHclTerraform(this._clientIdFilePath),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_secret: {
                value: cdktf.stringToHclTerraform(this._clientSecret),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_secret_file_path: {
                value: cdktf.stringToHclTerraform(this._clientSecretFilePath),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            disable_correlation_request_id: {
                value: cdktf.booleanToHclTerraform(this._disableCorrelationRequestId),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            disable_terraform_partner_id: {
                value: cdktf.booleanToHclTerraform(this._disableTerraformPartnerId),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            environment: {
                value: cdktf.stringToHclTerraform(this._environment),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            metadata_host: {
                value: cdktf.stringToHclTerraform(this._metadataHost),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            msi_endpoint: {
                value: cdktf.stringToHclTerraform(this._msiEndpoint),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            oidc_request_token: {
                value: cdktf.stringToHclTerraform(this._oidcRequestToken),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            oidc_request_url: {
                value: cdktf.stringToHclTerraform(this._oidcRequestUrl),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            oidc_token: {
                value: cdktf.stringToHclTerraform(this._oidcToken),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            oidc_token_file_path: {
                value: cdktf.stringToHclTerraform(this._oidcTokenFilePath),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            partner_id: {
                value: cdktf.stringToHclTerraform(this._partnerId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            skip_provider_registration: {
                value: cdktf.booleanToHclTerraform(this._skipProviderRegistration),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            storage_use_azuread: {
                value: cdktf.booleanToHclTerraform(this._storageUseAzuread),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            subscription_id: {
                value: cdktf.stringToHclTerraform(this._subscriptionId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            tenant_id: {
                value: cdktf.stringToHclTerraform(this._tenantId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            use_aks_workload_identity: {
                value: cdktf.booleanToHclTerraform(this._useAksWorkloadIdentity),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            use_cli: {
                value: cdktf.booleanToHclTerraform(this._useCli),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            use_msi: {
                value: cdktf.booleanToHclTerraform(this._useMsi),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            use_oidc: {
                value: cdktf.booleanToHclTerraform(this._useOidc),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            alias: {
                value: cdktf.stringToHclTerraform(this._alias),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            features: {
                value: azurermProviderFeaturesToHclTerraform(this._features),
                isBlock: true,
                type: "list",
                storageClassType: "AzurermProviderFeaturesList",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.AzurermProvider = AzurermProvider;
_a = JSII_RTTI_SYMBOL_1;
AzurermProvider[_a] = { fqn: "@cdktf/provider-azurerm.provider.AzurermProvider", version: "12.3.0" };
// =================
// STATIC PROPERTIES
// =================
AzurermProvider.tfResourceType = "azurerm";
//# sourceMappingURL=data:application/json;base64,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