/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurityCenterServerVulnerabilityAssessmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/security_center_server_vulnerability_assessment#hybrid_machine_id SecurityCenterServerVulnerabilityAssessment#hybrid_machine_id}
    */
    readonly hybridMachineId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/security_center_server_vulnerability_assessment#id SecurityCenterServerVulnerabilityAssessment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/security_center_server_vulnerability_assessment#virtual_machine_id SecurityCenterServerVulnerabilityAssessment#virtual_machine_id}
    */
    readonly virtualMachineId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/security_center_server_vulnerability_assessment#timeouts SecurityCenterServerVulnerabilityAssessment#timeouts}
    */
    readonly timeouts?: SecurityCenterServerVulnerabilityAssessmentTimeouts;
}
export interface SecurityCenterServerVulnerabilityAssessmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/security_center_server_vulnerability_assessment#create SecurityCenterServerVulnerabilityAssessment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/security_center_server_vulnerability_assessment#delete SecurityCenterServerVulnerabilityAssessment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/security_center_server_vulnerability_assessment#read SecurityCenterServerVulnerabilityAssessment#read}
    */
    readonly read?: string;
}
export declare function securityCenterServerVulnerabilityAssessmentTimeoutsToTerraform(struct?: SecurityCenterServerVulnerabilityAssessmentTimeouts | cdktf.IResolvable): any;
export declare function securityCenterServerVulnerabilityAssessmentTimeoutsToHclTerraform(struct?: SecurityCenterServerVulnerabilityAssessmentTimeouts | cdktf.IResolvable): any;
export declare class SecurityCenterServerVulnerabilityAssessmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityCenterServerVulnerabilityAssessmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityCenterServerVulnerabilityAssessmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/security_center_server_vulnerability_assessment azurerm_security_center_server_vulnerability_assessment}
*/
export declare class SecurityCenterServerVulnerabilityAssessment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_security_center_server_vulnerability_assessment";
    /**
    * Generates CDKTF code for importing a SecurityCenterServerVulnerabilityAssessment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecurityCenterServerVulnerabilityAssessment to import
    * @param importFromId The id of the existing SecurityCenterServerVulnerabilityAssessment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/security_center_server_vulnerability_assessment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecurityCenterServerVulnerabilityAssessment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/security_center_server_vulnerability_assessment azurerm_security_center_server_vulnerability_assessment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityCenterServerVulnerabilityAssessmentConfig = {}
    */
    constructor(scope: Construct, id: string, config?: SecurityCenterServerVulnerabilityAssessmentConfig);
    private _hybridMachineId?;
    get hybridMachineId(): string;
    set hybridMachineId(value: string);
    resetHybridMachineId(): void;
    get hybridMachineIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _virtualMachineId?;
    get virtualMachineId(): string;
    set virtualMachineId(value: string);
    resetVirtualMachineId(): void;
    get virtualMachineIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SecurityCenterServerVulnerabilityAssessmentTimeoutsOutputReference;
    putTimeouts(value: SecurityCenterServerVulnerabilityAssessmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SecurityCenterServerVulnerabilityAssessmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
