/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SentinelAutomationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#condition_json SentinelAutomationRule#condition_json}
    */
    readonly conditionJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#display_name SentinelAutomationRule#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#enabled SentinelAutomationRule#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#expiration SentinelAutomationRule#expiration}
    */
    readonly expiration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#id SentinelAutomationRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#log_analytics_workspace_id SentinelAutomationRule#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#name SentinelAutomationRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#order SentinelAutomationRule#order}
    */
    readonly order: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#triggers_on SentinelAutomationRule#triggers_on}
    */
    readonly triggersOn?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#triggers_when SentinelAutomationRule#triggers_when}
    */
    readonly triggersWhen?: string;
    /**
    * action_incident block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#action_incident SentinelAutomationRule#action_incident}
    */
    readonly actionIncident?: SentinelAutomationRuleActionIncident[] | cdktf.IResolvable;
    /**
    * action_playbook block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#action_playbook SentinelAutomationRule#action_playbook}
    */
    readonly actionPlaybook?: SentinelAutomationRuleActionPlaybook[] | cdktf.IResolvable;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#condition SentinelAutomationRule#condition}
    */
    readonly condition?: SentinelAutomationRuleCondition[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#timeouts SentinelAutomationRule#timeouts}
    */
    readonly timeouts?: SentinelAutomationRuleTimeouts;
}
export interface SentinelAutomationRuleActionIncident {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#classification SentinelAutomationRule#classification}
    */
    readonly classification?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#classification_comment SentinelAutomationRule#classification_comment}
    */
    readonly classificationComment?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#labels SentinelAutomationRule#labels}
    */
    readonly labels?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#order SentinelAutomationRule#order}
    */
    readonly order: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#owner_id SentinelAutomationRule#owner_id}
    */
    readonly ownerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#severity SentinelAutomationRule#severity}
    */
    readonly severity?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#status SentinelAutomationRule#status}
    */
    readonly status?: string;
}
export declare function sentinelAutomationRuleActionIncidentToTerraform(struct?: SentinelAutomationRuleActionIncident | cdktf.IResolvable): any;
export declare function sentinelAutomationRuleActionIncidentToHclTerraform(struct?: SentinelAutomationRuleActionIncident | cdktf.IResolvable): any;
export declare class SentinelAutomationRuleActionIncidentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAutomationRuleActionIncident | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAutomationRuleActionIncident | cdktf.IResolvable | undefined);
    private _classification?;
    get classification(): string;
    set classification(value: string);
    resetClassification(): void;
    get classificationInput(): string | undefined;
    private _classificationComment?;
    get classificationComment(): string;
    set classificationComment(value: string);
    resetClassificationComment(): void;
    get classificationCommentInput(): string | undefined;
    private _labels?;
    get labels(): string[];
    set labels(value: string[]);
    resetLabels(): void;
    get labelsInput(): string[] | undefined;
    private _order?;
    get order(): number;
    set order(value: number);
    get orderInput(): number | undefined;
    private _ownerId?;
    get ownerId(): string;
    set ownerId(value: string);
    resetOwnerId(): void;
    get ownerIdInput(): string | undefined;
    private _severity?;
    get severity(): string;
    set severity(value: string);
    resetSeverity(): void;
    get severityInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
}
export declare class SentinelAutomationRuleActionIncidentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAutomationRuleActionIncident[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAutomationRuleActionIncidentOutputReference;
}
export interface SentinelAutomationRuleActionPlaybook {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#logic_app_id SentinelAutomationRule#logic_app_id}
    */
    readonly logicAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#order SentinelAutomationRule#order}
    */
    readonly order: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#tenant_id SentinelAutomationRule#tenant_id}
    */
    readonly tenantId?: string;
}
export declare function sentinelAutomationRuleActionPlaybookToTerraform(struct?: SentinelAutomationRuleActionPlaybook | cdktf.IResolvable): any;
export declare function sentinelAutomationRuleActionPlaybookToHclTerraform(struct?: SentinelAutomationRuleActionPlaybook | cdktf.IResolvable): any;
export declare class SentinelAutomationRuleActionPlaybookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAutomationRuleActionPlaybook | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAutomationRuleActionPlaybook | cdktf.IResolvable | undefined);
    private _logicAppId?;
    get logicAppId(): string;
    set logicAppId(value: string);
    get logicAppIdInput(): string | undefined;
    private _order?;
    get order(): number;
    set order(value: number);
    get orderInput(): number | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
}
export declare class SentinelAutomationRuleActionPlaybookList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAutomationRuleActionPlaybook[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAutomationRuleActionPlaybookOutputReference;
}
export interface SentinelAutomationRuleCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#operator SentinelAutomationRule#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#property SentinelAutomationRule#property}
    */
    readonly property: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#values SentinelAutomationRule#values}
    */
    readonly values: string[];
}
export declare function sentinelAutomationRuleConditionToTerraform(struct?: SentinelAutomationRuleCondition | cdktf.IResolvable): any;
export declare function sentinelAutomationRuleConditionToHclTerraform(struct?: SentinelAutomationRuleCondition | cdktf.IResolvable): any;
export declare class SentinelAutomationRuleConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAutomationRuleCondition | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAutomationRuleCondition | cdktf.IResolvable | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _property?;
    get property(): string;
    set property(value: string);
    get propertyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class SentinelAutomationRuleConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAutomationRuleCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAutomationRuleConditionOutputReference;
}
export interface SentinelAutomationRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#create SentinelAutomationRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#delete SentinelAutomationRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#read SentinelAutomationRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#update SentinelAutomationRule#update}
    */
    readonly update?: string;
}
export declare function sentinelAutomationRuleTimeoutsToTerraform(struct?: SentinelAutomationRuleTimeouts | cdktf.IResolvable): any;
export declare function sentinelAutomationRuleTimeoutsToHclTerraform(struct?: SentinelAutomationRuleTimeouts | cdktf.IResolvable): any;
export declare class SentinelAutomationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelAutomationRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAutomationRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule azurerm_sentinel_automation_rule}
*/
export declare class SentinelAutomationRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_sentinel_automation_rule";
    /**
    * Generates CDKTF code for importing a SentinelAutomationRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SentinelAutomationRule to import
    * @param importFromId The id of the existing SentinelAutomationRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SentinelAutomationRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/sentinel_automation_rule azurerm_sentinel_automation_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SentinelAutomationRuleConfig
    */
    constructor(scope: Construct, id: string, config: SentinelAutomationRuleConfig);
    private _conditionJson?;
    get conditionJson(): string;
    set conditionJson(value: string);
    resetConditionJson(): void;
    get conditionJsonInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _expiration?;
    get expiration(): string;
    set expiration(value: string);
    resetExpiration(): void;
    get expirationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _order?;
    get order(): number;
    set order(value: number);
    get orderInput(): number | undefined;
    private _triggersOn?;
    get triggersOn(): string;
    set triggersOn(value: string);
    resetTriggersOn(): void;
    get triggersOnInput(): string | undefined;
    private _triggersWhen?;
    get triggersWhen(): string;
    set triggersWhen(value: string);
    resetTriggersWhen(): void;
    get triggersWhenInput(): string | undefined;
    private _actionIncident;
    get actionIncident(): SentinelAutomationRuleActionIncidentList;
    putActionIncident(value: SentinelAutomationRuleActionIncident[] | cdktf.IResolvable): void;
    resetActionIncident(): void;
    get actionIncidentInput(): cdktf.IResolvable | SentinelAutomationRuleActionIncident[] | undefined;
    private _actionPlaybook;
    get actionPlaybook(): SentinelAutomationRuleActionPlaybookList;
    putActionPlaybook(value: SentinelAutomationRuleActionPlaybook[] | cdktf.IResolvable): void;
    resetActionPlaybook(): void;
    get actionPlaybookInput(): cdktf.IResolvable | SentinelAutomationRuleActionPlaybook[] | undefined;
    private _condition;
    get condition(): SentinelAutomationRuleConditionList;
    putCondition(value: SentinelAutomationRuleCondition[] | cdktf.IResolvable): void;
    resetCondition(): void;
    get conditionInput(): cdktf.IResolvable | SentinelAutomationRuleCondition[] | undefined;
    private _timeouts;
    get timeouts(): SentinelAutomationRuleTimeoutsOutputReference;
    putTimeouts(value: SentinelAutomationRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SentinelAutomationRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
