/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#build_agent_pool_size SpringCloudService#build_agent_pool_size}
    */
    readonly buildAgentPoolSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#id SpringCloudService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#location SpringCloudService#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#log_stream_public_endpoint_enabled SpringCloudService#log_stream_public_endpoint_enabled}
    */
    readonly logStreamPublicEndpointEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#managed_environment_id SpringCloudService#managed_environment_id}
    */
    readonly managedEnvironmentId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#name SpringCloudService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#resource_group_name SpringCloudService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#service_registry_enabled SpringCloudService#service_registry_enabled}
    */
    readonly serviceRegistryEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#sku_name SpringCloudService#sku_name}
    */
    readonly skuName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#sku_tier SpringCloudService#sku_tier}
    */
    readonly skuTier?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#tags SpringCloudService#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#zone_redundant SpringCloudService#zone_redundant}
    */
    readonly zoneRedundant?: boolean | cdktf.IResolvable;
    /**
    * config_server_git_setting block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#config_server_git_setting SpringCloudService#config_server_git_setting}
    */
    readonly configServerGitSetting?: SpringCloudServiceConfigServerGitSetting;
    /**
    * container_registry block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#container_registry SpringCloudService#container_registry}
    */
    readonly containerRegistry?: SpringCloudServiceContainerRegistry[] | cdktf.IResolvable;
    /**
    * default_build_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#default_build_service SpringCloudService#default_build_service}
    */
    readonly defaultBuildService?: SpringCloudServiceDefaultBuildService;
    /**
    * marketplace block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#marketplace SpringCloudService#marketplace}
    */
    readonly marketplace?: SpringCloudServiceMarketplace;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#network SpringCloudService#network}
    */
    readonly network?: SpringCloudServiceNetwork;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#timeouts SpringCloudService#timeouts}
    */
    readonly timeouts?: SpringCloudServiceTimeouts;
    /**
    * trace block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#trace SpringCloudService#trace}
    */
    readonly trace?: SpringCloudServiceTrace;
}
export interface SpringCloudServiceRequiredNetworkTrafficRules {
}
export declare function springCloudServiceRequiredNetworkTrafficRulesToTerraform(struct?: SpringCloudServiceRequiredNetworkTrafficRules): any;
export declare function springCloudServiceRequiredNetworkTrafficRulesToHclTerraform(struct?: SpringCloudServiceRequiredNetworkTrafficRules): any;
export declare class SpringCloudServiceRequiredNetworkTrafficRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SpringCloudServiceRequiredNetworkTrafficRules | undefined;
    set internalValue(value: SpringCloudServiceRequiredNetworkTrafficRules | undefined);
    get direction(): string;
    get fqdns(): string[];
    get ipAddresses(): string[];
    get port(): number;
    get protocol(): string;
}
export declare class SpringCloudServiceRequiredNetworkTrafficRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SpringCloudServiceRequiredNetworkTrafficRulesOutputReference;
}
export interface SpringCloudServiceConfigServerGitSettingHttpBasicAuth {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#password SpringCloudService#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#username SpringCloudService#username}
    */
    readonly username: string;
}
export declare function springCloudServiceConfigServerGitSettingHttpBasicAuthToTerraform(struct?: SpringCloudServiceConfigServerGitSettingHttpBasicAuthOutputReference | SpringCloudServiceConfigServerGitSettingHttpBasicAuth): any;
export declare function springCloudServiceConfigServerGitSettingHttpBasicAuthToHclTerraform(struct?: SpringCloudServiceConfigServerGitSettingHttpBasicAuthOutputReference | SpringCloudServiceConfigServerGitSettingHttpBasicAuth): any;
export declare class SpringCloudServiceConfigServerGitSettingHttpBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudServiceConfigServerGitSettingHttpBasicAuth | undefined;
    set internalValue(value: SpringCloudServiceConfigServerGitSettingHttpBasicAuth | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#password SpringCloudService#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#username SpringCloudService#username}
    */
    readonly username: string;
}
export declare function springCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthToTerraform(struct?: SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthOutputReference | SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth): any;
export declare function springCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthToHclTerraform(struct?: SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthOutputReference | SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth): any;
export declare class SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth | undefined;
    set internalValue(value: SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface SpringCloudServiceConfigServerGitSettingRepositorySshAuth {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#host_key SpringCloudService#host_key}
    */
    readonly hostKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#host_key_algorithm SpringCloudService#host_key_algorithm}
    */
    readonly hostKeyAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#private_key SpringCloudService#private_key}
    */
    readonly privateKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#strict_host_key_checking_enabled SpringCloudService#strict_host_key_checking_enabled}
    */
    readonly strictHostKeyCheckingEnabled?: boolean | cdktf.IResolvable;
}
export declare function springCloudServiceConfigServerGitSettingRepositorySshAuthToTerraform(struct?: SpringCloudServiceConfigServerGitSettingRepositorySshAuthOutputReference | SpringCloudServiceConfigServerGitSettingRepositorySshAuth): any;
export declare function springCloudServiceConfigServerGitSettingRepositorySshAuthToHclTerraform(struct?: SpringCloudServiceConfigServerGitSettingRepositorySshAuthOutputReference | SpringCloudServiceConfigServerGitSettingRepositorySshAuth): any;
export declare class SpringCloudServiceConfigServerGitSettingRepositorySshAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudServiceConfigServerGitSettingRepositorySshAuth | undefined;
    set internalValue(value: SpringCloudServiceConfigServerGitSettingRepositorySshAuth | undefined);
    private _hostKey?;
    get hostKey(): string;
    set hostKey(value: string);
    resetHostKey(): void;
    get hostKeyInput(): string | undefined;
    private _hostKeyAlgorithm?;
    get hostKeyAlgorithm(): string;
    set hostKeyAlgorithm(value: string);
    resetHostKeyAlgorithm(): void;
    get hostKeyAlgorithmInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    get privateKeyInput(): string | undefined;
    private _strictHostKeyCheckingEnabled?;
    get strictHostKeyCheckingEnabled(): boolean | cdktf.IResolvable;
    set strictHostKeyCheckingEnabled(value: boolean | cdktf.IResolvable);
    resetStrictHostKeyCheckingEnabled(): void;
    get strictHostKeyCheckingEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SpringCloudServiceConfigServerGitSettingRepository {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#label SpringCloudService#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#name SpringCloudService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#pattern SpringCloudService#pattern}
    */
    readonly pattern?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#search_paths SpringCloudService#search_paths}
    */
    readonly searchPaths?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#uri SpringCloudService#uri}
    */
    readonly uri: string;
    /**
    * http_basic_auth block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#http_basic_auth SpringCloudService#http_basic_auth}
    */
    readonly httpBasicAuth?: SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth;
    /**
    * ssh_auth block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#ssh_auth SpringCloudService#ssh_auth}
    */
    readonly sshAuth?: SpringCloudServiceConfigServerGitSettingRepositorySshAuth;
}
export declare function springCloudServiceConfigServerGitSettingRepositoryToTerraform(struct?: SpringCloudServiceConfigServerGitSettingRepository | cdktf.IResolvable): any;
export declare function springCloudServiceConfigServerGitSettingRepositoryToHclTerraform(struct?: SpringCloudServiceConfigServerGitSettingRepository | cdktf.IResolvable): any;
export declare class SpringCloudServiceConfigServerGitSettingRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SpringCloudServiceConfigServerGitSettingRepository | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudServiceConfigServerGitSettingRepository | cdktf.IResolvable | undefined);
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pattern?;
    get pattern(): string[];
    set pattern(value: string[]);
    resetPattern(): void;
    get patternInput(): string[] | undefined;
    private _searchPaths?;
    get searchPaths(): string[];
    set searchPaths(value: string[]);
    resetSearchPaths(): void;
    get searchPathsInput(): string[] | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
    private _httpBasicAuth;
    get httpBasicAuth(): SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthOutputReference;
    putHttpBasicAuth(value: SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth): void;
    resetHttpBasicAuth(): void;
    get httpBasicAuthInput(): SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth | undefined;
    private _sshAuth;
    get sshAuth(): SpringCloudServiceConfigServerGitSettingRepositorySshAuthOutputReference;
    putSshAuth(value: SpringCloudServiceConfigServerGitSettingRepositorySshAuth): void;
    resetSshAuth(): void;
    get sshAuthInput(): SpringCloudServiceConfigServerGitSettingRepositorySshAuth | undefined;
}
export declare class SpringCloudServiceConfigServerGitSettingRepositoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SpringCloudServiceConfigServerGitSettingRepository[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SpringCloudServiceConfigServerGitSettingRepositoryOutputReference;
}
export interface SpringCloudServiceConfigServerGitSettingSshAuth {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#host_key SpringCloudService#host_key}
    */
    readonly hostKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#host_key_algorithm SpringCloudService#host_key_algorithm}
    */
    readonly hostKeyAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#private_key SpringCloudService#private_key}
    */
    readonly privateKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#strict_host_key_checking_enabled SpringCloudService#strict_host_key_checking_enabled}
    */
    readonly strictHostKeyCheckingEnabled?: boolean | cdktf.IResolvable;
}
export declare function springCloudServiceConfigServerGitSettingSshAuthToTerraform(struct?: SpringCloudServiceConfigServerGitSettingSshAuthOutputReference | SpringCloudServiceConfigServerGitSettingSshAuth): any;
export declare function springCloudServiceConfigServerGitSettingSshAuthToHclTerraform(struct?: SpringCloudServiceConfigServerGitSettingSshAuthOutputReference | SpringCloudServiceConfigServerGitSettingSshAuth): any;
export declare class SpringCloudServiceConfigServerGitSettingSshAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudServiceConfigServerGitSettingSshAuth | undefined;
    set internalValue(value: SpringCloudServiceConfigServerGitSettingSshAuth | undefined);
    private _hostKey?;
    get hostKey(): string;
    set hostKey(value: string);
    resetHostKey(): void;
    get hostKeyInput(): string | undefined;
    private _hostKeyAlgorithm?;
    get hostKeyAlgorithm(): string;
    set hostKeyAlgorithm(value: string);
    resetHostKeyAlgorithm(): void;
    get hostKeyAlgorithmInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    get privateKeyInput(): string | undefined;
    private _strictHostKeyCheckingEnabled?;
    get strictHostKeyCheckingEnabled(): boolean | cdktf.IResolvable;
    set strictHostKeyCheckingEnabled(value: boolean | cdktf.IResolvable);
    resetStrictHostKeyCheckingEnabled(): void;
    get strictHostKeyCheckingEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SpringCloudServiceConfigServerGitSetting {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#label SpringCloudService#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#search_paths SpringCloudService#search_paths}
    */
    readonly searchPaths?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#uri SpringCloudService#uri}
    */
    readonly uri: string;
    /**
    * http_basic_auth block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#http_basic_auth SpringCloudService#http_basic_auth}
    */
    readonly httpBasicAuth?: SpringCloudServiceConfigServerGitSettingHttpBasicAuth;
    /**
    * repository block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#repository SpringCloudService#repository}
    */
    readonly repository?: SpringCloudServiceConfigServerGitSettingRepository[] | cdktf.IResolvable;
    /**
    * ssh_auth block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#ssh_auth SpringCloudService#ssh_auth}
    */
    readonly sshAuth?: SpringCloudServiceConfigServerGitSettingSshAuth;
}
export declare function springCloudServiceConfigServerGitSettingToTerraform(struct?: SpringCloudServiceConfigServerGitSettingOutputReference | SpringCloudServiceConfigServerGitSetting): any;
export declare function springCloudServiceConfigServerGitSettingToHclTerraform(struct?: SpringCloudServiceConfigServerGitSettingOutputReference | SpringCloudServiceConfigServerGitSetting): any;
export declare class SpringCloudServiceConfigServerGitSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudServiceConfigServerGitSetting | undefined;
    set internalValue(value: SpringCloudServiceConfigServerGitSetting | undefined);
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _searchPaths?;
    get searchPaths(): string[];
    set searchPaths(value: string[]);
    resetSearchPaths(): void;
    get searchPathsInput(): string[] | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
    private _httpBasicAuth;
    get httpBasicAuth(): SpringCloudServiceConfigServerGitSettingHttpBasicAuthOutputReference;
    putHttpBasicAuth(value: SpringCloudServiceConfigServerGitSettingHttpBasicAuth): void;
    resetHttpBasicAuth(): void;
    get httpBasicAuthInput(): SpringCloudServiceConfigServerGitSettingHttpBasicAuth | undefined;
    private _repository;
    get repository(): SpringCloudServiceConfigServerGitSettingRepositoryList;
    putRepository(value: SpringCloudServiceConfigServerGitSettingRepository[] | cdktf.IResolvable): void;
    resetRepository(): void;
    get repositoryInput(): cdktf.IResolvable | SpringCloudServiceConfigServerGitSettingRepository[] | undefined;
    private _sshAuth;
    get sshAuth(): SpringCloudServiceConfigServerGitSettingSshAuthOutputReference;
    putSshAuth(value: SpringCloudServiceConfigServerGitSettingSshAuth): void;
    resetSshAuth(): void;
    get sshAuthInput(): SpringCloudServiceConfigServerGitSettingSshAuth | undefined;
}
export interface SpringCloudServiceContainerRegistry {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#name SpringCloudService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#password SpringCloudService#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#server SpringCloudService#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#username SpringCloudService#username}
    */
    readonly username: string;
}
export declare function springCloudServiceContainerRegistryToTerraform(struct?: SpringCloudServiceContainerRegistry | cdktf.IResolvable): any;
export declare function springCloudServiceContainerRegistryToHclTerraform(struct?: SpringCloudServiceContainerRegistry | cdktf.IResolvable): any;
export declare class SpringCloudServiceContainerRegistryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SpringCloudServiceContainerRegistry | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudServiceContainerRegistry | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export declare class SpringCloudServiceContainerRegistryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SpringCloudServiceContainerRegistry[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SpringCloudServiceContainerRegistryOutputReference;
}
export interface SpringCloudServiceDefaultBuildService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#container_registry_name SpringCloudService#container_registry_name}
    */
    readonly containerRegistryName?: string;
}
export declare function springCloudServiceDefaultBuildServiceToTerraform(struct?: SpringCloudServiceDefaultBuildServiceOutputReference | SpringCloudServiceDefaultBuildService): any;
export declare function springCloudServiceDefaultBuildServiceToHclTerraform(struct?: SpringCloudServiceDefaultBuildServiceOutputReference | SpringCloudServiceDefaultBuildService): any;
export declare class SpringCloudServiceDefaultBuildServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudServiceDefaultBuildService | undefined;
    set internalValue(value: SpringCloudServiceDefaultBuildService | undefined);
    private _containerRegistryName?;
    get containerRegistryName(): string;
    set containerRegistryName(value: string);
    resetContainerRegistryName(): void;
    get containerRegistryNameInput(): string | undefined;
}
export interface SpringCloudServiceMarketplace {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#plan SpringCloudService#plan}
    */
    readonly plan: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#product SpringCloudService#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#publisher SpringCloudService#publisher}
    */
    readonly publisher: string;
}
export declare function springCloudServiceMarketplaceToTerraform(struct?: SpringCloudServiceMarketplaceOutputReference | SpringCloudServiceMarketplace): any;
export declare function springCloudServiceMarketplaceToHclTerraform(struct?: SpringCloudServiceMarketplaceOutputReference | SpringCloudServiceMarketplace): any;
export declare class SpringCloudServiceMarketplaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudServiceMarketplace | undefined;
    set internalValue(value: SpringCloudServiceMarketplace | undefined);
    private _plan?;
    get plan(): string;
    set plan(value: string);
    get planInput(): string | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
}
export interface SpringCloudServiceNetwork {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#app_network_resource_group SpringCloudService#app_network_resource_group}
    */
    readonly appNetworkResourceGroup?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#app_subnet_id SpringCloudService#app_subnet_id}
    */
    readonly appSubnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#cidr_ranges SpringCloudService#cidr_ranges}
    */
    readonly cidrRanges: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#outbound_type SpringCloudService#outbound_type}
    */
    readonly outboundType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#read_timeout_seconds SpringCloudService#read_timeout_seconds}
    */
    readonly readTimeoutSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#service_runtime_network_resource_group SpringCloudService#service_runtime_network_resource_group}
    */
    readonly serviceRuntimeNetworkResourceGroup?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#service_runtime_subnet_id SpringCloudService#service_runtime_subnet_id}
    */
    readonly serviceRuntimeSubnetId: string;
}
export declare function springCloudServiceNetworkToTerraform(struct?: SpringCloudServiceNetworkOutputReference | SpringCloudServiceNetwork): any;
export declare function springCloudServiceNetworkToHclTerraform(struct?: SpringCloudServiceNetworkOutputReference | SpringCloudServiceNetwork): any;
export declare class SpringCloudServiceNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudServiceNetwork | undefined;
    set internalValue(value: SpringCloudServiceNetwork | undefined);
    private _appNetworkResourceGroup?;
    get appNetworkResourceGroup(): string;
    set appNetworkResourceGroup(value: string);
    resetAppNetworkResourceGroup(): void;
    get appNetworkResourceGroupInput(): string | undefined;
    private _appSubnetId?;
    get appSubnetId(): string;
    set appSubnetId(value: string);
    get appSubnetIdInput(): string | undefined;
    private _cidrRanges?;
    get cidrRanges(): string[];
    set cidrRanges(value: string[]);
    get cidrRangesInput(): string[] | undefined;
    private _outboundType?;
    get outboundType(): string;
    set outboundType(value: string);
    resetOutboundType(): void;
    get outboundTypeInput(): string | undefined;
    private _readTimeoutSeconds?;
    get readTimeoutSeconds(): number;
    set readTimeoutSeconds(value: number);
    resetReadTimeoutSeconds(): void;
    get readTimeoutSecondsInput(): number | undefined;
    private _serviceRuntimeNetworkResourceGroup?;
    get serviceRuntimeNetworkResourceGroup(): string;
    set serviceRuntimeNetworkResourceGroup(value: string);
    resetServiceRuntimeNetworkResourceGroup(): void;
    get serviceRuntimeNetworkResourceGroupInput(): string | undefined;
    private _serviceRuntimeSubnetId?;
    get serviceRuntimeSubnetId(): string;
    set serviceRuntimeSubnetId(value: string);
    get serviceRuntimeSubnetIdInput(): string | undefined;
}
export interface SpringCloudServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#create SpringCloudService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#delete SpringCloudService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#read SpringCloudService#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#update SpringCloudService#update}
    */
    readonly update?: string;
}
export declare function springCloudServiceTimeoutsToTerraform(struct?: SpringCloudServiceTimeouts | cdktf.IResolvable): any;
export declare function springCloudServiceTimeoutsToHclTerraform(struct?: SpringCloudServiceTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface SpringCloudServiceTrace {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#connection_string SpringCloudService#connection_string}
    */
    readonly connectionString?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#sample_rate SpringCloudService#sample_rate}
    */
    readonly sampleRate?: number;
}
export declare function springCloudServiceTraceToTerraform(struct?: SpringCloudServiceTraceOutputReference | SpringCloudServiceTrace): any;
export declare function springCloudServiceTraceToHclTerraform(struct?: SpringCloudServiceTraceOutputReference | SpringCloudServiceTrace): any;
export declare class SpringCloudServiceTraceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudServiceTrace | undefined;
    set internalValue(value: SpringCloudServiceTrace | undefined);
    private _connectionString?;
    get connectionString(): string;
    set connectionString(value: string);
    resetConnectionString(): void;
    get connectionStringInput(): string | undefined;
    private _sampleRate?;
    get sampleRate(): number;
    set sampleRate(value: number);
    resetSampleRate(): void;
    get sampleRateInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service azurerm_spring_cloud_service}
*/
export declare class SpringCloudService extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_spring_cloud_service";
    /**
    * Generates CDKTF code for importing a SpringCloudService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SpringCloudService to import
    * @param importFromId The id of the existing SpringCloudService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SpringCloudService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/spring_cloud_service azurerm_spring_cloud_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudServiceConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudServiceConfig);
    private _buildAgentPoolSize?;
    get buildAgentPoolSize(): string;
    set buildAgentPoolSize(value: string);
    resetBuildAgentPoolSize(): void;
    get buildAgentPoolSizeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _logStreamPublicEndpointEnabled?;
    get logStreamPublicEndpointEnabled(): boolean | cdktf.IResolvable;
    set logStreamPublicEndpointEnabled(value: boolean | cdktf.IResolvable);
    resetLogStreamPublicEndpointEnabled(): void;
    get logStreamPublicEndpointEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _managedEnvironmentId?;
    get managedEnvironmentId(): string;
    set managedEnvironmentId(value: string);
    resetManagedEnvironmentId(): void;
    get managedEnvironmentIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundPublicIpAddresses(): string[];
    private _requiredNetworkTrafficRules;
    get requiredNetworkTrafficRules(): SpringCloudServiceRequiredNetworkTrafficRulesList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serviceRegistryEnabled?;
    get serviceRegistryEnabled(): boolean | cdktf.IResolvable;
    set serviceRegistryEnabled(value: boolean | cdktf.IResolvable);
    resetServiceRegistryEnabled(): void;
    get serviceRegistryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get serviceRegistryId(): string;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    resetSkuName(): void;
    get skuNameInput(): string | undefined;
    private _skuTier?;
    get skuTier(): string;
    set skuTier(value: string);
    resetSkuTier(): void;
    get skuTierInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zoneRedundant?;
    get zoneRedundant(): boolean | cdktf.IResolvable;
    set zoneRedundant(value: boolean | cdktf.IResolvable);
    resetZoneRedundant(): void;
    get zoneRedundantInput(): boolean | cdktf.IResolvable | undefined;
    private _configServerGitSetting;
    get configServerGitSetting(): SpringCloudServiceConfigServerGitSettingOutputReference;
    putConfigServerGitSetting(value: SpringCloudServiceConfigServerGitSetting): void;
    resetConfigServerGitSetting(): void;
    get configServerGitSettingInput(): SpringCloudServiceConfigServerGitSetting | undefined;
    private _containerRegistry;
    get containerRegistry(): SpringCloudServiceContainerRegistryList;
    putContainerRegistry(value: SpringCloudServiceContainerRegistry[] | cdktf.IResolvable): void;
    resetContainerRegistry(): void;
    get containerRegistryInput(): cdktf.IResolvable | SpringCloudServiceContainerRegistry[] | undefined;
    private _defaultBuildService;
    get defaultBuildService(): SpringCloudServiceDefaultBuildServiceOutputReference;
    putDefaultBuildService(value: SpringCloudServiceDefaultBuildService): void;
    resetDefaultBuildService(): void;
    get defaultBuildServiceInput(): SpringCloudServiceDefaultBuildService | undefined;
    private _marketplace;
    get marketplace(): SpringCloudServiceMarketplaceOutputReference;
    putMarketplace(value: SpringCloudServiceMarketplace): void;
    resetMarketplace(): void;
    get marketplaceInput(): SpringCloudServiceMarketplace | undefined;
    private _network;
    get network(): SpringCloudServiceNetworkOutputReference;
    putNetwork(value: SpringCloudServiceNetwork): void;
    resetNetwork(): void;
    get networkInput(): SpringCloudServiceNetwork | undefined;
    private _timeouts;
    get timeouts(): SpringCloudServiceTimeoutsOutputReference;
    putTimeouts(value: SpringCloudServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SpringCloudServiceTimeouts | undefined;
    private _trace;
    get trace(): SpringCloudServiceTraceOutputReference;
    putTrace(value: SpringCloudServiceTrace): void;
    resetTrace(): void;
    get traceInput(): SpringCloudServiceTrace | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
