/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageMoverJobDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition#agent_name StorageMoverJobDefinition#agent_name}
    */
    readonly agentName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition#copy_mode StorageMoverJobDefinition#copy_mode}
    */
    readonly copyMode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition#description StorageMoverJobDefinition#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition#id StorageMoverJobDefinition#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition#name StorageMoverJobDefinition#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition#source_name StorageMoverJobDefinition#source_name}
    */
    readonly sourceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition#source_sub_path StorageMoverJobDefinition#source_sub_path}
    */
    readonly sourceSubPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition#storage_mover_project_id StorageMoverJobDefinition#storage_mover_project_id}
    */
    readonly storageMoverProjectId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition#target_name StorageMoverJobDefinition#target_name}
    */
    readonly targetName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition#target_sub_path StorageMoverJobDefinition#target_sub_path}
    */
    readonly targetSubPath?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition#timeouts StorageMoverJobDefinition#timeouts}
    */
    readonly timeouts?: StorageMoverJobDefinitionTimeouts;
}
export interface StorageMoverJobDefinitionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition#create StorageMoverJobDefinition#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition#delete StorageMoverJobDefinition#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition#read StorageMoverJobDefinition#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition#update StorageMoverJobDefinition#update}
    */
    readonly update?: string;
}
export declare function storageMoverJobDefinitionTimeoutsToTerraform(struct?: StorageMoverJobDefinitionTimeouts | cdktf.IResolvable): any;
export declare function storageMoverJobDefinitionTimeoutsToHclTerraform(struct?: StorageMoverJobDefinitionTimeouts | cdktf.IResolvable): any;
export declare class StorageMoverJobDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageMoverJobDefinitionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageMoverJobDefinitionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition azurerm_storage_mover_job_definition}
*/
export declare class StorageMoverJobDefinition extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_mover_job_definition";
    /**
    * Generates CDKTF code for importing a StorageMoverJobDefinition resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageMoverJobDefinition to import
    * @param importFromId The id of the existing StorageMoverJobDefinition that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageMoverJobDefinition to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/storage_mover_job_definition azurerm_storage_mover_job_definition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageMoverJobDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: StorageMoverJobDefinitionConfig);
    private _agentName?;
    get agentName(): string;
    set agentName(value: string);
    resetAgentName(): void;
    get agentNameInput(): string | undefined;
    private _copyMode?;
    get copyMode(): string;
    set copyMode(value: string);
    get copyModeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sourceName?;
    get sourceName(): string;
    set sourceName(value: string);
    get sourceNameInput(): string | undefined;
    private _sourceSubPath?;
    get sourceSubPath(): string;
    set sourceSubPath(value: string);
    resetSourceSubPath(): void;
    get sourceSubPathInput(): string | undefined;
    private _storageMoverProjectId?;
    get storageMoverProjectId(): string;
    set storageMoverProjectId(value: string);
    get storageMoverProjectIdInput(): string | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    get targetNameInput(): string | undefined;
    private _targetSubPath?;
    get targetSubPath(): string;
    set targetSubPath(value: string);
    resetTargetSubPath(): void;
    get targetSubPathInput(): string | undefined;
    private _timeouts;
    get timeouts(): StorageMoverJobDefinitionTimeoutsOutputReference;
    putTimeouts(value: StorageMoverJobDefinitionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageMoverJobDefinitionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
