/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SynapseWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#aad_admin SynapseWorkspace#aad_admin}
    */
    readonly aadAdmin?: SynapseWorkspaceAadAdmin[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#azuread_authentication_only SynapseWorkspace#azuread_authentication_only}
    */
    readonly azureadAuthenticationOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#compute_subnet_id SynapseWorkspace#compute_subnet_id}
    */
    readonly computeSubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#data_exfiltration_protection_enabled SynapseWorkspace#data_exfiltration_protection_enabled}
    */
    readonly dataExfiltrationProtectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#id SynapseWorkspace#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#linking_allowed_for_aad_tenant_ids SynapseWorkspace#linking_allowed_for_aad_tenant_ids}
    */
    readonly linkingAllowedForAadTenantIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#location SynapseWorkspace#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#managed_resource_group_name SynapseWorkspace#managed_resource_group_name}
    */
    readonly managedResourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#managed_virtual_network_enabled SynapseWorkspace#managed_virtual_network_enabled}
    */
    readonly managedVirtualNetworkEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#name SynapseWorkspace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#public_network_access_enabled SynapseWorkspace#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#purview_id SynapseWorkspace#purview_id}
    */
    readonly purviewId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#resource_group_name SynapseWorkspace#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#sql_aad_admin SynapseWorkspace#sql_aad_admin}
    */
    readonly sqlAadAdmin?: SynapseWorkspaceSqlAadAdmin[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#sql_administrator_login SynapseWorkspace#sql_administrator_login}
    */
    readonly sqlAdministratorLogin?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#sql_administrator_login_password SynapseWorkspace#sql_administrator_login_password}
    */
    readonly sqlAdministratorLoginPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#sql_identity_control_enabled SynapseWorkspace#sql_identity_control_enabled}
    */
    readonly sqlIdentityControlEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#storage_data_lake_gen2_filesystem_id SynapseWorkspace#storage_data_lake_gen2_filesystem_id}
    */
    readonly storageDataLakeGen2FilesystemId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#tags SynapseWorkspace#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * azure_devops_repo block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#azure_devops_repo SynapseWorkspace#azure_devops_repo}
    */
    readonly azureDevopsRepo?: SynapseWorkspaceAzureDevopsRepo;
    /**
    * customer_managed_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#customer_managed_key SynapseWorkspace#customer_managed_key}
    */
    readonly customerManagedKey?: SynapseWorkspaceCustomerManagedKey;
    /**
    * github_repo block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#github_repo SynapseWorkspace#github_repo}
    */
    readonly githubRepo?: SynapseWorkspaceGithubRepo;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#identity SynapseWorkspace#identity}
    */
    readonly identity?: SynapseWorkspaceIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#timeouts SynapseWorkspace#timeouts}
    */
    readonly timeouts?: SynapseWorkspaceTimeouts;
}
export interface SynapseWorkspaceAadAdmin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#login SynapseWorkspace#login}
    */
    readonly login?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#object_id SynapseWorkspace#object_id}
    */
    readonly objectId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#tenant_id SynapseWorkspace#tenant_id}
    */
    readonly tenantId?: string;
}
export declare function synapseWorkspaceAadAdminToTerraform(struct?: SynapseWorkspaceAadAdmin | cdktf.IResolvable): any;
export declare function synapseWorkspaceAadAdminToHclTerraform(struct?: SynapseWorkspaceAadAdmin | cdktf.IResolvable): any;
export declare class SynapseWorkspaceAadAdminOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SynapseWorkspaceAadAdmin | cdktf.IResolvable | undefined;
    set internalValue(value: SynapseWorkspaceAadAdmin | cdktf.IResolvable | undefined);
    private _login?;
    get login(): string;
    set login(value: string);
    resetLogin(): void;
    get loginInput(): string | undefined;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    resetObjectId(): void;
    get objectIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
}
export declare class SynapseWorkspaceAadAdminList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SynapseWorkspaceAadAdmin[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SynapseWorkspaceAadAdminOutputReference;
}
export interface SynapseWorkspaceSqlAadAdmin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#login SynapseWorkspace#login}
    */
    readonly login?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#object_id SynapseWorkspace#object_id}
    */
    readonly objectId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#tenant_id SynapseWorkspace#tenant_id}
    */
    readonly tenantId?: string;
}
export declare function synapseWorkspaceSqlAadAdminToTerraform(struct?: SynapseWorkspaceSqlAadAdmin | cdktf.IResolvable): any;
export declare function synapseWorkspaceSqlAadAdminToHclTerraform(struct?: SynapseWorkspaceSqlAadAdmin | cdktf.IResolvable): any;
export declare class SynapseWorkspaceSqlAadAdminOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SynapseWorkspaceSqlAadAdmin | cdktf.IResolvable | undefined;
    set internalValue(value: SynapseWorkspaceSqlAadAdmin | cdktf.IResolvable | undefined);
    private _login?;
    get login(): string;
    set login(value: string);
    resetLogin(): void;
    get loginInput(): string | undefined;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    resetObjectId(): void;
    get objectIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
}
export declare class SynapseWorkspaceSqlAadAdminList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SynapseWorkspaceSqlAadAdmin[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SynapseWorkspaceSqlAadAdminOutputReference;
}
export interface SynapseWorkspaceAzureDevopsRepo {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#account_name SynapseWorkspace#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#branch_name SynapseWorkspace#branch_name}
    */
    readonly branchName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#last_commit_id SynapseWorkspace#last_commit_id}
    */
    readonly lastCommitId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#project_name SynapseWorkspace#project_name}
    */
    readonly projectName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#repository_name SynapseWorkspace#repository_name}
    */
    readonly repositoryName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#root_folder SynapseWorkspace#root_folder}
    */
    readonly rootFolder: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#tenant_id SynapseWorkspace#tenant_id}
    */
    readonly tenantId?: string;
}
export declare function synapseWorkspaceAzureDevopsRepoToTerraform(struct?: SynapseWorkspaceAzureDevopsRepoOutputReference | SynapseWorkspaceAzureDevopsRepo): any;
export declare function synapseWorkspaceAzureDevopsRepoToHclTerraform(struct?: SynapseWorkspaceAzureDevopsRepoOutputReference | SynapseWorkspaceAzureDevopsRepo): any;
export declare class SynapseWorkspaceAzureDevopsRepoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseWorkspaceAzureDevopsRepo | undefined;
    set internalValue(value: SynapseWorkspaceAzureDevopsRepo | undefined);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _branchName?;
    get branchName(): string;
    set branchName(value: string);
    get branchNameInput(): string | undefined;
    private _lastCommitId?;
    get lastCommitId(): string;
    set lastCommitId(value: string);
    resetLastCommitId(): void;
    get lastCommitIdInput(): string | undefined;
    private _projectName?;
    get projectName(): string;
    set projectName(value: string);
    get projectNameInput(): string | undefined;
    private _repositoryName?;
    get repositoryName(): string;
    set repositoryName(value: string);
    get repositoryNameInput(): string | undefined;
    private _rootFolder?;
    get rootFolder(): string;
    set rootFolder(value: string);
    get rootFolderInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
}
export interface SynapseWorkspaceCustomerManagedKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#key_name SynapseWorkspace#key_name}
    */
    readonly keyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#key_versionless_id SynapseWorkspace#key_versionless_id}
    */
    readonly keyVersionlessId: string;
}
export declare function synapseWorkspaceCustomerManagedKeyToTerraform(struct?: SynapseWorkspaceCustomerManagedKeyOutputReference | SynapseWorkspaceCustomerManagedKey): any;
export declare function synapseWorkspaceCustomerManagedKeyToHclTerraform(struct?: SynapseWorkspaceCustomerManagedKeyOutputReference | SynapseWorkspaceCustomerManagedKey): any;
export declare class SynapseWorkspaceCustomerManagedKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseWorkspaceCustomerManagedKey | undefined;
    set internalValue(value: SynapseWorkspaceCustomerManagedKey | undefined);
    private _keyName?;
    get keyName(): string;
    set keyName(value: string);
    resetKeyName(): void;
    get keyNameInput(): string | undefined;
    private _keyVersionlessId?;
    get keyVersionlessId(): string;
    set keyVersionlessId(value: string);
    get keyVersionlessIdInput(): string | undefined;
}
export interface SynapseWorkspaceGithubRepo {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#account_name SynapseWorkspace#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#branch_name SynapseWorkspace#branch_name}
    */
    readonly branchName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#git_url SynapseWorkspace#git_url}
    */
    readonly gitUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#last_commit_id SynapseWorkspace#last_commit_id}
    */
    readonly lastCommitId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#repository_name SynapseWorkspace#repository_name}
    */
    readonly repositoryName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#root_folder SynapseWorkspace#root_folder}
    */
    readonly rootFolder: string;
}
export declare function synapseWorkspaceGithubRepoToTerraform(struct?: SynapseWorkspaceGithubRepoOutputReference | SynapseWorkspaceGithubRepo): any;
export declare function synapseWorkspaceGithubRepoToHclTerraform(struct?: SynapseWorkspaceGithubRepoOutputReference | SynapseWorkspaceGithubRepo): any;
export declare class SynapseWorkspaceGithubRepoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseWorkspaceGithubRepo | undefined;
    set internalValue(value: SynapseWorkspaceGithubRepo | undefined);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _branchName?;
    get branchName(): string;
    set branchName(value: string);
    get branchNameInput(): string | undefined;
    private _gitUrl?;
    get gitUrl(): string;
    set gitUrl(value: string);
    resetGitUrl(): void;
    get gitUrlInput(): string | undefined;
    private _lastCommitId?;
    get lastCommitId(): string;
    set lastCommitId(value: string);
    resetLastCommitId(): void;
    get lastCommitIdInput(): string | undefined;
    private _repositoryName?;
    get repositoryName(): string;
    set repositoryName(value: string);
    get repositoryNameInput(): string | undefined;
    private _rootFolder?;
    get rootFolder(): string;
    set rootFolder(value: string);
    get rootFolderInput(): string | undefined;
}
export interface SynapseWorkspaceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#identity_ids SynapseWorkspace#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#type SynapseWorkspace#type}
    */
    readonly type: string;
}
export declare function synapseWorkspaceIdentityToTerraform(struct?: SynapseWorkspaceIdentityOutputReference | SynapseWorkspaceIdentity): any;
export declare function synapseWorkspaceIdentityToHclTerraform(struct?: SynapseWorkspaceIdentityOutputReference | SynapseWorkspaceIdentity): any;
export declare class SynapseWorkspaceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseWorkspaceIdentity | undefined;
    set internalValue(value: SynapseWorkspaceIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface SynapseWorkspaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#create SynapseWorkspace#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#delete SynapseWorkspace#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#read SynapseWorkspace#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#update SynapseWorkspace#update}
    */
    readonly update?: string;
}
export declare function synapseWorkspaceTimeoutsToTerraform(struct?: SynapseWorkspaceTimeouts | cdktf.IResolvable): any;
export declare function synapseWorkspaceTimeoutsToHclTerraform(struct?: SynapseWorkspaceTimeouts | cdktf.IResolvable): any;
export declare class SynapseWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseWorkspaceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SynapseWorkspaceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace azurerm_synapse_workspace}
*/
export declare class SynapseWorkspace extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_synapse_workspace";
    /**
    * Generates CDKTF code for importing a SynapseWorkspace resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SynapseWorkspace to import
    * @param importFromId The id of the existing SynapseWorkspace that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SynapseWorkspace to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/synapse_workspace azurerm_synapse_workspace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SynapseWorkspaceConfig
    */
    constructor(scope: Construct, id: string, config: SynapseWorkspaceConfig);
    private _aadAdmin;
    get aadAdmin(): SynapseWorkspaceAadAdminList;
    putAadAdmin(value: SynapseWorkspaceAadAdmin[] | cdktf.IResolvable): void;
    resetAadAdmin(): void;
    get aadAdminInput(): cdktf.IResolvable | SynapseWorkspaceAadAdmin[] | undefined;
    private _azureadAuthenticationOnly?;
    get azureadAuthenticationOnly(): boolean | cdktf.IResolvable;
    set azureadAuthenticationOnly(value: boolean | cdktf.IResolvable);
    resetAzureadAuthenticationOnly(): void;
    get azureadAuthenticationOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _computeSubnetId?;
    get computeSubnetId(): string;
    set computeSubnetId(value: string);
    resetComputeSubnetId(): void;
    get computeSubnetIdInput(): string | undefined;
    private _connectivityEndpoints;
    get connectivityEndpoints(): cdktf.StringMap;
    private _dataExfiltrationProtectionEnabled?;
    get dataExfiltrationProtectionEnabled(): boolean | cdktf.IResolvable;
    set dataExfiltrationProtectionEnabled(value: boolean | cdktf.IResolvable);
    resetDataExfiltrationProtectionEnabled(): void;
    get dataExfiltrationProtectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _linkingAllowedForAadTenantIds?;
    get linkingAllowedForAadTenantIds(): string[];
    set linkingAllowedForAadTenantIds(value: string[]);
    resetLinkingAllowedForAadTenantIds(): void;
    get linkingAllowedForAadTenantIdsInput(): string[] | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _managedResourceGroupName?;
    get managedResourceGroupName(): string;
    set managedResourceGroupName(value: string);
    resetManagedResourceGroupName(): void;
    get managedResourceGroupNameInput(): string | undefined;
    private _managedVirtualNetworkEnabled?;
    get managedVirtualNetworkEnabled(): boolean | cdktf.IResolvable;
    set managedVirtualNetworkEnabled(value: boolean | cdktf.IResolvable);
    resetManagedVirtualNetworkEnabled(): void;
    get managedVirtualNetworkEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _purviewId?;
    get purviewId(): string;
    set purviewId(value: string);
    resetPurviewId(): void;
    get purviewIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sqlAadAdmin;
    get sqlAadAdmin(): SynapseWorkspaceSqlAadAdminList;
    putSqlAadAdmin(value: SynapseWorkspaceSqlAadAdmin[] | cdktf.IResolvable): void;
    resetSqlAadAdmin(): void;
    get sqlAadAdminInput(): cdktf.IResolvable | SynapseWorkspaceSqlAadAdmin[] | undefined;
    private _sqlAdministratorLogin?;
    get sqlAdministratorLogin(): string;
    set sqlAdministratorLogin(value: string);
    resetSqlAdministratorLogin(): void;
    get sqlAdministratorLoginInput(): string | undefined;
    private _sqlAdministratorLoginPassword?;
    get sqlAdministratorLoginPassword(): string;
    set sqlAdministratorLoginPassword(value: string);
    resetSqlAdministratorLoginPassword(): void;
    get sqlAdministratorLoginPasswordInput(): string | undefined;
    private _sqlIdentityControlEnabled?;
    get sqlIdentityControlEnabled(): boolean | cdktf.IResolvable;
    set sqlIdentityControlEnabled(value: boolean | cdktf.IResolvable);
    resetSqlIdentityControlEnabled(): void;
    get sqlIdentityControlEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _storageDataLakeGen2FilesystemId?;
    get storageDataLakeGen2FilesystemId(): string;
    set storageDataLakeGen2FilesystemId(value: string);
    get storageDataLakeGen2FilesystemIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _azureDevopsRepo;
    get azureDevopsRepo(): SynapseWorkspaceAzureDevopsRepoOutputReference;
    putAzureDevopsRepo(value: SynapseWorkspaceAzureDevopsRepo): void;
    resetAzureDevopsRepo(): void;
    get azureDevopsRepoInput(): SynapseWorkspaceAzureDevopsRepo | undefined;
    private _customerManagedKey;
    get customerManagedKey(): SynapseWorkspaceCustomerManagedKeyOutputReference;
    putCustomerManagedKey(value: SynapseWorkspaceCustomerManagedKey): void;
    resetCustomerManagedKey(): void;
    get customerManagedKeyInput(): SynapseWorkspaceCustomerManagedKey | undefined;
    private _githubRepo;
    get githubRepo(): SynapseWorkspaceGithubRepoOutputReference;
    putGithubRepo(value: SynapseWorkspaceGithubRepo): void;
    resetGithubRepo(): void;
    get githubRepoInput(): SynapseWorkspaceGithubRepo | undefined;
    private _identity;
    get identity(): SynapseWorkspaceIdentityOutputReference;
    putIdentity(value: SynapseWorkspaceIdentity): void;
    resetIdentity(): void;
    get identityInput(): SynapseWorkspaceIdentity | undefined;
    private _timeouts;
    get timeouts(): SynapseWorkspaceTimeoutsOutputReference;
    putTimeouts(value: SynapseWorkspaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SynapseWorkspaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
