/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#bgp_route_translation_for_nat_enabled VpnGateway#bgp_route_translation_for_nat_enabled}
    */
    readonly bgpRouteTranslationForNatEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#id VpnGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#location VpnGateway#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#name VpnGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#resource_group_name VpnGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#routing_preference VpnGateway#routing_preference}
    */
    readonly routingPreference?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#scale_unit VpnGateway#scale_unit}
    */
    readonly scaleUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#tags VpnGateway#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#virtual_hub_id VpnGateway#virtual_hub_id}
    */
    readonly virtualHubId: string;
    /**
    * bgp_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#bgp_settings VpnGateway#bgp_settings}
    */
    readonly bgpSettings?: VpnGatewayBgpSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#timeouts VpnGateway#timeouts}
    */
    readonly timeouts?: VpnGatewayTimeouts;
}
export interface VpnGatewayBgpSettingsInstance0BgpPeeringAddress {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#custom_ips VpnGateway#custom_ips}
    */
    readonly customIps: string[];
}
export declare function vpnGatewayBgpSettingsInstance0BgpPeeringAddressToTerraform(struct?: VpnGatewayBgpSettingsInstance0BgpPeeringAddressOutputReference | VpnGatewayBgpSettingsInstance0BgpPeeringAddress): any;
export declare function vpnGatewayBgpSettingsInstance0BgpPeeringAddressToHclTerraform(struct?: VpnGatewayBgpSettingsInstance0BgpPeeringAddressOutputReference | VpnGatewayBgpSettingsInstance0BgpPeeringAddress): any;
export declare class VpnGatewayBgpSettingsInstance0BgpPeeringAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnGatewayBgpSettingsInstance0BgpPeeringAddress | undefined;
    set internalValue(value: VpnGatewayBgpSettingsInstance0BgpPeeringAddress | undefined);
    private _customIps?;
    get customIps(): string[];
    set customIps(value: string[]);
    get customIpsInput(): string[] | undefined;
    get defaultIps(): string[];
    get ipConfigurationId(): string;
    get tunnelIps(): string[];
}
export interface VpnGatewayBgpSettingsInstance1BgpPeeringAddress {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#custom_ips VpnGateway#custom_ips}
    */
    readonly customIps: string[];
}
export declare function vpnGatewayBgpSettingsInstance1BgpPeeringAddressToTerraform(struct?: VpnGatewayBgpSettingsInstance1BgpPeeringAddressOutputReference | VpnGatewayBgpSettingsInstance1BgpPeeringAddress): any;
export declare function vpnGatewayBgpSettingsInstance1BgpPeeringAddressToHclTerraform(struct?: VpnGatewayBgpSettingsInstance1BgpPeeringAddressOutputReference | VpnGatewayBgpSettingsInstance1BgpPeeringAddress): any;
export declare class VpnGatewayBgpSettingsInstance1BgpPeeringAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnGatewayBgpSettingsInstance1BgpPeeringAddress | undefined;
    set internalValue(value: VpnGatewayBgpSettingsInstance1BgpPeeringAddress | undefined);
    private _customIps?;
    get customIps(): string[];
    set customIps(value: string[]);
    get customIpsInput(): string[] | undefined;
    get defaultIps(): string[];
    get ipConfigurationId(): string;
    get tunnelIps(): string[];
}
export interface VpnGatewayBgpSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#asn VpnGateway#asn}
    */
    readonly asn: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#peer_weight VpnGateway#peer_weight}
    */
    readonly peerWeight: number;
    /**
    * instance_0_bgp_peering_address block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#instance_0_bgp_peering_address VpnGateway#instance_0_bgp_peering_address}
    */
    readonly instance0BgpPeeringAddress?: VpnGatewayBgpSettingsInstance0BgpPeeringAddress;
    /**
    * instance_1_bgp_peering_address block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#instance_1_bgp_peering_address VpnGateway#instance_1_bgp_peering_address}
    */
    readonly instance1BgpPeeringAddress?: VpnGatewayBgpSettingsInstance1BgpPeeringAddress;
}
export declare function vpnGatewayBgpSettingsToTerraform(struct?: VpnGatewayBgpSettingsOutputReference | VpnGatewayBgpSettings): any;
export declare function vpnGatewayBgpSettingsToHclTerraform(struct?: VpnGatewayBgpSettingsOutputReference | VpnGatewayBgpSettings): any;
export declare class VpnGatewayBgpSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnGatewayBgpSettings | undefined;
    set internalValue(value: VpnGatewayBgpSettings | undefined);
    private _asn?;
    get asn(): number;
    set asn(value: number);
    get asnInput(): number | undefined;
    get bgpPeeringAddress(): string;
    private _peerWeight?;
    get peerWeight(): number;
    set peerWeight(value: number);
    get peerWeightInput(): number | undefined;
    private _instance0BgpPeeringAddress;
    get instance0BgpPeeringAddress(): VpnGatewayBgpSettingsInstance0BgpPeeringAddressOutputReference;
    putInstance0BgpPeeringAddress(value: VpnGatewayBgpSettingsInstance0BgpPeeringAddress): void;
    resetInstance0BgpPeeringAddress(): void;
    get instance0BgpPeeringAddressInput(): VpnGatewayBgpSettingsInstance0BgpPeeringAddress | undefined;
    private _instance1BgpPeeringAddress;
    get instance1BgpPeeringAddress(): VpnGatewayBgpSettingsInstance1BgpPeeringAddressOutputReference;
    putInstance1BgpPeeringAddress(value: VpnGatewayBgpSettingsInstance1BgpPeeringAddress): void;
    resetInstance1BgpPeeringAddress(): void;
    get instance1BgpPeeringAddressInput(): VpnGatewayBgpSettingsInstance1BgpPeeringAddress | undefined;
}
export interface VpnGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#create VpnGateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#delete VpnGateway#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#read VpnGateway#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#update VpnGateway#update}
    */
    readonly update?: string;
}
export declare function vpnGatewayTimeoutsToTerraform(struct?: VpnGatewayTimeouts | cdktf.IResolvable): any;
export declare function vpnGatewayTimeoutsToHclTerraform(struct?: VpnGatewayTimeouts | cdktf.IResolvable): any;
export declare class VpnGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VpnGatewayTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway azurerm_vpn_gateway}
*/
export declare class VpnGateway extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_vpn_gateway";
    /**
    * Generates CDKTF code for importing a VpnGateway resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VpnGateway to import
    * @param importFromId The id of the existing VpnGateway that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VpnGateway to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/vpn_gateway azurerm_vpn_gateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpnGatewayConfig
    */
    constructor(scope: Construct, id: string, config: VpnGatewayConfig);
    private _bgpRouteTranslationForNatEnabled?;
    get bgpRouteTranslationForNatEnabled(): boolean | cdktf.IResolvable;
    set bgpRouteTranslationForNatEnabled(value: boolean | cdktf.IResolvable);
    resetBgpRouteTranslationForNatEnabled(): void;
    get bgpRouteTranslationForNatEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _routingPreference?;
    get routingPreference(): string;
    set routingPreference(value: string);
    resetRoutingPreference(): void;
    get routingPreferenceInput(): string | undefined;
    private _scaleUnit?;
    get scaleUnit(): number;
    set scaleUnit(value: number);
    resetScaleUnit(): void;
    get scaleUnitInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualHubId?;
    get virtualHubId(): string;
    set virtualHubId(value: string);
    get virtualHubIdInput(): string | undefined;
    private _bgpSettings;
    get bgpSettings(): VpnGatewayBgpSettingsOutputReference;
    putBgpSettings(value: VpnGatewayBgpSettings): void;
    resetBgpSettings(): void;
    get bgpSettingsInput(): VpnGatewayBgpSettings | undefined;
    private _timeouts;
    get timeouts(): VpnGatewayTimeoutsOutputReference;
    putTimeouts(value: VpnGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VpnGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
